/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Jun 24 14:11:56 CEST 2004
    copyright            : (C) 2004 by Jens Schulz
    email                : jschulz-lcs@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
<para>Bugs em SuSE 8.2-Linux com KDevelop 2.1.5:</para>

<para>KWappen foi programado com KDevelop 2.1.5 e SuSE 8.2-Linux. O padrão de instalação do KDevelop 2.1.5 não é compatóvel com SuSE 8.2. KDevelop 2.1 precisa do autoconf 2.53/automake 1.6, mas SuSE usa autoconf 2.57/automake 1.7.2.
Você deve instalar o autoconf 2.57/automake 1.7.2 e instalar o autoconf 2.53, automake 1.6 do SuSE Linux 8.0.</para>
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwappen.h"

Kwappen* topW;
Highscore *highS;
HighscoreEdit *highE;
Heraldry *herald;

QString data_path;
QString home_path;

static const char *description =
  I18N_NOOP("Kwappen is a high addictive board game");

int main(int argc, char *argv[])
{
  KAboutData about("kwappen", "KWappen",
  VERSION, description, KAboutData::License_GPL,
                   "Copyright 2004 Jens Schulz",
                   "http://www.lcs-chemie.de",
                   "jschulz-lcs@t-online.de",
                   "Jens Schulz");
   about.addAuthor("Jens Schulz",
                  "Idea and Programming",
                  "jschulz-lcs@t-online.de",
                  "http://www.lcs-chemie.de");
  about.addCredit("Linux User Group Computer Club Elmshorn e.V.","for beta testing",
                  "cce@gmx.de",
                  "http://www.cceev.de");
  KCmdLineArgs::init(argc, argv, &about);

  KApplication app;
  KStandardDirs kdehome;

  KGlobal::dirs()->addResourceType("pictures", KStandardDirs::kde_default("data") + "kwappen/");
  data_path = KGlobal::dirs()->findResourceDir("pictures", "wappen.png");

  home_path = kdehome.localkdedir()+"share/apps/";

  topW = new Kwappen();
  app.setMainWidget(topW);
  topW->topWA(&app);  topW->show();
  topW->set_random();
  highS = new Highscore(topW);
  highE = new HighscoreEdit(topW);
  herald = new Heraldry(topW);
  return app.exec();
}
