// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: iptables.cpp,v 1.1 2004/08/20 20:38:03 mj Exp $
 *
 * Helper class for for Linux 2.4 iptables log entries
 *
 *****************************************************************************
 * Copyright (C) 2000-2003
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include <qstringlist.h>

#include <kdebug.h>

#include "iptables.h"



IPTablesLog::IPTablesLog()
    : m_data()
{}



IPTablesLog::IPTablesLog(const IPTablesLog &l)
    : m_data(l.m_data)
{}



IPTablesLog::~IPTablesLog()
{}



void IPTablesLog::parseLog(const QString &line)
{
//    kdDebug() << "IPTablesLog::parseLog()" << endl;
    
    m_data.clear();
    QStringList toks = QStringList::split(' ', line);

    for(QStringList::Iterator it = toks.begin(); it != toks.end(); it++)
    {
//	kdDebug() << "    " << (*it).latin1() << endl;

	QStringList tok1 = QStringList::split('=', (*it));
	QStringList::Iterator it1 = tok1.begin();
	QString key, val;
	if(it1 != tok1.end()) 
	{
	    key = (*it1);
	    it1++;
	}
	if(it1 != tok1.end()) 
	{
	    val = (*it1);
	    it1++;
	}

	if(!key.isNull() && !key.isEmpty()) 
	{
	    if(val.isNull())
		val = "";
//	    kdDebug() << "    key=" << key << " val=" << val << endl;
	    m_data.insert(key, val);
	}
    }
}



bool IPTablesLog::eq(const IPTablesLog &l)
{
    return m_data["SRC"]   == l.m_data["SRC"]
	&& m_data["DST"]   == l.m_data["DST"]
	&& m_data["PROTO"] == l.m_data["PROTO"]
	&& m_data["SPT"]   == l.m_data["SPT"]
	&& m_data["DPT"]   == l.m_data["DPT"];
}



QString IPTablesLog::srcAddr()
{
    //FIXME: reverse resolve IP
    return m_data["SRC"];
}

QString IPTablesLog::dstAddr()
{
    return m_data["DST"];
}

QString IPTablesLog::srcPort()
{
    return m_data["SPT"];
}

QString IPTablesLog::dstPort()
{
    //FIXME: add service name
    return m_data["DPT"];
}
