// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: iptables.h,v 1.1 2004/08/20 20:38:03 mj Exp $
 *
 * Helper class for for Linux 2.4 iptables log entries
 *
 *****************************************************************************
 * Copyright (C) 2000-2003
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#ifndef IPTABLES_H
#define IPTABLES_H


#include <qstring.h>
#include <qmap.h>


class IPTablesLog
{
private:
    // member
    QMap<QString, QString> m_data;

public:
    // interface
    IPTablesLog();
    IPTablesLog(const IPTablesLog &);
    ~IPTablesLog();
    
    void parseLog(const QString &);
    bool eq(const IPTablesLog &);

    QString srcAddr();
    QString dstAddr();
    QString srcPort();
    QString dstPort();
    
};



#endif /**IPTABLES_H**/
