// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: klogwidget.h,v 0.18 2004/06/22 20:26:27 mj Exp $
 *
 * QMultiLineEdit based widget for viewing log files
 *
 *****************************************************************************
 * Copyright (C) 2000-2003
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#ifndef KLOGWIDGET_H
#define KLOGWIDGET_H

#include <qmultilineedit.h>
#include <qtimer.h>
#include <qpopupmenu.h>
#include <qfile.h>

#include "kwatchconf.h"

class kwatchMsg;



class KLogFile : public QObject
{
    Q_OBJECT
    friend class KLogWidget;

public:
    KLogFile(const QString &name, QObject *parent, kwatchConf &cf);
    ~KLogFile();
    bool readMore();


signals:
    void moreLines(KLogFile *, QString);
    void checkLine(KLogFile *, QString);
    

private slots:
    void activate();


private:
    // config
    kwatchConf &m_cf;

    // members
    QFile      *m_file;
    char       *m_buf;
};



/**
 * KLogWidget: watch a group of files
 *
 * KLogWidget keeps track of a group of files which are written to
 * somewhere else (e.g. logfiles).
 *
 * @short Log Widget
 * @author Ralph Weichert <Ralph.Weichert@physik.tu-darmstadt.de>
 */
//class KLogWidget : public QMultiLineEdit
class KLogWidget : public QTextEdit
{
    Q_OBJECT

public:
    KLogWidget(QWidget *parent, kwatchConf &cf);
    virtual ~KLogWidget();


public:
    void addFile(const QString &);
    void updateConf();
    void setPopupMenu(QPopupMenu *);
    void clear();
    

public slots:
    void reopen();
    void moreText(KLogFile *, QString);
    void timeout();
    void timeout_idle();
    void logcheck(KLogFile *, QString);


protected:
    void dropEvent(QDropEvent *);
    void dragEnterEvent(QDragEnterEvent *);
    void mousePressEvent(QMouseEvent *);
    virtual QPopupMenu *createPopupMenu(const QPoint &pos);
    virtual QPopupMenu *createPopupMenu();

    
private:
    QString formatName(const QString &name);
    kwatchMsg *nextMsg();

private:
    // config
    kwatchConf       &m_cf;

    // member
    QPopupMenu       *m_popup;
    QTimer           *m_timer;
    QList<KLogFile>  *m_files;
    KLogFile         *m_current;
    int               m_r, m_c;
    QTimer           *m_idle;
    
    // kwatchMsg dialogs
    enum { MAXKWATCHMSG=5 };
    kwatchMsg        *m_msgbox[MAXKWATCHMSG];
    int               m_msgi;
    
};


#endif
