// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: kwatch.h,v 1.6 2004/02/27 21:18:46 mj Exp $
 *
 * Class for kwatch application
 *
 *****************************************************************************
 * Copyright (C) 2000-2003
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#ifndef KWATCH_H
#define KWATCH_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <kmainwindow.h>

#include "klogwidget.h"
#include "kwatchconf.h"
#include "prefs.h"


class KToggleAction;



/**
 * This class serves as the main window for kwatch.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Martin Junius <mj@m-j-s.net>
 * @version 0.1
 */
class kwatch : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    kwatch();

    /**
     * Default destructor
     */
    virtual ~kwatch();


protected:
    void saveConfig();

    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    void readConfig();
    
    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);

    void closeEvent(QCloseEvent *);
    
private slots:
    void reopen();
    void quit();
    void clear();

    void optionsShowMenubar();
    void optionsConfigureKeys();
    void optionsPreferences();


private:
    void setupActions();
    void logtime(const QString &);
    

private:
    // config
    kwatchConf     m_cf;

    // actions
    KToggleAction *m_menubarAction;

    // used widgets
    QPopupMenu    *m_popup;
    KLogWidget    *m_log;
    kwatchPrefs   *m_prefs;
    
};

#endif // KWATCH_H
