/*
Copyright (c) 2000-2003 Lee Thomason (www.grinninglizard.com)

Grinning Lizard Utilities. Note that software that uses the 
utility package (including Lilith3D and Kyra) have more restrictive
licences which applies to code outside of the utility package.


This software is provided 'as-is', without any express or implied 
warranty. In no event will the authors be held liable for any 
damages arising from the use of this software.

Permission is granted to anyone to use this software for any 
purpose, including commercial applications, and to alter it and 
redistribute it freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must 
not claim that you wrote the original software. If you use this 
software in a product, an acknowledgment in the product documentation 
would be appreciated but is not required.

2. Altered source versions must be plainly marked as such, and 
must not be misrepresented as being the original software.

3. This notice may not be removed or altered from any source 
distribution.
*/

#ifndef GLGRAPH_INCLUDED
#define GLGRAPH_INCLUDED

#include "gllist.h"
#include "gldynarray.h"
#include "glinsidelist.h"
#include "glcirclelist.h"


/* 	A class to solve a graph algorith. Vertices and edges, which have a travel cost, in
	a connected system.
*/
class GlGraph
{
  public:

	GlGraph( int numVertex );
	~GlGraph();

	/** Function to add an edge which connects 2 vertices. Will add a bi-connected edge (A to B is
		the same distance as B to A). A pair of vertices can be connected only by a single edge.
	*/
	void AddBiEdge( int source, int dest, int length );

	/** Function to add an edge which connects 2 vertices. Will add a bi-connected edge where
		each edge has its own weight, either of which can be INFINITE.
	*/
	void AddBiEdge( int source, int dest, int lengthSourceToDest, int lengthDestToSource );

	/** Function to add an edge which connects 2 vertices. Will add a one way edge. 
		A pair of vertices can be connected only by a single edge.
	*/
	void AddEdge( int source, int dest, int length );

	/** Get the shortest path from source to dest.
		@param	nextVertex	The vertex to go to. It will be adjacent to 'source'
		@param	length		The distance to the next vertex.
		@param	distance	The distance to the destination vertex.
	*/
	void GetPath( int source, int dest, int *nextVertex, int* length, int *distance );

	#ifdef DEBUG
		void DumpVertex();
	#endif

  private:
	struct DataPoint
	{
		int		distance;	// from the DataPoint to the destination
		int		vertex;		// the vertex to take
	};

	struct Edge
	{
		int lengthTo;	// how long the edge is, from the source vertex to 'toVertex'
		int lengthFrom;	// how long the edge is, from the 'toVertex' back to the source
		int toVertex;	// which vertex this edge goes to

		bool operator==( const Edge& rhs )	{ return lengthTo == rhs.lengthTo && lengthFrom == rhs.lengthFrom && toVertex == rhs.toVertex; }
	};

	struct Vertex
	{
		Vertex() : destinationCalculated( false ) {}

		bool			destinationCalculated;
		GlSList< Edge > edgeList;
	};
	
	void LowerAddEdge( int v0, int v1, int length0to1, int length1to0 );
	void ShortestPathCalc( int destVertex );
	DataPoint* GetDataPoint( int source, int dest )	{ return ( dataPoint + dest * numVertex + source ); }
	int FindCheapest( GlCircleList<int>* set, int dest );

	enum {
		GL_INFINITE = 0x1000000
	};

	int					numVertex;
	Vertex				*vertex;
	DataPoint			*dataPoint;
};


#endif


