/*
Copyright (c) 2000-2003 Lee Thomason (www.grinninglizard.com)

Grinning Lizard Utilities. Note that software that uses the 
utility package (including Lilith3D and Kyra) have more restrictive
licences which applies to code outside of the utility package.


This software is provided 'as-is', without any express or implied 
warranty. In no event will the authors be held liable for any 
damages arising from the use of this software.

Permission is granted to anyone to use this software for any 
purpose, including commercial applications, and to alter it and 
redistribute it freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must 
not claim that you wrote the original software. If you use this 
software in a product, an acknowledgment in the product documentation 
would be appreciated but is not required.

2. Altered source versions must be plainly marked as such, and 
must not be misrepresented as being the original software.

3. This notice may not be removed or altered from any source 
distribution.
*/

#ifdef _WIN32
	#include <windows.h>
#endif

#include <algorithm>
#include <stdio.h>
#include "SDL.h"
#include "gldebug.h"
#include "glperformance.h"

GlPerformance::PerfData GlPerformance::map[ MAX_DATA ];
int GlPerformance::numMap = 0;


GlPerformance::GlPerformance( const char* measure ) 
	: name( measure )
{
	// Get our name out of the map, create if it doesn't exist.
	data = 0;
	for( int i=0; i<numMap; ++i )
	{
		if ( map[i].name == name )
		{
			data = &map[i];
		}
	}
	if ( !data )
	{
		GLASSERT( numMap < MAX_DATA );
		data = &map[numMap];
		map[numMap].count = 0;
		map[numMap].name  = name;
		map[numMap].totalTime = 0;
		++numMap;
	}
	++data->count;
	#ifdef _WIN32
		QueryPerformanceCounter( (LARGE_INTEGER*) (&start) );
	#else
		start = SDL_GetTicks();
	#endif
}


GlPerformance::~GlPerformance()
{
	#ifdef _WIN32
		QueryPerformanceCounter( (LARGE_INTEGER*) (&end) );
	#else
		end = SDL_GetTicks();
	#endif

	S64 delta = ( end - start );
	GLASSERT( delta >= 0 );
	data->totalTime += delta;
}


void GlPerformance::Dump( FILE* fp )
{
	S64 freq;
	double dfreq;

	#ifdef _WIN32
		QueryPerformanceFrequency( (LARGE_INTEGER*) (&freq) );
	#else
		freq = 1000;
	#endif

	dfreq = double( freq ) / 1000.0;
	double total = 0.0;

	std::sort( &map[0], &map[numMap] );

	int i;
	for( i=0; i<numMap; ++i )
	{
		total += map[i].totalTime;
	}

	for( i=0; i<numMap; ++i )
	{
		fprintf( fp, "%26s calls=%8d time=%10.2f time/call=%10.2f percent=%.1f%%\n",
				map[i].name.c_str(),
				map[i].count,
				double( map[i].totalTime ) / dfreq,
				double( map[i].totalTime ) / ( double( map[i].count ) * dfreq ),
				100.0 * double( map[i].totalTime ) / total );
	}
	fprintf( fp, "Total time: %.2f\n", total / dfreq);
}
