/*
Copyright (c) 2000-2003 Lee Thomason (www.grinninglizard.com)

Grinning Lizard Utilities. Note that software that uses the 
utility package (including Lilith3D and Kyra) have more restrictive
licences which applies to code outside of the utility package.


This software is provided 'as-is', without any express or implied 
warranty. In no event will the authors be held liable for any 
damages arising from the use of this software.

Permission is granted to anyone to use this software for any 
purpose, including commercial applications, and to alter it and 
redistribute it freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must 
not claim that you wrote the original software. If you use this 
software in a product, an acknowledgment in the product documentation 
would be appreciated but is not required.

2. Altered source versions must be plainly marked as such, and 
must not be misrepresented as being the original software.

3. This notice may not be removed or altered from any source 
distribution.
*/

#ifndef GL_PERFORMANCE_MEASURE
#define GL_PERFORMANCE_MEASURE

#include "gltypes.h"
#include "glmap.h"


class GlPerformance
{
  public:
	GlPerformance( const char*	measure );
	~GlPerformance();

    static void Dump( FILE* fp );
  
  private:
	struct PerfData
	{
		PerfData() { count = 0; totalTime = 0; }

		U32 count;
		S64 totalTime;
		std::string name;

		bool operator<( const PerfData& rhs ) const
		{
			return ( rhs.totalTime < totalTime );
		}

		bool operator==( const PerfData& rhs ) const
		{
			return ( rhs.totalTime == totalTime );
		}
	};

	enum {
		MAX_DATA = 30
	};
	static PerfData map[ MAX_DATA ];
	static int numMap;
	
	std::string name;
	PerfData*	data;
	S64			start;
	S64			end;
};
		

#endif
