/*
Copyright (c) 2000-2003 Lee Thomason (www.grinninglizard.com)

Grinning Lizard Utilities. Note that software that uses the 
utility package (including Lilith3D and Kyra) have more restrictive
licences which applies to code outside of the utility package.


This software is provided 'as-is', without any express or implied 
warranty. In no event will the authors be held liable for any 
damages arising from the use of this software.

Permission is granted to anyone to use this software for any 
purpose, including commercial applications, and to alter it and 
redistribute it freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must 
not claim that you wrote the original software. If you use this 
software in a product, an acknowledgment in the product documentation 
would be appreciated but is not required.

2. Altered source versions must be plainly marked as such, and 
must not be misrepresented as being the original software.

3. This notice may not be removed or altered from any source 
distribution.
*/


#ifndef IO_UTIL_INCLUDED
#define IO_UTIL_INCLUDED

#pragma warning ( disable : 4786 )
#include "gltypes.h"


//#ifdef _MSC_VER
//	#define OPTIMIZE_NO_ALIAS_ON optimize ( "w", on )
//#else
//	#define OPTIMIZE_NO_ALIAS_ON 
//#endif
//
//
//#ifdef _MSC_VER
//	#define OPTIMIZE_NO_ALIAS_OFF optimize ( "w", off )
//#else
//	#define OPTIMIZE_NO_ALIAS_OFF 
//#endif


template <class T> inline T		GlMin( T a, T b )		{ return ( a < b ) ? a : b; }
template <class T> inline T		GlMax( T a, T b )		{ return ( a > b ) ? a : b; }
template <class T> inline T		GlMin( T a, T b, T c )	{ return GlMin( a, GlMin( b, c ) ); }
template <class T> inline T		GlMax( T a, T b, T c )	{ return GlMax( a, GlMax( b, c ) ); }


template <class T> inline void	GlSwap( T& a, T& b )	{ T temp; temp = a; a = b; b = temp; }
template <class T> inline bool	GlInRange( T a, T lower, T upper )	{ return a >= lower && a <= upper; }
template <class T> inline T		GlClamp( const T& a, T lower, T upper )	
								{ 
									if ( a < lower )
										return lower;
									else if ( a > upper )
										return upper;
									return a;
								}
template <class T> inline T GlInterpolate( T rangeLow, T rangeHigh, T rangeVal,
										   T low, T high )
{
	return ( ( ( rangeVal - rangeLow ) * ( high - low ) / ( rangeHigh - rangeLow ) ) ) + low;
}


/*	A class to store a set of bit flags, and set and get them in a standard way.
	Class T must be some kind of integer type.
*/
template < class T >
class GlFlag
{
  public:
	GlFlag()							{ store = 0; }

	inline void Set( T flag )			{ store |= flag; }
	inline void Clear( T flag )			{ store &= ~flag; }
	inline bool IsSet( T flag ) const	{ return ( store & flag ) != 0; }

	inline U32  ToU32() const			{ return store; }
	inline void FromU32( U32 s )		{ store = (T) s; }

	inline void ClearAll()				{ store = 0; }

  private:
	T store;
};	

/*	A strange class: it creates bitmaps used for collision detection. Given
	an unsigned something, this is a utility class to pack bits...starting
	with the highest bit.
*/

template < class T >
class GlHighBitWriter 
{
  public:
	enum
	{
		MAXBIT = ( sizeof(T)*8-1 ),
		NUMBIT = ( sizeof(T)*8 ),
		ALLSET = T( -1 )
	};

	GlHighBitWriter( T* _data ) : data( _data ), bitPos( MAXBIT )	{}

	void Skip()
	{
		if ( bitPos == 0 )
		{
			++data;
			bitPos = MAXBIT;
		}
		else
		{
			--bitPos;
		}
	}

	void Skip_N( unsigned n )
	{
		bitPos -= n % NUMBIT;
		if ( bitPos < 0 )
		{
			bitPos += NUMBIT;
			++data;
		}
		data += n / NUMBIT;
	}
	
	void Push_1()	
	{
		*data |= ( 1 << bitPos );
		Skip();
	}

	void Push_1N( unsigned n )
	{
		// Push bits to T boundary
		while( n && bitPos != MAXBIT )
		{
			Push_1();
			--n;
		}

		// Write Full T size
		while( n >= NUMBIT )
		{
			*data = ALLSET;
			++data;
			n -= NUMBIT;
		}

		// Write the remainder
		while ( n )
		{
			Push_1();
			--n;
		}
	}

  private:
	T*	data;
	int bitPos;
};




#endif
