/**
 *  @file    instruction.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  01/02/2002
 *  @version 0.2
 *    @date  28/02/2002 - object structure definition

 *  instructions declaration
 */
#ifndef _INSTR_H_
#define _INSTR_H_

#include <gtk/gtk.h>
#include "class.h"
#include "op.h"

/*>> instructions structure                                                  */
struct s_instr {
  struct s_class class;  /**< instruction class heritage                     */

  op_t op;               /**< instruction operator                           */

  struct s_class *arg1;  /**< 1st argument                                   */
  struct s_class *arg2;  /**< 2d argument                                    */
};

/*>>> macros                                                                 */
#define INSTR(class)        ((struct s_instr *)class)
#define INSTR_TYPE(const)   CLASS_TYPE(const)

#define instr_free(instr)   (instr_free_from_list(instr, NULL))

/*>>> functions prototypes                                                   */
struct s_instr *instr_alloc(op_t, classtype_t, 
                            struct s_class *, struct s_class *);
void instr_free_from_list(gpointer, gpointer);
#ifdef DEBUG
void instr_debug(gpointer, gpointer);
gchar *instr_subdebug(struct s_instr *);
#endif
#endif /* _INSTR_H_ */
