/**
 *  @file    list.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  28/02/2002 - object structure definition

 *  lists definitions
 */
#ifndef _LIST_H_
#define _LIST_H_

#include <gtk/gtk.h>
#include "class.h"

typedef void(*free_t)(gpointer, gpointer);

/* lists definition                                                          */
struct s_list {
  struct s_class class;  /**< lists class heritage                           */
  GSList *GTKList;       /**< gtk list                                       */

  free_t free;           /**< the fonctions to free each list elements       */
};

/*>>> macros                                                                 */
#define LIST(class)        ((struct s_list *)class)
#define LIST_TYPE(const)   CLASS_TYPE(const)

#define list_append(list, data)                                               \
  (LIST(list)->GTKList = g_slist_append(LIST(list)->GTKList, data))

/*>>> functions prototypes                                                   */
struct s_list *list_alloc(free_t);
void list_free(struct s_list *);

#ifdef DEBUG
gchar *list_subdebug(struct s_list *);
#endif

#endif /* _LIST_H_ */
