/*
 *
 *
 */

#ifndef __TURTLE_H__
#define __TURTLE_H__

#include <gtk/gtk.h>
#include <math.h>

typedef enum {
  LANG_FRENCH,
  LANG_ENGLISH
} lang_t;


/*>> define the turtle                                                       */
struct s_turtle {
  gdouble x,y;              /*>> turtle position (starting from top-left)    */
  gdouble angle;            /*>> turtle-head angle (0 eq 0h00)              */
  gdouble virtual_heading;  /*>> angle value in degrees                      */
  
  gboolean trace;           /*>> pen tracing during turtle moves (Y/N)       */
  GdkColor pencolor;        /*>> color of the turtle pen                     */

  int delay;                /*>> delay between 2 steps of drawings 
  			         (in nanoseconds)                            */

  GtkWidget *source_txt,
            *debug_txt,
            *drawing_field,
            *notebook,
            *status,
            *filesel,
            *saveassel;

  GdkPixmap *pixmap;        /*>> background pixmap. Used for drawings        */
  GdkPixmap *animator;      /*>> turtle animator pixmap                      */
  int anix, aniy;

  GdkGC *gc;

  //  GSList *instructions;     
  GSList *procedures;       /*>> list or procedures                          */

  struct s_proc *main_proc; /*>> main procedure                              */
  struct s_proc *cur_proc;  /*>> current procedure. used for compilation     */

  //  GSList *variables;        /*>> global variables list                       */

  lang_t language;
  GdkFont *font;

  //#ifdef DEBUG
  gboolean compile;
  gboolean draw;
  //#endif

  gboolean compilation_failed;

  GtkAdjustment *hadj, *vadj;
};


#ifndef G_PI
#  define G_PI   M_PI
#endif

#define BASE_CAP (-(M_PI/2))

#define COLOR_BLACK        0
#define COLOR_BLUE         1
#define COLOR_GREEN        2
#define COLOR_CYAN         3
#define COLOR_RED          4
#define COLOR_MAGENTA      5
#define COLOR_YELLOW       6
#define COLOR_WHITE        7
#define COLOR_BROWN        8
#define COLOR_LIGHTBROWN   9
#define COLOR_MIDGREEN    10
#define COLOR_BLUEGREEN   11
#define COLOR_SALMON      12
#define COLOR_BLUEISH     13
#define COLOR_ORANGE      14
#define COLOR_OR          15


int frlex(void);
int enlex(void);
#endif /* __TURTLE_H__ */
