/**
 *  @file    constant.c
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  10/02/2002

 *  constants management.
 */
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdarg.h>
#include <gtk/gtk.h>
#include "constant.h"

/**
   constant allocation.<br>

   <b>visibility :: <i>public</i></b>

   @remarks
            1. do not use this function, but the wrapper const_alloc(...)
               to set constant type and value

   @return  the allocated constant
 */
struct s_constant *__const_alloc(void)
{
  struct s_constant *myconst = _XNEW0(struct s_constant, 1);

  CLASS(myconst)->classtype = CLASS_CONST;
  CLASS(myconst)->refcnt = 0;
  return(myconst);
}


/**
   constant freeing.<br>

   <b>visibility :: <i>public</i></b>

   @param   myconst                      the constant to free
   @return  <none>
 */
void const_free(struct s_constant *myconst)
{
  if(--(CLASS(myconst)->refcnt) == 0)
    {
      value_unset(CLASS_VALUE(myconst));
      _XFREE(myconst);
    }
}


#ifdef DEBUG
gchar *const_subdebug(struct s_constant *myconst)
{
  return(value_subdebug(CLASS_VALUE(myconst)));
}
#endif
