/*

   -*- 2002/03/09: fix a bug into the 'make_button' function:
                     style must be initialized with 'gtk_widget_get_style'
                   fix a warning: 'null colormap' by allocation a colormap
                     with 'gdk_colormap_get_system()'
 
 */

/*      Copyright (C) 2002 Guillaume Bour <gbour@nomade.fr>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "turtle.h"

#ifdef PIXMAPDIR
#define XPM_DIR(file) PIXMAPDIR"/"file
#else
#error "PIXMAPDIR is not defined"
#endif


GtkWidget *make_button(GtkWidget *parent, gchar *label_cnt, gchar *xpm_file)
{
  GtkWidget 
    *button,
    *vbox,
    *pixmapwid,
    *separator,
    *label;
  GdkPixmap *pixmap;
  GdkBitmap *mask = NULL;
  GtkStyle *style = NULL;
  GdkColormap *colormap;

  button = gtk_button_new();
  gtk_widget_set_usize(GTK_WIDGET(button), 80, 45);
  gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);

  vbox = gtk_vbox_new(FALSE, 0);
  //gtk_widget_set_size_request(GTK_WIDGET(vbox), 100, 100);
  gtk_container_add(GTK_CONTAINER(button), vbox);  
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 1);
  gtk_widget_show(vbox);

  /* ajout du pixmap */
  colormap = gdk_colormap_get_system();
  style = gtk_widget_get_style(parent);
  pixmap = gdk_pixmap_colormap_create_from_xpm(parent->window, 
					       colormap,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       xpm_file);
  pixmapwid = gtk_pixmap_new(pixmap, mask);
  gtk_box_pack_start(GTK_BOX(vbox), pixmapwid, FALSE, FALSE, 1);
  gtk_widget_show(pixmapwid);

  /* ajout du label */
  label = gtk_label_new(label_cnt);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);

  return(button);
}

GtkWidget *create_main_window (void)
{
  GtkWidget 
    *main_window,
    *vbox1,
    *btns_handlebox,
    *hbox1,
    *btn_quit,
    *btn_open,
    *btn_save,
    *btn_help,
    *sep,
    *cpane,
    *pane,
    *notebook,
    *green,
    *drawgreen,
    *dbg_code,
    *txt_code,
    *hbox2,
    *btn_exec,
    *status,
    *filesel, *saveassel,
    *scw,
    *debug_menu,
    *debug_item,
    *switch_item,
    *draw_item,
    *mem_item,
    *menu_bar,
    *lang_menu,
    *lang_item,
    *chooselang_item,
    *about_item,
    *turtled,
    *scbh, *scbv, *vport;

  /* fentre du programme */
  main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  //  gtk_window_set_title(GTK_WINDOW(main_window), " --- la tortue logo ---");
  gtk_window_set_title(GTK_WINDOW(main_window), WINDOW_TITLE);
  gtk_window_set_default_size(GTK_WINDOW(main_window), 750, 500);
  gtk_signal_connect(GTK_OBJECT(main_window), "delete_event",
		     GTK_SIGNAL_FUNC(quit_event), NULL);
  gtk_signal_connect(GTK_OBJECT(main_window), "destroy",
		     GTK_SIGNAL_FUNC(destroy), NULL);
  gtk_signal_connect (GTK_OBJECT(main_window),"show",
		      (GtkSignalFunc) window_configure_event2, NULL);

  //  gtk_widget_show(main_window);
  /* 4 emplacements verticaux */
  vbox1 = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(vbox1), 2);
  gtk_container_add(GTK_CONTAINER(main_window), vbox1);
  gtk_widget_show(vbox1);


  menu_bar = gtk_menu_bar_new ();
  gtk_box_pack_start(GTK_BOX(vbox1), menu_bar, FALSE, FALSE, 1);
  gtk_widget_show(menu_bar);

#ifdef DEBUG
  debug_menu = gtk_menu_new();    /* Don't need to show menus */
  
  /* Create the menu items */
  switch_item = 
    gtk_menu_item_new_with_label("Swith Debug Window/Drawing Area");
  
  /* Add them to the menu */
  gtk_menu_append(GTK_MENU(debug_menu), switch_item);

  /* Attach the callback functions to the activate signal */
  gtk_signal_connect_object(GTK_OBJECT(switch_item), "activate",
			    GTK_SIGNAL_FUNC(switchitem_response),
			    (gpointer) NULL);
  
  /* We do need to show menu items */
  gtk_widget_show(switch_item);


  draw_item = 
    gtk_menu_item_new_with_label("Draw picture");
  gtk_menu_append(GTK_MENU(debug_menu), draw_item);
  gtk_signal_connect_object(GTK_OBJECT(draw_item), "activate",
			    GTK_SIGNAL_FUNC(drawitem_response),
			    (gpointer) NULL);
  gtk_widget_show(draw_item);

#ifdef MEMPROOF
  mem_item = 
    gtk_menu_item_new_with_label("Mem proof");
  gtk_menu_append(GTK_MENU(debug_menu), mem_item);
  gtk_signal_connect_object(GTK_OBJECT(mem_item), "activate",
			    GTK_SIGNAL_FUNC(memitem_response),
			    (gpointer) NULL);
  gtk_widget_show(mem_item);
#endif

  debug_item = gtk_menu_item_new_with_label("xxx Debug xxx");
  gtk_widget_show(debug_item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(debug_item), debug_menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), debug_item);
#endif

  lang_menu = gtk_menu_new();    
  lang_item = gtk_menu_item_new_with_label("Choose your language");
  gtk_widget_show(lang_item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(lang_item), lang_menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), lang_item);

  /* must implement it dynamically */
  /* must check the cedille  */
  chooselang_item = 
    gtk_menu_item_new_with_label("Francais");
  gtk_menu_append(GTK_MENU(lang_menu), chooselang_item);
  gtk_signal_connect_object(GTK_OBJECT(chooselang_item), "activate",
			    GTK_SIGNAL_FUNC(choose_french),
			    (gpointer) NULL);
  gtk_widget_show(chooselang_item);

  chooselang_item = 
    gtk_menu_item_new_with_label("English");
  gtk_menu_append(GTK_MENU(lang_menu), chooselang_item);
  gtk_signal_connect_object(GTK_OBJECT(chooselang_item), "activate",
			    GTK_SIGNAL_FUNC(choose_english),
			    (gpointer) NULL);
  gtk_widget_show(chooselang_item);


  /* empty item */
  about_item = gtk_menu_item_new_with_label("                                                                                                                                    ");
  gtk_widget_set_sensitive(about_item, FALSE);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), about_item);
  gtk_widget_show(about_item);
  
  /* about menu */
  about_item = 
    gtk_menu_item_new_with_label(" propos");
  //gtk_menu_item_right_justified(about_item);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), about_item);
  gtk_signal_connect_object(GTK_OBJECT(about_item), "activate",
			    GTK_SIGNAL_FUNC(about_box),
			    (gpointer) NULL);
  gtk_widget_show(about_item);



  /*>>> barre de menus        */
  btns_handlebox = gtk_handle_box_new();
  gtk_widget_set_usize(btns_handlebox, -1, 55);
  gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(btns_handlebox), GTK_SHADOW_OUT);
  gtk_container_set_border_width(GTK_CONTAINER(btns_handlebox), 2);
  gtk_box_pack_start(GTK_BOX(vbox1), btns_handlebox, FALSE, FALSE, 1);
  gtk_widget_show(btns_handlebox);

  hbox1 = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(hbox1), 0);
  gtk_container_add(GTK_CONTAINER(btns_handlebox), hbox1);
  gtk_widget_show(hbox1);

  //utiliser gtk_button_new_with_mnemonic
  //btn_quit = make_button(main_window, "Quitter", XPM_DIR("quit.xpm"));
  btn_quit = make_button(main_window, "Quit", XPM_DIR("quit.xpm"));
  /* event */
  gtk_signal_connect_object(GTK_OBJECT(btn_quit), "released",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy),
			    GTK_OBJECT(main_window));
  /*
  gtk_signal_connect(GTK_OBJECT(btn_quit), "released",
		     GTK_SIGNAL_FUNC(quit_event), NULL);
  */


  gtk_box_pack_start(GTK_BOX(hbox1), btn_quit, FALSE, FALSE, 1);
  gtk_widget_show(btn_quit);

  sep = gtk_vseparator_new();
  //gtk_widget_set_usize(sep, 2, 1); NE MARCHE PAS
  gtk_box_pack_start(GTK_BOX(hbox1), sep, FALSE, FALSE, 1);
  gtk_container_set_border_width(GTK_CONTAINER(vbox1), 0);
  gtk_widget_show(sep);

  //btn_open = make_button(main_window, "Ouvrir", XPM_DIR("open.xpm"));
  btn_open = make_button(main_window, "Open", XPM_DIR("open.xpm"));
  gtk_signal_connect(GTK_OBJECT(btn_open), "released",
		     GTK_SIGNAL_FUNC(show_clbk), NULL);
  

  gtk_box_pack_start(GTK_BOX(hbox1), btn_open, FALSE, FALSE, 1);
  gtk_widget_show(btn_open);

  sep = gtk_vseparator_new();
  gtk_box_pack_start(GTK_BOX(hbox1), sep, FALSE, FALSE, 1);
  gtk_widget_show(sep);

  //btn_save = make_button(main_window, "Sauvegarder", XPM_DIR("save.xpm"));
  btn_save = make_button(main_window, "Save", XPM_DIR("save.xpm"));
  gtk_signal_connect(GTK_OBJECT(btn_save), "released",
		     GTK_SIGNAL_FUNC(show_clbk2), NULL);


  gtk_box_pack_start(GTK_BOX(hbox1), btn_save, FALSE, FALSE, 1);
  gtk_widget_show(btn_save);

  sep = gtk_vseparator_new();
  gtk_box_pack_start(GTK_BOX(hbox1), sep, FALSE, FALSE, 1);
  gtk_widget_show(sep);


  //btn_help = make_button(main_window, "Aide", XPM_DIR("help.xpm"));
  btn_help = make_button(main_window, "Help", XPM_DIR("help.xpm"));
  gtk_box_pack_end(GTK_BOX(hbox1), btn_help, FALSE, FALSE, 1);
  gtk_widget_show(btn_help);

  sep = gtk_vseparator_new();
  gtk_box_pack_end(GTK_BOX(hbox1), sep, FALSE, FALSE, 1);
  gtk_widget_show(sep);


  turtled = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA(turtled), 100, 55);
  gtk_signal_connect (GTK_OBJECT(turtled), "expose_event",
		      (GtkSignalFunc) (turtled_configure_event), NULL);
  /*  gtk_signal_connect (GTK_OBJECT(turtled),"realize",
		      (GtkSignalFunc) (turtled_configure_event), NULL);
  */
  gtk_box_pack_end(GTK_BOX(hbox1), turtled, FALSE, FALSE, 1);
  gtk_widget_show(turtled);


  /*>>> plateforme centrale: champ de saisie + zone de dessin */
  cpane = gtk_frame_new(NULL);
  gtk_container_set_border_width(GTK_CONTAINER(cpane), 5);
  gtk_frame_set_shadow_type(GTK_FRAME(cpane), GTK_SHADOW_NONE);
  gtk_box_pack_start(GTK_BOX(vbox1), cpane, FALSE, FALSE, 1);
  gtk_widget_show(cpane);


  pane = gtk_hpaned_new();
  gtk_paned_set_handle_size(GTK_PANED(pane), 10);
  gtk_paned_set_gutter_size(GTK_PANED(pane), 15);
  gtk_paned_set_position(GTK_PANED(pane), 450);
  gtk_widget_set_usize (GTK_WIDGET(pane), -1, 400);
  //gtk_container_set_border_width(GTK_CONTAINER(pane), 10);

  txt_code = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(txt_code), TRUE);
  gtk_widget_show(txt_code);

  notebook = gtk_notebook_new();
  //gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_LEFT);
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
  gtk_notebook_set_show_border(GTK_NOTEBOOK(notebook), FALSE);
  gtk_widget_show(notebook);

  green = gtk_frame_new(NULL);
  gtk_widget_show(green);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), green, NULL);

  /* scrollbars ==> scrolledwindow */
  /* !!! on position les scrollbars au milieu */
  scbh = gtk_adjustment_new(/*200.0*/0.0, 0.0, 800.0, 1.0, 10.0, 50.0);
  scbv = gtk_adjustment_new(/*200.0*/0.0, 0.0, 800.0, 1.0, 10.0, 50.0);

  scw = gtk_scrolled_window_new(GTK_ADJUSTMENT(scbh)/*NULL*/, 
				GTK_ADJUSTMENT(scbv)/*NULL*/);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scw), 
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add(GTK_CONTAINER(green), scw);
  gtk_widget_show(scw);

  vport = gtk_viewport_new(GTK_ADJUSTMENT(scbh), GTK_ADJUSTMENT(scbv));
  gtk_container_add(GTK_CONTAINER(scw), vport);
  gtk_widget_show(vport);
  

  drawgreen = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawgreen), 800, 800);
  //  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scw), drawgreen);
  gtk_container_add(GTK_CONTAINER(vport), drawgreen);
  //gtk_widget_show(drawgreen);


  gtk_signal_connect (GTK_OBJECT (drawgreen), "expose_event",
                                       (GtkSignalFunc) expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT (drawgreen), "motion_notify_event",
		      (GtkSignalFunc) motion_notify_event, NULL);
  
  /*  !!! on utilise realize au lieu de configure-event
          car le second est rexcut chaque fois qu'on switch le notebook
      gtk_signal_connect (GTK_OBJECT(drawgreen),"configure_event",
		      (GtkSignalFunc) configure_event, NULL);
  */
  gtk_signal_connect (GTK_OBJECT(drawgreen),"realize",
		      (GtkSignalFunc) configure_event, NULL);



  dbg_code = gtk_text_new(NULL, NULL);
  gtk_widget_show(dbg_code);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dbg_code, NULL);


 
  gtk_paned_add1(GTK_PANED(pane), notebook);
  gtk_paned_add2(GTK_PANED(pane), txt_code);
  gtk_container_add(GTK_CONTAINER(cpane), pane);
  //gtk_box_pack_start(GTK_BOX(cpane), pane, FALSE, FALSE, 1);
  gtk_widget_show(pane);


  /*>>> 1 seconde zone de boutons */
  hbox2 = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(hbox1), 0);

  //  btn_exec = make_button(main_window, "Excuter", XPM_DIR("execute.xpm"));
  btn_exec = make_button(main_window, "Start", XPM_DIR("execute.xpm"));
  gtk_box_pack_end(GTK_BOX(hbox2), btn_exec, FALSE, FALSE, 1);
  gtk_widget_show(btn_exec);

  gtk_signal_connect(GTK_OBJECT(btn_exec), "released",
		     GTK_SIGNAL_FUNC(exec_clb_clb), (gpointer) txt_code);
  

  /*>>> pour terminer, une status bar */
  status = gtk_statusbar_new();
  gtk_box_pack_end(GTK_BOX(vbox1), status, FALSE, FALSE, 1);
  gtk_widget_show(status);


  gtk_box_pack_end(GTK_BOX(vbox1), hbox2, FALSE, FALSE, 1);
  gtk_widget_show(hbox2);

  
  /*>> open-file dialog */
  filesel = gtk_file_selection_new("Open logo source file");
  gtk_signal_connect (GTK_OBJECT(filesel), "destroy",
		      (GtkSignalFunc) destroy, &filesel);
 
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel, filesel);
                   
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION
				       (filesel)->cancel_button),
			    "clicked", (GtkSignalFunc) gtk_widget_hide,
			    GTK_OBJECT (filesel));
  
  //gtk_widget_show(filesel);


  /*>> saveas-file dialog */
  saveassel = gtk_file_selection_new("Save logo program");
  gtk_signal_connect (GTK_OBJECT(filesel), "destroy",
		      (GtkSignalFunc) destroy, &saveassel);
  
  /* Connect the ok_button to file_ok_sel2 function */
  gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(saveassel)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel2, saveassel);
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION
				       (saveassel)->cancel_button),
			    "clicked", (GtkSignalFunc) gtk_widget_hide,
			    GTK_OBJECT (saveassel));
  

  //gtk_widget_show(main_window);

  lafontaine_init(txt_code, dbg_code, drawgreen, notebook, status, filesel,
		  saveassel, scbh, scbv);

  return(main_window);
}
