/*
 */
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "interface.h"
#include "mem.h"

#ifdef MEMPROOF
  guint _alloc_cnt, _free_cnt, _null_free_cnt;
#endif

int main (int argc, char **argv)
{
  GtkWidget *window;

#ifdef MEMPROOF
  _alloc_cnt = 0;
  _free_cnt = 0;
  _null_free_cnt = 0;
#endif

  gtk_init(&argc, &argv);
  gdk_rgb_init ();

  window = create_main_window ();
  gtk_widget_show_all(window);

  gtk_main ();

  mc_free();

#ifdef MEMPROOF
  printf("mem proof: <%d>alloc, <%d>free, <%d>null-free\n", 
	 _alloc_cnt, _free_cnt, _null_free_cnt);
#endif

  return 0;
}

