/**
 *  @file    exec.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  20/03/2002

 *  compiled logo programs execution.
 */
#ifndef _EXEC_H_
#define _EXEC_H_

#include <gtk/gtk.h>
#include "instr.h"

#define TYPE_INFERENCE(type, var) ((type) var) 

struct s_instr *exec_noop(struct s_instr *);
struct s_instr *exec_proccall(struct s_instr *instr);
struct s_instr *exec_return(struct s_instr *instr);
struct s_instr *exec_moveforward(struct s_instr *);
struct s_instr *exec_moveback(struct s_instr *);
struct s_instr *exec_turnright(struct s_instr *);
struct s_instr *exec_turnleft(struct s_instr *);
struct s_instr *exec_setpos(struct s_instr *);
struct s_instr *exec_setheading(struct s_instr *);
struct s_instr *exec_clearscreen(struct s_instr *);
struct s_instr *exec_hideturtle(struct s_instr *);
struct s_instr *exec_showturtle(struct s_instr *);
struct s_instr *exec_hidepen(struct s_instr *);
struct s_instr *exec_showpen(struct s_instr *);
struct s_instr *exec_setpredefcolor(struct s_instr *);
struct s_instr *exec_setuserdefcolor(struct s_instr *);
struct s_instr *exec_notrace(struct s_instr *);
struct s_instr *exec_trace(struct s_instr *);
struct s_instr *exec_write(struct s_instr *);
struct s_instr *exec_stop(struct s_instr *);
struct s_instr *exec_affect(struct s_instr *);
struct s_instr *exec_locaffect(struct s_instr *);
struct s_instr *exec_danse(struct s_instr *);
struct s_instr *exec_sleep(struct s_instr *);
struct s_instr *exec_getheading(struct s_instr *);
struct s_instr *exec_hazard(struct s_instr *);
struct s_instr *exec_repeat(struct s_instr *);
struct s_instr *exec_loopcnt(struct s_instr *);
struct s_instr *exec_if(struct s_instr *);
struct s_instr *exec_else(struct s_instr *);
struct s_instr *exec_while(struct s_instr *);
struct s_instr *exec_jump(struct s_instr *);
struct s_instr *exec_and(struct s_instr *);
struct s_instr *exec_or(struct s_instr *);
struct s_instr *exec_eq(struct s_instr *);
struct s_instr *exec_lt(struct s_instr *);
struct s_instr *exec_gt(struct s_instr *);
struct s_instr *exec_leq(struct s_instr *);
struct s_instr *exec_geq(struct s_instr *);
struct s_instr *exec_add(struct s_instr *);
struct s_instr *exec_sub(struct s_instr *);
struct s_instr *exec_mul(struct s_instr *);
struct s_instr *exec_div(struct s_instr *);
struct s_instr *exec_uneg(struct s_instr *);

#endif /* _EXEC_H_ */
