/**
 *  @file    type.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  20/03/2002

 *  type checking/inference.
 */
#ifndef _TYPE_H_
#define _TYPE_H_

#define VALUE_INFERENCE(wanted_type, retval, arg)\
  ({\
     register gboolean __retok;\
\
     switch(wanted_type)\
       {\
       case T_INT   : __retok = int_inference(retval, arg); break;\
       case T_FLOAT : __retok = float_inference(retval, arg); break;\
       case T_BOOL  : __retok = bool_inference(retval, arg); break;\
       case T_STRING: __retok = string_inference(retval, arg); break;\
       default      : __retok = NULL;\
       }\
\
     __retok;\
  })
#endif /* _TYPE_H_ */
