/**
 *  @file    backdrawing.c
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  20/03/2002

 *  turtle drawing primitives.
 */
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include "turtle.h"


extern struct s_turtle my_turtle;

/**
   draw a simple dot.<br>
   A REVOIR


   <b>visibility :: <i>public</i></b>

   @remarks
            1. a dot is a box of 3 pixel width and 3 pixels height.
	   
   @return  <none>
 */
inline void backdrawing_dot()
{
  GdkRectangle update_rect;
  GdkGC *gc;
  GdkColormap *colormap;

  update_rect.x = (int) (my_turtle.x - 1);
  update_rect.y = (int) (my_turtle.y - 1);
  update_rect.width = 3;
  update_rect.height = 3;

  gc = gdk_gc_new(my_turtle.pixmap);
  colormap = gtk_widget_get_colormap(my_turtle.drawing_field);
  gdk_colormap_alloc_color(colormap, &(my_turtle.pencolor), TRUE, TRUE);

  //gc = gdk_gc_new(my_turtle.drawing_field);
  gdk_gc_set_foreground(gc, &(my_turtle.pencolor));

  gdk_draw_rectangle(my_turtle.pixmap,
		     //my_turtle.drawing_field,
		     //my_turtle.gc,
		     gc,
		     TRUE,
		     update_rect.x, update_rect.y,
		     update_rect.width, update_rect.height);

  gtk_widget_draw(GTK_WIDGET(my_turtle.drawing_field), &update_rect);
  gdk_gc_destroy(gc);
}


void backdrawing_moveforward(int dist)
{
  guint i;
  struct timespec tm;
  
  tm.tv_sec = 0;
  tm.tv_nsec = my_turtle.delay;

  for(i = 0; i < dist; i++)
    {
      my_turtle.x += 2.0 * cos(my_turtle.angle);
      my_turtle.y += 2.0 * sin(my_turtle.angle);
      
      if(my_turtle.trace) 
	{ backdrawing_dot(); }
      
      nanosleep(&tm, NULL);
    }
}


void backdrawing_clearall(void)
{
  GdkGC *gc;
  GdkColormap *colormap;
  GdkRectangle update_rect;

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = ((my_turtle.drawing_field)->allocation).width;
  update_rect.height = ((my_turtle.drawing_field)->allocation).height;


  gdk_draw_rectangle(my_turtle.pixmap,
		     (my_turtle.drawing_field)->style->white_gc,
		     TRUE,
		     update_rect.x, update_rect.y,
		     update_rect.width, update_rect.height);


  gtk_widget_draw(GTK_WIDGET(my_turtle.drawing_field), &update_rect);

  //  my_turtle.x = 0;
  //  my_turtle.y = 0;
  my_turtle.x = ((my_turtle.drawing_field)->allocation).width / 2;
  my_turtle.y = ((my_turtle.drawing_field)->allocation).height / 2;

  my_turtle.angle = BASE_CAP; //0;
  my_turtle.virtual_heading = 0;

  my_turtle.delay = 0; //50000000
  my_turtle.trace = TRUE;

  //default pen color: black
  my_turtle.pencolor.red = 0;
  my_turtle.pencolor.green = 0;
  my_turtle.pencolor.blue = 0;

}

inline void backdrawing_writetext(gchar *text)
{
  GdkGC *gc;
  GdkRectangle update_rect;

  /* refresh all he screen  :< */
  update_rect.x = 0; //(int) (my_turtle.x - 1);
  update_rect.y = 0; //(int) (my_turtle.y - 1);
  update_rect.width = ((my_turtle.drawing_field)->allocation).width;//strlen(text) * 50;
  update_rect.height = ((my_turtle.drawing_field)->allocation).height;//70;

  gc = gdk_gc_new(my_turtle.pixmap);
  gdk_draw_string(my_turtle.pixmap, my_turtle.font, gc,
		  (int) my_turtle.x,
		  //50,
		  (int) my_turtle.y, 
		  //50,
		  text);
  gtk_widget_draw(GTK_WIDGET(my_turtle.drawing_field), &update_rect);
  gdk_gc_destroy(gc);  
}






guint clb_clearscreen(struct s_instr *instr)
{
  GdkGC *gc;
  GdkColormap *colormap;
  GdkRectangle update_rect;
  //GdkColor whitec;

#ifdef DEBUG2
  debug_append("  # executing clb_clearscreen()\n");
#endif

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = ((my_turtle.drawing_field)->allocation).width;
  update_rect.height = ((my_turtle.drawing_field)->allocation).height;

  //gc = gdk_gc_new(my_turtle.pixmap);
  //colormap = gtk_widget_get_colormap(my_turtle.drawing_field);
  //gdk_colormap_alloc_color(colormap, &(my_turtle.pencolor), TRUE, TRUE);

  //gc = gdk_gc_new(my_turtle.drawing_field);
  //whitec.red   = 65535; //predefined_colors[7][0];
  //whitec.green = 65535; //predefined_colors[7][1];
  //whitec.blue  = 65535; //predefined_colors[7][2];
  //gdk_gc_set_foreground(gc, &whitec);

  gdk_draw_rectangle(my_turtle.pixmap,
		     (my_turtle.drawing_field)->style->white_gc,
		     //gc,
		     TRUE,
		     update_rect.x, update_rect.y,
		     update_rect.width, update_rect.height);


  gtk_widget_draw(GTK_WIDGET(my_turtle.drawing_field), &update_rect);
  gdk_gc_destroy(gc);

  my_turtle.x = 0;
  my_turtle.y = 0;
  my_turtle.angle = 0;

  my_turtle.delay = 0; //50000000
  my_turtle.trace = TRUE;

  //default pen color: black
  my_turtle.pencolor.red = 0;
  my_turtle.pencolor.green = 0;
  my_turtle.pencolor.blue = 0;

  return(-1);
}
