
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#ifdef DEBUG
#include <libart_lgpl/art_alphagamma.h>
#include <libart_lgpl/art_filterlevel.h>
#include <libart_lgpl/art_pixbuf.h>
#include <libart_lgpl/art_rgb_pixbuf_affine.h>
#include <libart_lgpl/art_affine.h>
#include <libart_lgpl/art_rgb.h>
#include <libart_lgpl/art_rgb_affine.h>
#include <libart_lgpl/art_rgb_rgba_affine.h>
#endif
//#include <time.h>
#include <unistd.h>
#include "callbacks.h"
#include "interface.h"
#include "turtle.h"
#include "mem.h"



//GdkPixmap *pixmap = NULL;
extern struct s_turtle my_turtle;

gint window_configure_event2(GtkWidget         *widget,
			    GdkEventConfigure *event)
{
  gtk_adjustment_set_value(my_turtle.hadj, 200.0);
  gtk_adjustment_set_value(my_turtle.vadj, 200.0);
}


gint about_box(GtkWidget *widget, GdkEvent *event)
{
  GtkWidget *dial, *label, *btn;

  dial = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dial), " propos ...");
  label = gtk_label_new("\n  + main developper: guillaume bour <gbour@nomade.fr>  \n\n  dedicaced to my little syster, anne-hlne  \n");
  gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_CENTER);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dial)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  btn = gtk_button_new_with_label("Close");
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dial)->action_area),
		      btn, TRUE, TRUE, 0);
  gtk_signal_connect_object(GTK_OBJECT(btn), "released",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy),
			    GTK_OBJECT(dial));
  gtk_widget_show(btn);

  gtk_widget_show(dial);
  return TRUE;
}

/* 
   on sauvegarde le code logo
*/
void file_ok_sel2(GtkWidget        *w,
		 GtkFileSelection *fs)
{
  guint pos, size;
  gchar *filename;
  FILE *instream;
  gchar *inbuf;

  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
  //printf("selected file: %s\n", filename);

  instream = fopen(filename, "w");
  inbuf = gtk_editable_get_chars(GTK_EDITABLE(my_turtle.source_txt), 0, -1);  

  fwrite(inbuf, 1, strlen(inbuf), instream);

  fclose(instream);
  g_free(inbuf);
  gtk_widget_hide(my_turtle.saveassel);
}


/* 
   on ouvre le fichier 
   on lit le contenu
   on crit dans le source_txt
*/
void file_ok_sel(GtkWidget        *w,
		 GtkFileSelection *fs)
{
  guint pos, size;
  gchar *filename;
  FILE *instream;
  gchar inbuf[512];

  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
  //printf("selected file: %s\n", filename);

  gtk_editable_delete_text(GTK_EDITABLE(my_turtle.source_txt), 0, -1);
  
  instream = fopen(filename, "r");
  while(!feof(instream))
    {
      size = fread(inbuf, 1, 512, instream);
      //inbuf[size] = 0;

      //printf(":: %s\n", inbuf);

      pos = gtk_text_get_length(GTK_TEXT(my_turtle.source_txt)); 
      gtk_editable_insert_text(GTK_EDITABLE(my_turtle.source_txt),
      inbuf, size /*strlen(inbuf)*/, &pos);
    }

  fclose(instream);
  gtk_widget_hide(my_turtle.filesel);
}



gint configure_event( GtkWidget         *widget,
		      GdkEventConfigure *event )
{
  GdkPixmap *pixmap = NULL, *animator = NULL;
  guchar *pixels;
  gint rowstride;
  GdkPixbuf *image;
  int x, y;

  //printf("configure event\n");

  my_turtle.x = ((my_turtle.drawing_field)->allocation).width / 2;//0;
  my_turtle.y = ((my_turtle.drawing_field)->allocation).height / 2;//0;


  if (pixmap)
    gdk_pixmap_unref(pixmap);
  
  pixmap = gdk_pixmap_new(widget->window,
			  widget->allocation.width,
			  widget->allocation.height,
			  -1);
  gdk_draw_rectangle (pixmap,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      //my_turtle.x - (widget->allocation.width/2),
		      //my_turtle.y - (widget->allocation.height/2),
		      widget->allocation.width,
		      widget->allocation.height);
		      
  /*  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  pixmap,
		  200, 200,
		  0, 0,
		  20, 20);*/
		  /*event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);*/
  

  /* !! cration de l'animator */
  /*=>  image = gdk_pixbuf_new_from_file("./pixmaps/animator.png");

  x = gdk_pixbuf_get_width(image);
  y = gdk_pixbuf_get_height(image);
  my_turtle.anix = x;
  my_turtle.aniy = y;

  animator = gdk_pixmap_new(widget->window, x, y, -1);
  */
  /*  gdk_draw_rectangle (animator,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      widget->allocation.width,
		      widget->allocation.height);
  */
  /*=> gdk_pixbuf_render_to_drawable_alpha(image,
				      animator,
				      0, 0,
				      0, 0, 
				      x, y,
				      GDK_PIXBUF_ALPHA_BILEVEL, 1,
				      GDK_RGB_DITHER_NONE,
				      0, 0);
  my_turtle.animator = animator;
  */
  /*** TESTS: chargement d'un pixbug */
  /*  image = gdk_pixbuf_new_from_file("./pixmaps/turtle.png");

  pixels = gdk_pixbuf_get_pixels(image);
  rowstride = gdk_pixbuf_get_rowstride(image);
  
  */
  /*  gdk_pixbuf_render_to_drawable(image,
				pixmap,
				widget->style->white_gc,
				0, 0,
				10, 10,
				10, 10,
				GDK_RGB_DITHER_NORMAL,
				10, 10);
  */
  /*gdk_draw_rgb_image_dithalign (pixmap,
				widget->style->white_gc,
				20, 20, 
				gdk_pixbuf_get_width(image),
				gdk_pixbuf_get_height(image),
				GDK_RGB_DITHER_NORMAL,
				pixels, rowstride,
				20, 20);

    */
  /* !!!*/
  //  lafontaine_set_pixmap(pixmap);
  my_turtle.pixmap = pixmap;

  return TRUE;
}


gint expose_event(GtkWidget *widget,
		  GdkEventExpose *event )
{
  //  static gboolean first_time = TRUE;
  GdkGC *gc;
  //  GdkColor pencolor;
  //  GdkColormap *colormap;
  gboolean bb[1];
  GdkPixbuf *image;
  guchar *pixels;
  gint rowstride;
  gint x, y, xx, yy;
  double quat[6] = {0.0,0.0,0.0,0.0,0.0,0.0};
  guchar *rgb;

  /*  printf("expose event: %d-%d/%d-%d\n",
	 event->area.x, event->area.y,
	 event->area.width, event->area.height);
  */

  /* pas propre du tout :((( */
  /*  if(first_time)
    {
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      my_turtle.pixmap,
		      200, 200,
		      200, 200,
		      424, 374);
      first_time = FALSE;
      } else {*/
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      my_turtle.pixmap,
		      event->area.x, event->area.y,
		      event->area.x, event->area.y,
		      event->area.width, event->area.height);
      //}

  //gc = gdk_gc_new(widget->window);
  //colormap = gtk_widget_get_colormap(widget);
  
  /*
  if(gdk_colormap_alloc_colors(cmap, &redc, 1, FALSE, FALSE, bb) > 0)
    { printf("color not allocated\n"); exit(0); }
  else
    { printf("pxl: %d\n", redc.pixel); }

  gdk_gc_set_foreground(mgc, &redc);
  gdk_gc_set_background(mgc, &redc);
  */
  /*  printf("expose event on drawing area: %d ::  %d, %d, %d , %d\n",
	 widget, 
	 event->area.x, event->area.y,
	 event->area.width, event->area.height);
  */
  /*=> gdk_draw_line(my_turtle.pixmap, 
		widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		0, 0,
		800, 800);
  */
  /*  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
  */	  //gc,
		  //pixmap,
		  //lafontaine_get_pixmap(),
  /*	  my_turtle.pixmap,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);
  */
  /*
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  my_turtle.animator,
		  0, 0,
		  //event->area.x, event->area.y,
		  30, 30,
		  //event->area.x, event->area.y,
		  //event->area.width, event->area.height);
		  //		  100, 100);
		  my_turtle.anix, my_turtle.aniy);
  */
  /*=>image = gdk_pixbuf_new_from_file("./pixmaps/animator.png");

  x = gdk_pixbuf_get_width(image);
  y = gdk_pixbuf_get_height(image);

  */
  //!!! setting rotation. which direction???
  //rgb = g_new0(guchar,x*y*3);
  //art_affine_rotate (quat, 45.0);
  /*=>art_rgb_rgba_affine (rgb, 20, 20, x,y, x * 3,
		       gdk_pixbuf_get_pixels (image),
		       x, y,
		       gdk_pixbuf_get_rowstride (image),
		       quat,
		       ART_FILTER_NEAREST,
		       NULL);

  */
  //!!!
      //  xx = 800/2 - x/2;
      //  yy = 800/2 - y/2;
  /*
  gdk_pixbuf_render_to_drawable_alpha(image,
				      widget->window,
				      0, 0,
				      xx, yy,
				      //30, 30, 
				      x, y,
				      GDK_PIXBUF_ALPHA_BILEVEL, 1,
				      GDK_RGB_DITHER_NONE,
				      0, 0);
  */
  /*=>gdk_draw_rgb_image(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     xx, yy, x, y, GDK_RGB_DITHER_NORMAL,
		     rgb, x*3);
  */
  /*** TESTS: chargement d'un pixbug */
  /*image = gdk_pixbuf_new_from_file("./pixmaps/turtle.png");
  
  gdk_pixbuf_render_to_drawable(image,
				widget->window,
				widget->style->white_gc,
				0, 0,
				10, 10,
				10, 10,
				GDK_RGB_DITHER_NORMAL,
				10, 10);
  */
  /*gdk_draw_rgb_image_dithalign (pixmap,
				widget->style->white_gc,
				20, 20, 
				gdk_pixbuf_get_width(image),
				gdk_pixbuf_get_height(image),
				GDK_RGB_DITHER_NORMAL,
				pixels, rowstride,
				20, 20);

    */
  /* !!!*/
  
  gdk_flush();
  //  gdk_gc_destroy(gc);
  return FALSE;
}

gint turtled_configure_event(GtkWidget *widget,
			     GdkEventExpose *event )
{
  GdkPixbuf *image;
  int x, y;

  //  printf("turtled_configure\n");
  image = gdk_pixbuf_new_from_file("./pixmaps/turtle2.png");

  x = gdk_pixbuf_get_width(image);
  y = gdk_pixbuf_get_height(image);

  gdk_pixbuf_render_to_drawable_alpha(image,
				      widget->window,
				      //widget->style->white_gc,
				      0, 0,
				      0, 0, 
				      x, y,
				      GDK_PIXBUF_ALPHA_BILEVEL, 10,
				      GDK_RGB_DITHER_NONE,
				      0, 0);
  


  return FALSE;
}

gint motion_notify_event( GtkWidget *widget,
                                                  GdkEventMotion *event )
{
  //  printf("motion notify event\n");                  
  
  return TRUE;
}

void show_clbk(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_widget_show(GTK_WIDGET(my_turtle.filesel));
}

void show_clbk2(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_widget_show(GTK_WIDGET(my_turtle.saveassel));
}

void open_callback(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gchar *filename;

  gtk_widget_hide(data);
  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
  printf("filename: '%s'\n", filename);
}

gint switchitem_response(GtkWidget *widget, GdkEvent *event)
{
  //  printf("switchitem_response callback executed\n");

  /*  if(event->type == GDK_BUTTON_PRESS) 
      {*/
      if(gtk_notebook_get_current_page(GTK_NOTEBOOK(my_turtle.notebook)) == 0)
	{ gtk_notebook_set_page(GTK_NOTEBOOK(my_turtle.notebook), 1); }
      else
	{ gtk_notebook_set_page(GTK_NOTEBOOK(my_turtle.notebook), 0); }
      
      return TRUE;
      //    }

  /* Tell calling code that we have not handled this event; pass it on. */
      //  return FALSE;
}

gint drawitem_response(GtkWidget *widget, GdkEvent *event)
{
  //  printf("drawitem_response callback executed\n");

  my_turtle.draw = !my_turtle.draw;
  return TRUE;
}

#ifdef MEMPROOF
gint memitem_response(GtkWidget *widget, GdkEvent *event)
{
  GtkWidget *dial, *label, *btn;
  gchar *llabel;

  //  printf("memitem_response callback executed\n");

  dial = gtk_dialog_new();

  llabel = g_new(gchar, 50);
  sprintf(llabel, "\n  mem proof: <%d>alloc, <%d>free, <%d>null-free  \n", 
	  _alloc_cnt, _free_cnt, _null_free_cnt);

  label = gtk_label_new (llabel);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dial)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  btn = gtk_button_new_with_label("free mem");
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dial)->action_area),
		      btn, TRUE, TRUE, 0);
  gtk_signal_connect_object(GTK_OBJECT(btn), "released",
			    GTK_SIGNAL_FUNC(free_mem),
			    label);
  gtk_widget_show(btn);

  btn = gtk_button_new_with_label("reset counters");
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dial)->action_area),
		      btn, TRUE, TRUE, 0);
  gtk_signal_connect_object(GTK_OBJECT(btn), "released",
			    GTK_SIGNAL_FUNC(reset_counters),
			    label);
  gtk_widget_show(btn);

  btn = gtk_button_new_with_label("close");
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dial)->action_area),
		      btn, TRUE, TRUE, 0);
  gtk_signal_connect_object(GTK_OBJECT(btn), "released",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy),
			    GTK_OBJECT(dial));
  gtk_widget_show(btn);


  gtk_widget_show(dial);
  // gtk_dialog_run(GTK_DIALOG(dial));

  g_free(llabel);
  return TRUE;
}

gboolean free_mem(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gchar *llabel;
  printf("freeing memory\n");

  mc_free();

  llabel = g_new(gchar, 70);
  snprintf(llabel, 69, 
	   "\n  mem proof: <%d>alloc, <%d>free, <%d>null-free  \n", 
	  _alloc_cnt, _free_cnt, _null_free_cnt);
  gtk_label_set_text(GTK_LABEL(widget), llabel);
  g_free(llabel);
		    
  return(FALSE);
}

gboolean reset_counters(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gchar *llabel;
  printf("reseting counters\n");

  mc_free();
  _alloc_cnt = 0;
  _free_cnt = 0;
  _null_free_cnt = 0;

  llabel = g_new(gchar, 50);
  sprintf(llabel, "\n  mem proof: <%d>alloc, <%d>free, <%d>null-free  \n", 
	  _alloc_cnt, _free_cnt, _null_free_cnt);
  gtk_label_set_text(GTK_LABEL(widget), llabel);
  g_free(llabel);
		    
  return(FALSE);
}

#endif

gint choose_french(GtkWidget *widget, GdkEvent *event)
{
  printf("choose french language\n");

  my_turtle.language = LANG_FRENCH;
  return(TRUE);
}

gint choose_english(GtkWidget *widget, GdkEvent *event)
{
  printf("choose english language\n");

  my_turtle.language = LANG_ENGLISH;
  return(TRUE);
}


/* another callback */
gboolean quit_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  //  printf("quit event\n");
  return(FALSE);
}

void destroy(GtkWidget *widget, gpointer data)
{
  //  printf("destroy event\n");
  gtk_main_quit();
}



void exec_clb_clb(GtkButton *button, gpointer source)
{
  gchar *code;


  /* lecture et affichage de texte */
  code = gtk_editable_get_chars(GTK_EDITABLE(source), 0, -1);
  //  g_message("code lu: '%s'\n", code);
  //gtk_text_insert(dbg, NULL, NULL, NULL, code, -1);
  
  /* initialisation de la compilation */
  mc_init();

  /* lancement de la compilation      */
  gtk_statusbar_push(GTK_STATUSBAR(my_turtle.status), 1, 
		     "*** compiling code source");
  debug_clear();
  launch_parser(code);

  if(my_turtle.compilation_failed)
    {
      gtk_statusbar_push(GTK_STATUSBAR(my_turtle.status), 1, 
			 "*** compilation failed");
      gtk_notebook_set_page(GTK_NOTEBOOK(my_turtle.notebook), 1);
    } else {
      /* affichage du code 3  adresses   */
#ifdef DEBUG1
      mc_debug();
#endif

      /* lancement de l'xcution         */
#ifdef DEBUG
      if(my_turtle.draw)
	{
#endif
	  gtk_statusbar_push(GTK_STATUSBAR(my_turtle.status), 1, 
			     "*** executing compiled code");
	  exec_execute_all();
	}
#ifdef DEBUG
    }
#endif

  /* dessin dans la drawing area */
  /*  if(! launch_parser(code))
    { 
      printf("end of parsing\n");
      lafontaine_draw_all(); 
      exec_all();
    }
  */
}

