
#include <gtk/gtk.h>
#include "turtle.h"

extern struct s_turtle my_turtle;

void lafontaine_init(GtkText *source, GtkText *debug, 
		     GtkDrawingArea *field, GtkNotebook *notebook,
		     GtkStatusbar *status, GtkWidget *filesel, 
		     GtkWidget *saveassel, GtkAdjustment *hadj,
		     GtkAdjustment *vadj)
{
  my_turtle.source_txt = GTK_WIDGET(source);
  my_turtle.debug_txt = GTK_WIDGET(debug);
  my_turtle.drawing_field = GTK_WIDGET(field);
  my_turtle.notebook = GTK_WIDGET(notebook);
  my_turtle.status = GTK_WIDGET(status);
  my_turtle.filesel = GTK_WIDGET(filesel);
  my_turtle.saveassel = GTK_WIDGET(saveassel);

  my_turtle.hadj = hadj;
  my_turtle.vadj = vadj;



  // we should place the turtle in the center of the drawing area,
  // pointing to 0h00
  my_turtle.x = ((my_turtle.drawing_field)->allocation).width / 2;//0;
  my_turtle.y = ((my_turtle.drawing_field)->allocation).height / 2;//0;
  //  printf("position: %d, %d\n", my_turtle.x, my_turtle.y);
  my_turtle.angle = BASE_CAP; //0;
  my_turtle.virtual_heading = 0;

  my_turtle.delay = 0; //50000000
  my_turtle.trace = TRUE;

  //default pen color: black
  my_turtle.pencolor.red = 0;
  my_turtle.pencolor.green = 0;
  my_turtle.pencolor.blue = 0;
  my_turtle.language = LANG_FRENCH; //LANG_ENGLISH;

  //  my_turtle.instructions = NULL;
  my_turtle.procedures = NULL;
  //  my_turtle.tds = NULL;
  /*  my_turtle.main_procedure = NULL;
      my_turtle.current_procedure = NULL;*/
  my_turtle.main_proc = NULL;
  my_turtle.cur_proc = NULL;


  /* chargement de la font */
  my_turtle.font = gdk_font_load("-xxl-*-*-*-*-*-*-*-*-*-*-*-*");

  my_turtle.compile = TRUE;
  my_turtle.draw = FALSE;

  //  my_turtle.gc = gdk_gc_new(my_turtle.pixmap);
  //  gdk_gc_set_foreground(my_turtle.gc, &(my_turtle.pencolor));
}

