/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
/*
  FIXME:
    + on ne peut pas comparer 2 boolens (vrai = vrai)
    + on ne peut pas comparer 2 chaines  ("a = "a)
 */  
  %{
    #include <stdio.h>
    #include <gtk/gtk.h>
    #include "turtle.h"
    #include "mc.h"
    #include "op.h"
    #include "list.h"
    #include "constant.h"
    #include "variable.h"

    guint linecnt;
    gchar *input_str;
    guint curpos;

    extern struct s_turtle my_turtle;

    typedef int(*lexlang_t)(void);
    lexlang_t lexlang[2] = {
      frlex,
      enlex
    };

    GSList *repeat_instr = NULL;
    guint loop_ref;

    char *lextxt;
  %}

%union {
  guint intval;
  gdouble floatval;
  gboolean boolval;
  gchar *strval;

  GSList *list;
  struct s_class *mc;
}

%token            TOK_BEGPROC      TOK_ENDPROC
%token <strval>   TOK_PROCNAME     TOK_VARIABLE
%token            TOK_MOVEFORWARD  TOK_MOVEBACK 
%token            TOK_TURNRIGHT    TOK_TURNLEFT
%token            TOK_SETPOS       TOK_SETHEADING
%token            TOK_CLEARSCREEN
%token            TOK_HIDETURTLE   TOK_SHOWTURTLE
%token            TOK_COLOR
%token            TOK_NOTRACE      TOK_TRACE
%token            TOK_WRITE        TOK_STOP
%token            TOK_RETURN
%token            TOK_AFFECT       TOK_LOCALAFFECT 
%token            TOK_DANCE        TOK_SLEEP

%token            TOK_REPEAT       TOK_IF
%token            TOK_WHILE

%token <intval>   TOK_INT
%token <floatval> TOK_FLOAT
%token <boolval>  TOK_BOOL
%token <strval>   TOK_STRING
%token            TOK_LOOPCNT      TOK_HAZARD
%token            TOK_GETHEADING

%type  <list>     arguments
%type  <mc>       arith_expr       bool_expr
%type  <mc>       expression

%token            TOK_LEQ          TOK_GEQ


%left '+' '-'
%left '*' '/'
%left uneg
%left '(' ')'
%%

input:         procedures statements
;

procedures:
             | procedure procedures
;

procedure:     TOK_BEGPROC TOK_PROCNAME 
                 { mc_beginning_procedure($2); }
               parameters statements TOK_ENDPROC
                 { mc_ending_procedure(); }
;

parameters:
             | TOK_VARIABLE
                 { mc_add_proc_parameter($1); }
               parameters
;

statements:
             | statement statements
;

statement:     proc_call
             | repeat_expr
             | if_expr
             | while_expr
	     
             | TOK_MOVEFORWARD arith_expr
                 { mc_add_unary_op(OP_MOVEFORWARD, $2); }
             | TOK_MOVEBACK    arith_expr
                 { mc_add_unary_op(OP_MOVEBACK, $2); }
             | TOK_TURNRIGHT   arith_expr
                 { mc_add_unary_op(OP_TURNRIGHT, $2); }
             | TOK_TURNLEFT    arith_expr
                 { mc_add_unary_op(OP_TURNLEFT, $2); }
             | TOK_SETPOS      '[' arith_expr arith_expr ']'
                 { mc_add_binary_op(OP_SETPOS, $3, $4); }
             | TOK_SETHEADING  arith_expr
                 { mc_add_unary_op(OP_SETHEADING, $2); }
             | TOK_CLEARSCREEN
                 { mc_add_noarg_op(OP_CLEARSCREEN); }
             | TOK_HIDETURTLE
                 { mc_add_noarg_op(OP_HIDETURTLE); }
             | TOK_SHOWTURTLE
                 { mc_add_noarg_op(OP_SHOWTURTLE); }
             //vrifier que l'interval est OK (0  15) =>  l'exec
             | TOK_COLOR arith_expr
                 { mc_add_unary_op(OP_SETPREDEFCOLOR, $2); }
             //vrifier que l'interval est OK (0  255) =>  l'exec
             | TOK_COLOR '[' arith_expr arith_expr arith_expr ']'
                 { 
		   GSList *colors = NULL;
		   struct s_list *mccolors;

		   colors = g_slist_append(colors, $3);
		   colors = g_slist_append(colors, $4);
		   colors = g_slist_append(colors, $5);

		   mccolors = list_alloc(class_free_from_list);
		   mccolors->GTKList = colors;

		   mc_add_unary_op(OP_SETUSERDEFCOLOR, mccolors);
		 }
             | TOK_NOTRACE
                 { mc_add_noarg_op(OP_NOTRACE); }
             | TOK_TRACE
                 { mc_add_noarg_op(OP_TRACE); }
             | TOK_WRITE       expression
                 { mc_add_unary_op(OP_WRITE, $2); }
             | TOK_STOP
                 { mc_add_noarg_op(OP_STOP); }
             | TOK_RETURN      expression
                 { mc_add_unary_op(OP_RETURN, $2); }
             | TOK_AFFECT      TOK_STRING 
                 { $<mc>$ = mc_add_variable(VAR_GLOBAL, $2); }
	       expression
                 { mc_add_binary_op(OP_AFFECT, $<mc>3, $4); }
             | TOK_LOCALAFFECT TOK_STRING 
                 { $<mc>$ = mc_add_variable(VAR_LOCAL, $2); }
               expression
                 { mc_add_binary_op(OP_LOCAFFECT, $<mc>3, $4); }

             | TOK_DANCE
                 { mc_add_noarg_op(OP_DANCE); }
             | TOK_SLEEP
                 { mc_add_noarg_op(OP_SLEEP); }
;

proc_call:     TOK_PROCNAME 
                 { 
		   /* we get the pointer onto the procedure (by its name) */
		   $<mc>$ = mc_find_procedure($1);
		 }
               arguments
                 { 
		   struct s_list *plist = NULL;

		   if($3 != NULL)
		     {
		       plist = list_alloc(class_free_from_list);
		       plist->GTKList = $3;
		     }

		   //~~~
		   mc_add_binary_op(OP_PROCCALL, $<mc>2, plist); 
		 }
;

arguments:       { $$ = NULL; }
             | expression arguments
                 { if($1 != NULL) class_ref($1); $$ = g_slist_prepend($2, $1); }
;

repeat_expr:   TOK_REPEAT 
                 { $<mc>$ = mc_add_noarg_op(OP_NOOP); }
               arith_expr 
                 { 
		   /* warning: the condition is the third argument !! */
		   $<mc>$ = mc_add_binary_op(OP_REPEAT, NULL, $3); 
		   repeat_instr = g_slist_prepend(repeat_instr, $<mc>$);
		   loop_ref = 0;
		 } 
              '[' statements ']'
                 {
		   struct s_class *jmp, *noop;

		   jmp = mc_add_unary_op(OP_JUMP, NULL);
		   mc_update_branch(INSTR(jmp),
				    INSTR($<mc>2));

		   noop = mc_add_noarg_op(OP_NOOP);
		   mc_update_branch((struct s_instr *)$<mc>4, 
				    (struct s_instr *)noop);

		   repeat_instr = g_slist_remove(repeat_instr, $<mc>4);
		 }
;

if_expr:       TOK_IF bool_expr 
                 { $<mc>$ = mc_add_binary_op(OP_IF, NULL, $2); }
               '['  statements ']' 
                 {
		   struct s_class *noop;

		   $<mc>$ = mc_add_unary_op(OP_JUMP, NULL);

		   noop = mc_add_noarg_op(OP_NOOP);
		   mc_update_branch(INSTR($<mc>3),
				    INSTR(noop));
		 }
               else_expr
                 {
		   struct s_class *noop;

		   noop = mc_add_noarg_op(OP_NOOP);
		   mc_update_branch(INSTR($<mc>7),
				    INSTR(noop));
		 }                 
;

else_expr:   
             | '[' statements ']'
;

while_expr:    TOK_WHILE
                 { $<mc>$ = mc_add_noarg_op(OP_NOOP); }
               bool_expr 
                 { 
		   /* warning: the condition is the third argument !! */
		   $<mc>$ = mc_add_binary_op(OP_WHILE, NULL, $3); 
		 } 
               '[' statements ']'
                 {
		   struct s_class *jmp, *noop;

		   jmp = mc_add_unary_op(OP_JUMP, NULL);
		   mc_update_branch(INSTR(jmp),
				    INSTR($<mc>2));

		   noop = mc_add_noarg_op(OP_NOOP);
		   mc_update_branch(INSTR($<mc>4),
				    INSTR(noop));

		 }
;

expression:    TOK_STRING
                 { $$ = mc_add_constant(T_STRING, $1); }
             | bool_expr
                 { $$ = $1; }
             | arith_expr
                 { $$ = $1; }
;

bool_expr:     TOK_BOOL
                 { $$ = mc_add_constant(T_BOOL, $1); }

             | bool_expr '&' bool_expr
                 { $$ = mc_add_binary_op(OP_AND, $1, $3); }
             | bool_expr '|' bool_expr
                 { $$ = mc_add_binary_op(OP_OR, $1, $3); }

             | arith_expr '=' arith_expr
                 { $$ = mc_add_binary_op(OP_EQ, $1, $3); }
             | arith_expr '<' arith_expr
                 { $$ = mc_add_binary_op(OP_LT, $1, $3); }
             | arith_expr '>' arith_expr
                 { $$ = mc_add_binary_op(OP_GT, $1, $3); }
             | arith_expr TOK_LEQ arith_expr
                 { $$ = mc_add_binary_op(OP_LEQ, $1, $3); }
             | arith_expr TOK_GEQ arith_expr
                 { $$ = mc_add_binary_op(OP_GEQ, $1, $3); }
;

arith_expr:    TOK_INT
                 { $$ = mc_add_constant(T_INT, $1); }
             | TOK_FLOAT
                 { $$ = mc_add_constant(T_FLOAT, $1); }
             | TOK_VARIABLE
                 { $$ = mc_add_variable_reference($1); }
             | TOK_LOOPCNT
                 { 
		   struct s_class *repeat;
		   /* we must get the reference to the loop counter !!! */
		   loop_ref++;
		   repeat = g_slist_nth_data(repeat_instr, 0);
		   $$ = mc_add_unary_op(OP_LOOPCNT, repeat); 
		 }
             | TOK_HAZARD     arith_expr
                 { $$ = mc_add_unary_op(OP_HAZARD, $2); }
             | TOK_GETHEADING
                 { $$ = mc_add_noarg_op(OP_GETHEADING); }

             | arith_expr '+' arith_expr
                 { $$ = mc_add_binary_op(OP_ADD, $1, $3); }
             | arith_expr '-' arith_expr
                 { $$ = mc_add_binary_op(OP_SUB, $1, $3); }
             | arith_expr '*' arith_expr
                 { $$ = mc_add_binary_op(OP_MUL, $1, $3); }
             | arith_expr '/' arith_expr
                 { $$ = mc_add_binary_op(OP_DIV, $1, $3); }
             | '-' arith_expr %prec uneg
                 { $$ = mc_add_unary_op(OP_UNEG, $2); }
             | '(' arith_expr ')'
                 { $$ = $2; }
;             
%%

int  launch_parser(gchar *program)
{
  input_str = program;
  curpos = 0;
  linecnt = 0;
  
  my_turtle.compilation_failed = FALSE;
  yyparse();
  
  return(0);
}

void yyerror(char *error)
{  
  my_turtle.compilation_failed = TRUE;
  printf("%d: invalid logo code: '%s'\n", linecnt, lextxt); 
}

/* here we switch between differents languages-parser */
int yylex()
{
  return((*lexlang[my_turtle.language])());
}
