/**
 *  @file    type.c
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  20/03/2002

 *  type checking/inference.
 */
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <math.h>
#include "class.h"
#include "value.h"
#include "list.h"


/* wanted type == int */
gboolean int_inference(gint *retval, struct s_class *arg)
{
  register gboolean retok = TRUE;

  switch(arg->value.valuetype)
    {
    case T_INT   : *retval = arg->value.content.vint; break;
    case T_FLOAT : *retval = (int) rint(arg->value.content.vfloat); break;
    case T_STRING: /* whe could imagine converting string into integer 
		      with atoi */
    default      : retok = FALSE;
    }

  return(retok);
}

/* wanted type == double */
gboolean float_inference(gdouble *retval, struct s_class *arg)
{
  register gboolean retok = TRUE;

  switch(arg->value.valuetype)
    {
    case T_INT   : *retval = (double) arg->value.content.vint; break;
    case T_FLOAT : *retval = arg->value.content.vfloat; break;
    case T_STRING: /* whe could imagine converting string into integer 
		      with atoi */
    default      : retok = FALSE;
    }

  return(retok);
}

/* wanted type == bool */
gboolean bool_inference(gboolean *retval, struct s_class *arg)
{
  register gboolean retok = TRUE;

  switch(arg->value.valuetype)
    {
    case T_BOOL  : *retval = arg->value.content.vbool; break;
    default      : retok = FALSE;
    }

  return(retok);
}

/* wanted type == string */
gboolean string_inference(char **retval, struct s_class *arg)
{
  register gboolean retok = TRUE;

  switch(arg->value.valuetype)
    {
      /* for the moment, we don't make a copy of the string */
    case T_STRING: *retval = arg->value.content.vstring; break;
    case T_INT   :
    case T_FLOAT : /* whe could imagine converting int/float into string */
    default      : retok = FALSE;
    }

  return(retok);
}

/* wanted type == GSList */
gboolean list_inference(GSList *retval, struct s_class *arg)
{
  if(arg->classtype == CLASS_LIST)
    { 
      retval = LIST(arg)->GTKList; 
      return(TRUE);
    } else {
      retval = NULL;
      return(FALSE);
    }
}
