/**
 *  @file    class.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  28/02/2002

 *  Class root class definition
 */
#ifndef _CLASS_H_
#define _CLASS_H_

#include <gtk/gtk.h>
#include "value.h"
#include "mem.h"

/*>>> class types definition                       */
typedef enum {
  CLASS_PROC,             /**< procedure           */
  CLASS_VAR,              /**< variable            */
  CLASS_INSTR,            /**< instruction         */
  CLASS_CONST,            /**< constant            */
  CLASS_LIST              /**< list                */
} classtype_t;

/*>>> class definition                                                       */
struct s_class {
  classtype_t classtype;  /**< class type                                    */
  struct s_value value;   /**< class value                                   */

  gshort refcnt;          /**< class references counter (!! cant be negative)*/
};

/*>>> macros                                                                 */
#define CLASS(noclass)        ((struct s_class *)noclass)
#define CLASS_TYPE(class)     ((CLASS(class))->classtype)
#define CLASS_VALUE(noclass)  ((CLASS(noclass))->value)

#define class_subdebug(noclass)                                               \
  ({                                                                          \
    gchar *str = NULL;                                                        \
                                                                              \
    if(noclass != NULL)                                                       \
      {                                                                       \
        switch(CLASS_TYPE(noclass))                                           \
          {                                                                   \
          case CLASS_PROC : str = proc_subdebug(noclass); break;              \
          case CLASS_VAR  : str = var_subdebug(noclass); break;               \
          case CLASS_INSTR: str = instr_subdebug(noclass); break;             \
          case CLASS_CONST: str = const_subdebug(noclass); break;             \
          case CLASS_LIST : str = list_subdebug(noclass);                     \
          }                                                                   \
								              \
      }                                                                       \
                                                                              \
    str;                                                                      \
  })

#define class_ref(class)    (CLASS(class)->refcnt++)
#define class_unref(class)  (CLASS(class)->refcnt--)

/*>>> functions prototypes                         */
void class_free_from_list(gpointer, gpointer);

#endif /* _CLASS_H_ */
