/**
 *  @file    constant.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  05/02/2002
 *  @version 0.2
 *    @date  28/02/2002 - object structure definition

 *  constant values
 */
#ifndef _CONSTANT_H_
#define _CONSTANT_H_

#include <gtk/gtk.h>
#include "class.h"

/* constants definition                                                      */
struct s_constant {
  struct s_class class;  /**< constants class heritage                       */
};

/*>>> macros                                                                 */
#define CONST(class)        ((struct s_constant *)class)
#define CONST_TYPE(const)   CLASS_TYPE(const)

#define const_alloc(_type, _value)                                            \
  ({                                                                          \
    register struct s_constant *__myconst = __const_alloc();                  \
    value_set(&(CLASS(__myconst)->value), _type, _value);                     \
    __myconst;                                                                \
  }) 

/*>>> functions prototypes                                                   */
struct s_constant *__const_alloc(void);
void const_free(struct s_constant *);
#ifdef DEBUG
gchar *const_subdebug(struct s_constant *);
#endif
#endif /* _CONSTANT_H_ */
