/**
 *  @file    mem.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  28/02/2002

 *  memory managment
 */
#ifndef _MEM_H_
#define _MEM_H_

#include <gtk/gtk.h>


extern guint _alloc_cnt, _free_cnt, _null_free_cnt;

/*>>> macros                                                                 */
#ifdef MEMPROOF
#  ifdef MEMSTAT
#    define _XMEMSTAT(_func)  (printf(#_func": %s::%d\n", __FILE__, __LINE__))
#  else
#    define _XMEMSTAT(_func)  
#  endif

#  define _XNEW(_type, _cnt)                                                  \
          ({ _alloc_cnt++; _XMEMSTAT(_xmem); g_new(_type, _cnt); })
#  define _XNEW0(_type, _cnt)                                                 \
          ({ _alloc_cnt++; _XMEMSTAT(_xmem0); g_new0(_type, _cnt); })
#  define _XSTRDUP(_str)                                                      \
          ({ _alloc_cnt++; _XMEMSTAT(_xstrdup); g_strdup(_str); })
#  define _XMEMDUP(_ptr, _size)                                               \
          ({ _alloc_cnt++; _XMEMSTAT(_xmemdup); g_memdup(_ptr, _size); })
#  define _XFREE(_ptr)                                                        \
   ({                                                                         \
     _ptr == NULL?(_XMEMSTAT(_xfree::null),_null_free_cnt++):                 \
                  (_XMEMSTAT(_xfree::notnull),_free_cnt++,g_free(_ptr));      \
   })

#else
#define   _XNEW(_type, _cnt)   (g_new(_type, _cnt))
#define   _XNEW0(_type, _cnt)  (g_new0(_type, _cnt))
#define   _XSTRDUP(_str)       (g_strdup(_str))
#define   _XMEMDUP(_ptr, _size)(g_memdup(_ptr, _size))
#define   _XFREE(_ptr)         (g_free(_ptr))
#endif

#endif /* _MEM_H_ */
