/**
 *  @file    op.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  05/02/2002

 *  logo langage operations
 */
#ifndef _OP_H_
#define _OP_H_

/*>>> logo operations                          */
typedef enum {
  OP_NOOP,

  OP_PROCCALL,
  OP_RETURN,

  OP_MOVEFORWARD,
  OP_MOVEBACK,
  OP_TURNRIGHT,
  OP_TURNLEFT,
  OP_SETPOS,
  OP_SETHEADING,
  OP_CLEARSCREEN,
  OP_HIDETURTLE,
  OP_SHOWTURTLE,
  OP_HIDEPEN,
  OP_SHOWPEN,
  OP_SETPREDEFCOLOR,
  OP_SETUSERDEFCOLOR,
  OP_NOTRACE,
  OP_TRACE,
  OP_WRITE,
  OP_STOP,
  OP_AFFECT,
  OP_LOCAFFECT,

  OP_DANCE,
  OP_SLEEP,

  OP_GETHEADING,
  OP_HAZARD,

  OP_REPEAT,
  OP_LOOPCNT,
  OP_IF,
  OP_ELSE,
  OP_WHILE,
  OP_JUMP,
  
  OP_AND,
  OP_OR,
  OP_EQ,
  OP_LT,
  OP_GT,
  OP_LEQ,
  OP_GEQ,
  OP_ADD,
  OP_SUB,
  OP_MUL,
  OP_DIV,
  OP_UNEG
} op_t;


#endif /* _OP_H_ */
