/**
 *  @file    proc.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  01/02/2002
 *  @version 0.2
 *    @date  26/02/2002 - adding context

 *  procedures definition
 */
#ifndef __PROC_H__
#define __PROC_H__

#include <gtk/gtk.h>
#include "class.h"
#include "instr.h"
#include "variable.h"

/*>>> procedure definition                                                   */
struct s_proc {
  struct s_class class;  /**< instruction class heritage                     */

  gchar *name;           /**> procedure name                                 */
  GSList *instructions,  /**> list of procedure's instructions               */
         *parameters,    /**> list of procedure's parameters                 */
         *variables;     /**> list of procedure's inner variables            */
  
  GSList *contexts;      /**> procedure contexts                             */
};

/*>>> macros                                                                 */
#define PROC(class)        ((struct s_proc *)class)
#define PROC_TYPE(const)   CLASS_TYPE(const)

#define proc_free(proc)    (proc_free_from_list(proc, NULL))

/*>>> functions prototypes                                                   */
struct s_proc *proc_alloc(gchar *);
void proc_free_from_list(gpointer, gpointer);
gint proc_comparison(gconstpointer, gconstpointer);

#ifdef DEBUG
void proc_debug(gpointer, gpointer);
#endif
#endif /* __PROC_H__ */
