/**
 *  @file    rc.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  2002/09/17 - 1st version

 *  configuration file management
 */
#ifndef _RC_H_
#define _RC_H_

#include <gtk/gtk.h>


enum {
  RC_INVALID = G_TOKEN_LAST,
  RC_LOCALES,
  RC_DEFAULT,
  RC_DEFAULT_PATH,
  RC_LIB,
  RC_NAME,
  RC_DESCRIPTION,
  RC_HISTORY,
  RC_MAX,
  RC_FILE,
  RC_SAVE,
  RC_COREDUMP
};

static const struct {
  gchar *name;
  guint token;
} symbols[] = {
  { "locales", RC_LOCALES },
  { "default", RC_DEFAULT },
  { "default_path", RC_DEFAULT_PATH },
  { "lib", RC_LIB },
  { "name", RC_NAME },
  { "desc", RC_DESCRIPTION },
  { "history", RC_HISTORY },
  { "max", RC_MAX },
  { "file", RC_FILE },
  { "autosave", RC_SAVE },
  { "coredump", RC_COREDUMP }
};

struct s_keyval {
  guint key;
  gchar *value;
};

#endif /* _RC_H_ */
