/*
 *
 *
 */

#ifndef __TURTLE_H__
#define __TURTLE_H__

#define GTK_ENABLE_BROKEN 1

//we test threads support into GLib
/*#ifndef G_THREADS_ENABLED
  #error "Threads support is not enable in GLib"
#endif
*/
#include <gtk/gtk.h>
#include <math.h>
#include "config.h"


#define locale_t      guint
#define LOCALE_ENGLISH     0
#define LOCALE_FRENCH      1


/*>> define the turtle                                                       */
struct s_turtle {
  gdouble x,y;              /*>> turtle position (starting from top-left)    */
  gdouble angle;            /*>> turtle-head angle (0 eq 0h00)              */
  gdouble virtual_heading;  /*>> angle value in degrees                      */
  
  gboolean trace;           /*>> pen tracing during turtle moves (Y/N)       */
  GdkColor pencolor;        /*>> color of the turtle pen                     */

  int delay;                /*>> delay between 2 steps of drawings 
  			         (in nanoseconds)                            */

  GtkWidget *source_txt,
            *debug_txt,
            *drawing_field,
            *notebook,
            *wstatus,
    //            *filesel,
    //      *saveassel,
    *main_app_window,
    *progressbar;

  GdkPixmap *pixmap;        /*>> background pixmap. Used for drawings        */
  GdkPixmap *animator;      /*>> turtle animator pixmap                      */
  int anix, aniy;

  GdkGC *gc;

  //  GSList *instructions;     
  GSList *procedures;       /*>> list or procedures                          */

  struct s_proc *main_proc; /*>> main procedure                              */
  struct s_proc *cur_proc;  /*>> current procedure. used for compilation     */

  //  GSList *variables;        /*>> global variables list                       */

  GdkFont *font;

  //#ifdef DEBUG
  gboolean compile;
  gboolean draw;
  //#endif

  gboolean compilation_failed;

  GtkAdjustment *hadj, *vadj;

  GtkWidget *boxes[3];

  gint status;
  gchar *filename;
  locale_t locale;
};


#ifndef G_PI
#  define G_PI   M_PI
#endif

#define BASE_CAP (-(M_PI/2))

#define COLOR_BLACK        0
#define COLOR_BLUE         1
#define COLOR_GREEN        2
#define COLOR_CYAN         3
#define COLOR_RED          4
#define COLOR_MAGENTA      5
#define COLOR_YELLOW       6
#define COLOR_WHITE        7
#define COLOR_BROWN        8
#define COLOR_LIGHTBROWN   9
#define COLOR_MIDGREEN    10
#define COLOR_BLUEGREEN   11
#define COLOR_SALMON      12
#define COLOR_BLUEISH     13
#define COLOR_ORANGE      14
#define COLOR_OR          15


int frlex(void);
int enlex(void);


#define OPEN_PROGRAM_BOX   0
#define SAVE_PROGRAM_BOX   1
#define SAVE_DRAWING_BOX   2


#include <libintl.h>
#define _(String) gettext (String)


#define STATUS_CHANGED     1
#define STATUS_NAMED       2
//#define STATUS_UNCHANGED   2
//#define STATUS_NOTNAMED    3

/* return a boolean */
#define STATUS_IS_MODIFIED(a_turtle)     (a_turtle.status & STATUS_CHANGED)
#define STATUS_IS_NAMED(a_turtle)        (a_turtle.status & STATUS_NAMED)

#define SET_STATUS_MODIFIED(a_turtle)    (a_turtle.status |=  STATUS_CHANGED)
#define SET_STATUS_NAMED(a_turtle)       (a_turtle.status |=  STATUS_NAMED)

#define UNSET_STATUS_MODIFIED(a_turtle)  (a_turtle.status &= ~STATUS_CHANGED)
#define UNSET_STATUS_NAMED(a_turtle)     (a_turtle.status &= ~STATUS_CHANGED)
#endif /* __TURTLE_H__ */


