/**
 *  @file    value.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  28/02/2002

 *  Values definition
 */
#ifndef _VALUE_H_
#define _VALUE_H_

#include <gtk/gtk.h>

/*>>> value types definition                                                 */
typedef enum {
  T_ILLEGAL,
  
  T_NONE,
  T_INT,
  T_FLOAT,
  T_BOOL,
  T_STRING
} valuetype_t;

/*>>> value definition                                                       */
struct s_value {
  valuetype_t valuetype;  /**< value type                                    */

  /* value value !                                                           */
  union {
    guint    vint;
    gdouble  vfloat;
    gboolean vbool;
    gchar *  vstring;
  } content;
};


#define VALUE_TYPE(class)          ((CLASS(class))->value.valuetype)
#define VALUE_VALUE(class, type)                                              \
  ({                                                                          \
      if(type & VALUE_TYPE(class) == 0)                                       \
        { g_critical("not compatible types\n"); }                             \
      else                                                                    \
        {                                                                     \
          switch(VALUE_TYPE(class))                                           \
	    {                                                                 \
	    case T_INT   : CLASS(class)->value.content.vint;                  \
	    case T_FLOAT : CLASS(class)->value.content.vfloat;                \
	    case T_BOOL  : CLASS(class)->value.content.vbool;                 \
	    case T_STRING: CLASS(class)->value.content.vstring;               \
	    }                                                                 \
	 }                                                                    \
  })


/*>>> functions prototypes                                                   */
void value_set(struct s_value *, valuetype_t, ...);
void value_unset(struct s_value);
void value_translate(struct s_value, struct s_value);
#ifdef DEBUG
gchar *value_subdebug(struct s_value);
#endif
#endif /* _VALUE_H_ */
