/**
 *  @file    variable.h
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  05/02/2002
 *  @version 0.2
 *    @date  28/02/2002 - object structure definition

 *  variables definition
 */
#ifndef _VARIABLE_H_
#define _VARIABLE_H_

#include <gtk/gtk.h>
#include "class.h"

typedef enum {
  VAR_LOCAL,
  VAR_GLOBAL //,
  //  VAR_PROCARG
} var_locality_t;

/*>>> variables definition                               */
struct s_variable {
  struct s_class class;  /**< variable class heritage    */

  gchar *name;           /**< variable name              */
};

/*>>> macros                                                                 */
#define VAR(class)        ((struct s_variable *)class)
#define VAR_TYPE(const)   CLASS_TYPE(const)

#define var_free(var)     (var_free_from_list(var, NULL))

/*>>> functions prototypes                               */
struct s_variable *var_alloc(gchar *);
void var_free_from_list(gpointer, gpointer);
gint var_comparison(gconstpointer, gconstpointer);
#ifdef DEBUG
void var_debug(gpointer, gpointer);
gchar *var_subdebug(struct s_variable *);
#endif

#endif /* _VARIABLE_H_ */
