/**
 *  @file    class.c
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  01/03/2002

 *  class management
 */
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <gtk/gtk.h>
#include "class.h"
#include "constant.h"
#include "list.h"

/**
   Instruction freeing.<br>

   <b>visibility :: <i>public</i></b>

   @remarks
            1. the second argument is not used (just for GTK compatibility)

   @remarks
            1. here we don't take care of procedures

   @param   instr                       the instruction to free
   @param   nil                         not used
   @return  <none>
 */
void class_free_from_list(gpointer class, gpointer nil)
{
  if(class != NULL)
    {
      switch(CLASS_TYPE(class))                                               
	{                                                       
	case CLASS_PROC:   proc_free_from_list(class, nil); break;             
	case CLASS_VAR:   var_free_from_list(class, nil); break;
	case CLASS_INSTR: instr_free_from_list(class, nil); break;
	case CLASS_CONST: const_free(CONST(class)); break;
	case CLASS_LIST:  list_free(LIST(class));                         
	}                      
    }                                     
}


