/**
 *  @file    context.c      
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  08/02/2002

 *  procedures context
 */
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <gtk/gtk.h>
#include "context.h"
#include "proc.h"
#include "variable.h"
#include "mem.h"

/**
   saving context.<br>

   <b>visibility :: <i>public</i></b>

   @remarks:
            1.

   @param   proc                        the procedure to save

   @return  <none>
 */
void context_save(struct s_proc *proc)
{
  GSList *elem;
  struct s_class *context_elem;
  struct s_context *context = _XNEW0(struct s_context, 1);

  //  g_message("-+- context saving for procedure '%s' -+-\n", proc->name);

  /* parameters saving */
  elem = proc->parameters;
  while(elem != NULL)
    {
      context_elem = _XNEW0(struct s_class, 1);
      value_translate(context_elem->value, CLASS(elem->data)->value);

      context->parameters = g_slist_append(context->parameters, context_elem);
      elem = g_slist_next(elem);
    }

  /* inner variables saving */
  elem = proc->variables;
  while(elem != NULL)
    {
      context_elem = _XNEW0(struct s_class, 1);
      value_translate(context_elem->value, CLASS(elem->data)->value);

      context->variables = g_slist_append(context->variables, context_elem);
      elem = g_slist_next(elem);
    }

  proc->contexts = g_slist_prepend(proc->contexts, context);
}


/**
   restoring context.<br>

   <b>visibility :: <i>public</i></b>

   @param   proc                        the procedure to restore

   @return  <none>
 */
void context_restore(struct s_proc *proc)
{
  GSList *elem, *elem2;
  struct s_context *context = 
    (struct s_context *) g_slist_nth_data(proc->contexts, 0);

  proc->contexts = g_slist_remove(proc->contexts, context);

  //  g_message("-+- context restoring for procedure '%s' -+-\n", proc->name);

  /* parameters restoring */
  elem = proc->parameters;
  elem2 = context->parameters;
  while(elem != NULL)
    {
      value_unset(CLASS(elem->data)->value);
      value_translate(CLASS(elem->data)->value, CLASS(elem2->data)->value);
      _XFREE(elem2->data);

      elem = g_slist_next(elem);
      elem2 = g_slist_next(elem2);
    }

  /* inner variables restoring */
  elem = proc->variables;
  elem2 = context->variables;
  while(elem != NULL)
    {
      value_unset(CLASS(elem->data)->value);
      value_translate(CLASS(elem->data)->value, CLASS(elem2->data)->value);
      _XFREE(elem2->data);

      elem = g_slist_next(elem);
      elem2 = g_slist_next(elem2);
    }

  g_slist_free(context->parameters);
  g_slist_free(context->variables);
  _XFREE(context);
}
