/**
 *  @file    interface.c
 *  @author  Guillaume Bour. 2000/2001                                  
 
 *  @version 0.1
 *    @date  2002/07/21
        + rewrite code with comments
	+ add drawing saving menu item
      @date  2002/03/09
        + fix a bug into the 'create_button' function:
	  style must be initialized with 'gtk_widget_get_style'
        + fix the 'null colormap' warning by allocation a colormap
   	  with 'gdk_colormap_get_system()'

 *  All the interface definitions

 *
 */

/*      Lafontaine - Graphical logo interpreter
 *      Copyright (C) 2002 Guillaume Bour <gbour@nomade.fr>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gtk/gtk.h>
#include "turtle.h"
#include "interface.h"
#include "callbacks.h"

extern struct s_turtle my_turtle;

#ifndef PIXMAPDIR
  #error "PIXMAPDIR is not defined"
#endif


/**
   Create lafontaine main window, and return a reference to it

   @param   <none>
   @return  a reference to the created window
 */
GtkWidget *create_main_window(void)
{
  GtkWidget 
    *vbox1,
    *handlebox,
    *hbox1,
    *btn_quit,
    *btn_open,
    *btn_save,
    *btn_help,
    *sep,
    *cpane,
    *pane,
    *notebook,
    *green,
    *drawgreen,
    *dbg_code,
    *txt_code,
    *hbox2,
    *btn_exec,
    *wstatus,
    *filesel, *saveassel,
    *scw,
    *draw_item,
    *menu_bar,
    *turtled,
    *scbh, *scbv, *vport;
  GList *group;

  /* program main window */
  my_turtle.main_app_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(my_turtle.main_app_window), WINDOW_TITLE);
  gtk_window_set_default_size(GTK_WINDOW(my_turtle.main_app_window),
			      WINDOW_WIDTH,
			      WINDOW_HEIGHT);
  /*  gtk_signal_connect(GTK_OBJECT(my_turtle.main_app_window), "delete_event",
      GTK_SIGNAL_FUNC(quit_event), NULL);*/
  gtk_signal_connect(GTK_OBJECT(my_turtle.main_app_window), "destroy",
		     GTK_SIGNAL_FUNC(destroy), NULL);
  gtk_signal_connect (GTK_OBJECT(my_turtle.main_app_window),"show",
		      (GtkSignalFunc) window_configure_event, NULL);

  /*>>> 4 vertical boxes    */
  vbox1 = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(vbox1), 2);
  gtk_container_add(GTK_CONTAINER(my_turtle.main_app_window), vbox1);
  gtk_widget_show(vbox1);

  /*>>> top-window menu bar */
  menu_bar = create_menubar();
  gtk_box_pack_start(GTK_BOX(vbox1), menu_bar, FALSE, FALSE, 1);
  gtk_widget_show(menu_bar);

  /*>>> handle-box          */
  handlebox = create_handlebox();
  /* NEW GTK2.0 gtk_widget_set_usize(handlebox, -1, 55);*/
  gtk_widget_set_size_request(handlebox, -1, 55);
  gtk_box_pack_start(GTK_BOX(vbox1), handlebox, FALSE, FALSE, 1);
  gtk_widget_show(handlebox);

  /*>>> main plateforme : logo program + drawing area */
  cpane = gtk_frame_new(NULL);
  gtk_container_set_border_width(GTK_CONTAINER(cpane), 5);
  gtk_frame_set_shadow_type(GTK_FRAME(cpane), GTK_SHADOW_NONE);
  gtk_box_pack_start(GTK_BOX(vbox1), cpane, FALSE, FALSE, 1);
  gtk_widget_show(cpane);


  pane = gtk_hpaned_new();
  //GTK2.0 NOT WORKING  gtk_paned_set_handle_size(GTK_PANED(pane), 10);
  gtk_paned_set_gutter_size(GTK_PANED(pane), 15);
  gtk_paned_set_position(GTK_PANED(pane), 450);
  gtk_widget_set_usize (GTK_WIDGET(pane), -1, 400);
  //gtk_container_set_border_width(GTK_CONTAINER(pane), 10);

  txt_code = gtk_text_new(NULL, NULL);
  my_turtle.source_txt = txt_code;
  //GTK2.0 NOT WORKING gtk_text_set_editable(GTK_TEXT(txt_code), TRUE);
  gtk_text_set_editable(txt_code , TRUE);
  gtk_signal_connect (GTK_OBJECT(txt_code),"insert-text",
		      (GtkSignalFunc) text_activate2, NULL);

  gtk_widget_show(txt_code);



  notebook = gtk_notebook_new();
  my_turtle.notebook = notebook;
  //gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_LEFT);
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
  gtk_notebook_set_show_border(GTK_NOTEBOOK(notebook), FALSE);
  gtk_widget_show(notebook);

  green = gtk_frame_new(NULL);
  gtk_widget_show(green);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), green, NULL);

  /* scrollbars ==> scrolledwindow */
  /* !!! on position les scrollbars au milieu */
  scbh = gtk_adjustment_new(/*200.0*/0.0, 0.0, 800.0, 1.0, 10.0, 50.0);
  my_turtle.hadj = scbh;
  scbv = gtk_adjustment_new(/*200.0*/0.0, 0.0, 800.0, 1.0, 10.0, 50.0);
  my_turtle.vadj = scbv;

  scw = gtk_scrolled_window_new(GTK_ADJUSTMENT(scbh)/*NULL*/, 
				GTK_ADJUSTMENT(scbv)/*NULL*/);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scw), 
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add(GTK_CONTAINER(green), scw);
  gtk_widget_show(scw);

  vport = gtk_viewport_new(GTK_ADJUSTMENT(scbh), GTK_ADJUSTMENT(scbv));
  gtk_container_add(GTK_CONTAINER(scw), vport);
  gtk_widget_show(vport);
  

  drawgreen = gtk_drawing_area_new();
  my_turtle.drawing_field = drawgreen;
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawgreen), 800, 800);
  //  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scw), drawgreen);
  gtk_container_add(GTK_CONTAINER(vport), drawgreen);
  //gtk_widget_show(drawgreen);


  gtk_signal_connect(GTK_OBJECT (drawgreen), "expose_event",
		     (GtkSignalFunc) drawarea_expose_event, NULL);
  /*  gtk_signal_connect (GTK_OBJECT (drawgreen), "motion_notify_event",
		      (GtkSignalFunc) motion_notify_event, NULL);
  */
  /*  !!! on utilise realize au lieu de configure-event
          car le second est rexcut chaque fois qu'on switch le notebook
      gtk_signal_connect (GTK_OBJECT(drawgreen),"configure_event",
		      (GtkSignalFunc) configure_event, NULL);
  */
  gtk_signal_connect (GTK_OBJECT(drawgreen),"realize",
		      (GtkSignalFunc) drawarea_configure_event, NULL);



  dbg_code = gtk_text_new(NULL, NULL);
  my_turtle.debug_txt = dbg_code;
  gtk_widget_show(dbg_code);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dbg_code, NULL);


 
  gtk_paned_add1(GTK_PANED(pane), notebook);
  gtk_paned_add2(GTK_PANED(pane), txt_code);
  gtk_container_add(GTK_CONTAINER(cpane), pane);
  //gtk_box_pack_start(GTK_BOX(cpane), pane, FALSE, FALSE, 1);
  gtk_widget_show(pane);


  /*>>> 1 seconde zone de boutons */
  hbox2 = gtk_hbox_new(FALSE, 5);
  /* GTK2.0 COMPATIBILITY -- separator no more inherit from container
     gtk_container_set_border_width(GTK_CONTAINER(hbox1), 0);*/

  //  btn_exec = create_button(main_window, "Excuter", XPM_DIR("execute.xpm"));
  btn_exec = create_button(_("S_tart"), "execute.xpm");
  gtk_box_pack_end(GTK_BOX(hbox2), btn_exec, FALSE, FALSE, 1);
  gtk_widget_show(btn_exec);

  gtk_signal_connect(GTK_OBJECT(btn_exec), "released",
		     GTK_SIGNAL_FUNC(execute_program_clb), 
		     (gpointer) txt_code);
  gtk_signal_connect(GTK_OBJECT(btn_exec), "activate",
		     GTK_SIGNAL_FUNC(execute_program_clb), 
		     (gpointer) txt_code);


  /*>>> pour terminer, une status bar */
  wstatus = gtk_statusbar_new();
  my_turtle.wstatus = wstatus;
  gtk_box_pack_end(GTK_BOX(vbox1), wstatus, FALSE, FALSE, 1);
  gtk_widget_show(wstatus);


  /*>>> and a progress bar */
  wstatus = gtk_progress_bar_new();
  my_turtle.progressbar = wstatus;
  gtk_box_pack_end(GTK_BOX(vbox1), wstatus, FALSE, FALSE, 1);
  gtk_widget_show(wstatus);


  gtk_box_pack_end(GTK_BOX(vbox1), hbox2, FALSE, FALSE, 1);
  gtk_widget_show(hbox2);

  
  //gtk_widget_show(main_window);

  lafontaine_init();/*txt_code, dbg_code, drawgreen, notebook, status, filesel,
		     saveassel, scbh, scbv);*/
  create_fileselection_boxes();

  return(my_turtle.main_app_window);
}

/**
   Create a handle-box button

   @param   label                 the button label
   @param   pixmap_file           the image file to put into the button

   @return  the created widget
 */
GtkWidget *create_button(gchar *label, gchar *pixmap_file)
{
  GtkWidget 
    *button,
    *vbox,
    *pixmapwid,
    *separator,
    *wlabel;
  GdkPixmap *pixmap;
  GdkBitmap *mask = NULL;
  GtkStyle *style = NULL;
  GdkColormap *colormap;
  gchar long_pixmap_file[1024];

  button = gtk_button_new();
  gtk_widget_set_usize(GTK_WIDGET(button), 80, 45);
  gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);

  vbox = gtk_vbox_new(FALSE, 0);
  //gtk_widget_set_size_request(GTK_WIDGET(vbox), 100, 100);
  gtk_container_add(GTK_CONTAINER(button), vbox);  
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 1);
  gtk_widget_show(vbox);

  /* add pixmap */
  snprintf(long_pixmap_file, 1024, "%s/%s", PIXMAPDIR, pixmap_file);

  colormap = gdk_colormap_get_system();
  style = gtk_widget_get_style(my_turtle.main_app_window);
  pixmap = gdk_pixmap_colormap_create_from_xpm(
    (my_turtle.main_app_window)->window, 
    colormap,
    &mask,
    &style->bg[GTK_STATE_NORMAL],
    long_pixmap_file);

  pixmapwid = gtk_pixmap_new(pixmap, mask);
  gtk_box_pack_start(GTK_BOX(vbox), pixmapwid, FALSE, FALSE, 1);
  gtk_widget_show(pixmapwid);

  /* add label */
  wlabel = gtk_label_new_with_mnemonic(label);
  gtk_box_pack_start(GTK_BOX(vbox), wlabel, FALSE, FALSE, 2);
  gtk_widget_show(wlabel);

  return(button);
}


/**
   Create the lafontaine menu

   @param   <void>
   @return  the created menubar
 */
GtkWidget *create_menubar()
{
  GtkWidget *menu_bar, *menu, *submenu, *menu_item, *mitem_item;
  GSList *group = NULL;

  /*>>> menu bar */
  menu_bar = gtk_menu_bar_new();

  /**>>> Debug menu ***********************************************************
     Only show if lafontaine is compiled with debug option
     
     Items:
       + switch debug/drawing frames
       + draw picture
       ----------------------------
       + mem proof       
   */
#ifdef DEBUG
  menu = gtk_menu_new();
  menu_item = gtk_menu_item_new_with_label(":: Debug ::");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);
  gtk_widget_show(menu_item);

  mitem_item = gtk_menu_item_new_with_label("Swith Debug Window/Drawing Area");
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(debug_switch_frame_clb),
			    (gpointer) NULL);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_check_menu_item_new_with_label("Draw picture");
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(debug_draw_picture_clb),
			    (gpointer) NULL);
  gtk_widget_show(mitem_item);

#ifdef MEMPROOF
  mitem_item = gtk_separator_menu_item_new(void);
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_menu_item_new_with_label("Mem proof");
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(debug_memproof_clb),
			    (gpointer) NULL);
  gtk_widget_show(mitem_item);
#endif
#endif


  /**>>> File menu **********************************************************

     Items:
       + open program
       + new program
       + save program
       + saveas program
       -----------------
       + save drawing
       -----------------
       + quit
   */
  menu = gtk_menu_new();    
  menu_item = gtk_menu_item_new_with_mnemonic(_("_File"));
  gtk_widget_show(menu_item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);

  mitem_item = gtk_menu_item_new_with_mnemonic(_("_Open program"));
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(show_window_clb),
			    (gpointer) OPEN_PROGRAM_BOX);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_menu_item_new_with_mnemonic(_("_New program"));
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(new_program_clb),
			    (gpointer) NULL);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_menu_item_new_with_mnemonic(_("_Save program"));
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(save_program_clb),
			    (gpointer) NULL);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_menu_item_new_with_mnemonic(_("Save _as program"));
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(show_window_clb),
			    (gpointer) SAVE_PROGRAM_BOX);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_separator_menu_item_new();
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_menu_item_new_with_mnemonic(_("Save _drawing"));
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(show_window_clb),
			    (gpointer) SAVE_DRAWING_BOX);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_separator_menu_item_new();
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_menu_item_new_with_mnemonic(_("_Quit"));
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(quit_application_clb),
			    (gpointer) NULL);
  gtk_widget_show(mitem_item);


  /**>>> Options menu *********************************************************

     Items:
       + logo locale
         + franais
         + english
   */
  menu = gtk_menu_new();    
  menu_item = gtk_menu_item_new_with_mnemonic(_("O_ptions"));
  gtk_widget_show(menu_item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);

  submenu = gtk_menu_new();    
  menu_item = gtk_menu_item_new_with_mnemonic(_("Logo _locale"));
  gtk_widget_show(menu_item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), submenu);
  gtk_menu_append(GTK_MENU(menu), menu_item);

  /* must implement it dynamically */
  /* must check the cedille  !!! */
  /* NB: locale names are not translatables */
  mitem_item = gtk_radio_menu_item_new_with_mnemonic(group, "Francais");
  gtk_menu_append(GTK_MENU(submenu), mitem_item);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mitem_item));
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(mitem_item), TRUE);

  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(switch_logo_locale_clb),
			    (gpointer) LOCALE_FRENCH);
  gtk_widget_show(mitem_item);

  mitem_item = gtk_radio_menu_item_new_with_mnemonic(group, "English");
  gtk_menu_append(GTK_MENU(submenu), mitem_item);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mitem_item));
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(switch_logo_locale_clb),
			    (gpointer) LOCALE_ENGLISH);
  gtk_widget_show(mitem_item);


  /**>>> Help menu ************************************************************

     Items:
       + Help
       ---------
       + About
   */
  menu = gtk_menu_new();    
  menu_item = gtk_menu_item_new_with_mnemonic(_("H_elp"));
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);
  gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_item));
  gtk_widget_show(menu_item);

  mitem_item = gtk_menu_item_new_with_mnemonic(_("_Help"));
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  /*  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(open_aboutbox_clb),
			    (gpointer) NULL);*/
  gtk_widget_show(mitem_item);
  
  mitem_item = gtk_menu_item_new_with_mnemonic(_("A_bout"));
  //gtk_menu_item_set_right_justified(menu_item, TRUE);
  gtk_menu_append(GTK_MENU(menu), mitem_item);
  gtk_signal_connect_object(GTK_OBJECT(mitem_item), "activate",
			    GTK_SIGNAL_FUNC(open_aboutbox_clb),
			    (gpointer) NULL);
  gtk_widget_show(mitem_item);

  return(menu_bar);
}


/**
   Create the lafontaine handlebox

   @remarks
     + should later be configurable via config file

   @param   <void>
   @return  the created handlebox
 */
GtkWidget *create_handlebox()
{
  GtkWidget *handlebox, *hbox, *button, *separator, *pixmap;

  handlebox = gtk_handle_box_new();
  gtk_widget_set_usize(handlebox, -1, 55);
  gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(handlebox), GTK_SHADOW_OUT);
  gtk_container_set_border_width(GTK_CONTAINER(handlebox), 2);
  
  hbox = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 0);
  gtk_container_add(GTK_CONTAINER(handlebox), hbox);
  gtk_widget_show(hbox);

  //utiliser gtk_button_new_with_mnemonic
  //btn_quit = create_button(main_window, "Quitter", XPM_DIR("quit.xpm"));
  button = create_button(_("_Quit"), "quit.xpm");
  gtk_signal_connect(GTK_OBJECT(button), "released",
		     GTK_SIGNAL_FUNC(quit_application_clb), NULL);
  gtk_signal_connect(GTK_OBJECT(button), "activate",
		     GTK_SIGNAL_FUNC(quit_application_clb), NULL);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_widget_show(button);

  separator = gtk_vseparator_new();
  gtk_box_pack_start(GTK_BOX(hbox), separator, FALSE, FALSE, 1);
  /* GTK2.0 COMPATIBILITY -- separator no more inherit from container
     gtk_container_set_border_width(GTK_CONTAINER(separator), 0);*/
  gtk_widget_show(separator);

  button = create_button(_("_Open"), "open.xpm");
  gtk_signal_connect_object(GTK_OBJECT(button), "released",
			    GTK_SIGNAL_FUNC(show_window_clb),
			    (gpointer) OPEN_PROGRAM_BOX);
  gtk_signal_connect_object(GTK_OBJECT(button), "activate",
			    GTK_SIGNAL_FUNC(show_window_clb),
			    (gpointer) OPEN_PROGRAM_BOX);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_widget_show(button);

  separator = gtk_vseparator_new();
  gtk_box_pack_start(GTK_BOX(hbox), separator, FALSE, FALSE, 1);
  gtk_widget_show(separator);

  button = create_button(_("_Save"), "save.xpm");
  gtk_signal_connect_object(GTK_OBJECT(button), "released",
			    GTK_SIGNAL_FUNC(show_window_clb),
			    (gpointer) SAVE_PROGRAM_BOX);
  gtk_signal_connect_object(GTK_OBJECT(button), "activate",
			    GTK_SIGNAL_FUNC(show_window_clb),
			    (gpointer) SAVE_PROGRAM_BOX);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_widget_show(button);

  separator = gtk_vseparator_new();
  gtk_box_pack_start(GTK_BOX(hbox), separator, FALSE, FALSE, 1);
  gtk_widget_show(separator);

  button = create_button(_("_Help"), "help.xpm");
  gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_widget_show(button);

  separator = gtk_vseparator_new();
  gtk_box_pack_end(GTK_BOX(hbox), separator, FALSE, FALSE, 1);
  gtk_widget_show(separator);


  /**>>> draw the turtle with glasses */
  pixmap = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA(pixmap), 100, 55);
  gtk_signal_connect (GTK_OBJECT(pixmap), "expose_event",
		      (GtkSignalFunc) (turtled_configure_event), NULL);
  /*  gtk_signal_connect (GTK_OBJECT(turtled),"realize",
		      (GtkSignalFunc) (turtled_configure_event), NULL);
  */
  gtk_box_pack_end(GTK_BOX(hbox), pixmap, FALSE, FALSE, 1);
  gtk_widget_show(pixmap);

  return(handlebox);
}


/**
   Create dialog boxes

   @param   <void>
   @return  <void>
 */
void create_fileselection_boxes(void)
{
  GtkWidget *box;

  /**>>> open logo program dialog ***************/
  box = gtk_file_selection_new(_("Open logo program"));
  gtk_signal_connect(GTK_OBJECT(box), "destroy",
		     (GtkSignalFunc) destroy, box);
  gtk_signal_connect (
    GTK_OBJECT(GTK_FILE_SELECTION(box)->ok_button),
    "clicked", (GtkSignalFunc) open_program_clb, NULL);
  gtk_signal_connect_object(
   GTK_OBJECT(GTK_FILE_SELECTION(box)->cancel_button),
   "clicked", (GtkSignalFunc) gtk_widget_hide, box);
  my_turtle.boxes[OPEN_PROGRAM_BOX] = box;

  /**>>> saveas logo program dialog **************/
  box = gtk_file_selection_new(_("Save logo program"));
  gtk_signal_connect(GTK_OBJECT(box), "destroy",
		     (GtkSignalFunc) destroy, box);
  gtk_signal_connect (
    GTK_OBJECT(GTK_FILE_SELECTION(box)->ok_button),
    "clicked", (GtkSignalFunc) saveas_program_clb, NULL);
  gtk_signal_connect_object(
   GTK_OBJECT(GTK_FILE_SELECTION(box)->cancel_button),
   "clicked", (GtkSignalFunc) gtk_widget_hide, box);
  my_turtle.boxes[SAVE_PROGRAM_BOX] = box;

  /**>>> save drawing dialog *********************/
  box = gtk_file_selection_new(_("Save drawing"));
  gtk_signal_connect(GTK_OBJECT(box), "destroy",
		     (GtkSignalFunc) destroy, box);
  gtk_signal_connect (
    GTK_OBJECT(GTK_FILE_SELECTION(box)->ok_button),
    "clicked", (GtkSignalFunc) save_drawing_clb, NULL);
  gtk_signal_connect_object(
   GTK_OBJECT(GTK_FILE_SELECTION(box)->cancel_button),
   "clicked", (GtkSignalFunc) gtk_widget_hide, box);
  my_turtle.boxes[SAVE_DRAWING_BOX] = box;

}
