/**
 *  @file    io.c
 *  @author  Guillaume Bour. 2000/2001                                  
 
 *  @version 0.1
 *    @date  2000/07/21


 *  read/write functions

 *
 */

/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "io.h"

extern struct s_turtle my_turtle;

/**
   read a logo program, and print it into the text area.<br>

   @remarks
     + the program current filename is the to the opened one

   @param   filename                    the file name

   @return  the status (ok/nok)
 */
gint read_program(gchar *filename)
{
  FILE *instream;
  gchar inbuf[512];
  guint pos, size;

  /* We test that the file exist and is not a directory */
  if(!g_file_test(filename, G_FILE_TEST_EXISTS) ||
     g_file_test(filename, G_FILE_TEST_IS_DIR))
    { return(FALSE); }

  gtk_editable_delete_text(GTK_EDITABLE(my_turtle.source_txt), 0, -1);
  
  if((instream = fopen(filename, "r")) == NULL)
    { return(FALSE); }

  while(!feof(instream))
    {
      size = fread(inbuf, 1, 512, instream);
      //      pos = gtk_text_get_length(GTK_TEXT(my_turtle.source_txt)); 
      pos = gtk_text_get_length(my_turtle.source_txt); 
      gtk_editable_insert_text(GTK_EDITABLE(my_turtle.source_txt),
			       inbuf, size, &pos);
    }

  fclose(instream);

  g_free(my_turtle.filename);
  my_turtle.filename = g_strdup(filename);
  UNSET_STATUS_MODIFIED(my_turtle);
  SET_STATUS_NAMED(my_turtle);

  return(TRUE);
}


/**
   Write the current logo program into a file.<br>
   
   @remarks
     + Erase the content of the file if not empty
     + the new filename could be different of the program current filename<br>
       If it is the case, the current filename is set to the new one

   @param   filename                    the file name

   @return  the status (ok/nok)
 */
gint write_program(gchar *filename)
{
  FILE *instream;
  gchar *inbuf;

  /* We test that the file is not a directory */
  if(g_file_test(filename, G_FILE_TEST_IS_DIR))
    { return(FALSE); }

  if((instream = fopen(filename, "w")) == NULL)
    { return(FALSE); }

  inbuf = gtk_editable_get_chars(GTK_EDITABLE(my_turtle.source_txt), 0, -1);  
  fwrite(inbuf, 1, strlen(inbuf), instream);

  fclose(instream);
  g_free(inbuf);

  if(my_turtle.filename &&
     g_ascii_strcasecmp(my_turtle.filename, filename) != 0)
    {
      g_free(my_turtle.filename);
      my_turtle.filename = g_strdup(filename);
      SET_STATUS_NAMED(my_turtle);
    }

  UNSET_STATUS_MODIFIED(my_turtle);
  
  return(TRUE);
}
