/* 
    french::logo language lexer.
    case-insensitive 
*/
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */

 #include <gtk/gtk.h>
 #include "turtle.h"
 #include "parser.h"
 #include "config.h"


 extern struct s_turtle my_turtle;

 extern guint linecnt;
 extern gchar *input_str;
 extern guint curpos;

 extern char *lextxt;
%{
 //#define YY_DECL int yylex_fr(void) inutile

 //on redfini YYINPUT pour lire une chane de caractre, et non un FILE*
 #ifdef LEXREAD_FROM_STRING
  #define YY_INPUT(buf, result, maxsize)                                     \
    {                                                                        \
                                                                             \
      if(strlen(input_str+curpos) == 0)                                      \
        { result = YY_NULL; }                                                \
      else                                                                   \
        {                                                                    \
          strncpy(buf, input_str+curpos, maxsize);                           \
          result = strlen(buf);                                              \
          curpos += result;                                                  \
        }                                                                    \
    }
 #endif

 #ifdef DEBUG_LEXER
   /* routine de dbugage: affiche le token lu et sa valeur */
   #define LL_PRINT(tok) \
     fprintf(stderr, "lexer(%3d): token "#tok"(%s) lu.\n", linecnt, yytext)

   #define IS_TOK(tok) LL_PRINT(tok) 

   #define IS_TOK_WITH_VAL(tok, type, val) LL_PRINT(tok)
 #else
   #define LL_PRINT(tok)

   /* routine de renvoie du token et de sa valeur au parser */
   #define IS_TOK(tok)                                                        \
   {                                                                          \
     lextxt = yylex; \
     return(tok);                                                             \
   }

   #define IS_TOK_WITH_VAL(tok, type, val)                                    \
   {                                                                          \
     lextxt = yylex; \
     yylval.##type = val;                                                     \
     return(tok);                                                             \
   }
 #endif
%}

 //mad thing. prefix redefine function names, but also file name,
 //and ylwrap WANT a 'lex.yy.c' filename
%option prefix="fr"
%option outfile="lex.yy.c"
%option never-interactive
%option noyywrap


moveforward     (av|avancer?)

movebackward    (rec?|reculer?)

turnright       (td|dr|tourner?(_?|[[:blank:]]*)droite|tourner?[[:blank:]]*[[:blank:]]*droite|droite)    

turnleft        (tg|ga|tourner?(_?|[[:blank:]]*)gauche|tourner?[[:blank:]]*[[:blank:]]*gauche|gauche)

clearscreen     (ve|vider?(_?|[[:blank:]]*)[e]cran|vider?[[:blank:]]*l'[e]cran|nettoie)

hideturtle      (ct|cacher?(_?|[[:blank:]]*)tortue|cacher?[[:blank:]]*la[[:blank:]]*tortue)

showturtle      (mt|montrer?(_?|[[:blank:]]*)tortue|montrer?[[:blank:]]*la[[:blank:]]*tortue)

trace           (bc|dessiner?|baisser?(_?|[[:blank:]]*)crayon|baisser?[[:blank:]]*le[[:blank:]]*crayon)

notrace         (lc|marcher?|lever?(_?|[[:blank:]]*)crayon|lve(_?|[[:blank:]]*)crayon|lever?[[:blank:]]*le[[:blank:]]*crayon|lve[[:blank:]]*le[[:blank:]]*crayon)

pencolor        (fcc|couleur|couleur(_?|[[:blank:]]*)crayon|couleur[[:blank:]]*du[[:blank:]]*crayon)

setposition     (fpos|fixexy|allera)
setheading      (fcap|fixecap|fixcap|fixe_cap)
getheading      (cap)

color-black        (noir)
color-blue         (bleu)
color-green        (vert)
color-cyan         (bleu\ clair|cyan)
color-red          (rouge)
color-magenta      (magenta)
color-yellow       (jaune)
color-white        (blanc)
color-brown        (marron)
color-lightbrown   (marron\ clair)
color-midgreen     (gris)
color-bluegreen    (bleue?[ -_]?gris)
color-salmon       (saumon)
color-blueish      (blue-?ish)
color-orange       (orange)
color-or           (or|dore?|doree?)

repeat          (repeter?|rpte|rpter)

hazard          (hasard)

and             (et)
or              (ou)

if              (si)
else            (sinon)

while           (tant(_?|[[:space:]]*)que)
for             (pour)
end             (fin)
stop            (stop)
return          (rt|ret|rends|retourner?)

write           ([e]crit|[e]crire)
dance           (danser?)
sleep           (dort|dormir)

affectation     (donne)
locaffectation  (locale)
loop            (loop|boucle|compteur)
true            (vrai)
false           (faux)
%%


 /*| comments */
\/\/[^\n]*
;[^\n]*

[[:digit:]]*   { IS_TOK_WITH_VAL(TOK_INT, intval, atoi(yytext)); }
[[:digit:]]+\.[[:digit:]]+  { IS_TOK_WITH_VAL(TOK_FLOAT, floatval, atof(yytext)); }


{moveforward}  { IS_TOK(TOK_MOVEFORWARD); }
{movebackward} { IS_TOK(TOK_MOVEBACK); }
{turnright}    { IS_TOK(TOK_TURNRIGHT); }
{turnleft}     { IS_TOK(TOK_TURNLEFT); }
{hideturtle}   { IS_TOK(TOK_HIDETURTLE); }
{showturtle}   { IS_TOK(TOK_SHOWTURTLE); }

{trace}        { IS_TOK(TOK_TRACE); }
{notrace}      { IS_TOK(TOK_NOTRACE); }
{clearscreen}  { IS_TOK(TOK_CLEARSCREEN); }

{pencolor}     { IS_TOK(TOK_COLOR); }

 /* colors management: see the colors table */
{color-black}      { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_BLACK);      }
{color-blue}       { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_BLUE);       }
{color-green}      { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_GREEN);      }
{color-cyan}       { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_CYAN);       }
{color-red}        { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_RED);        }
{color-magenta}    { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_MAGENTA);    }
{color-yellow}     { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_YELLOW);     }
{color-white}      { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_WHITE);      }
{color-brown}      { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_BROWN);      }
{color-lightbrown} { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_LIGHTBROWN); }
{color-midgreen}   { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_MIDGREEN);   }
{color-bluegreen}  { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_BLUEGREEN);  }
{color-salmon}     { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_SALMON);     }
{color-blueish}    { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_BLUEISH);    }
{color-orange}     { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_ORANGE);     }
{color-or}         { IS_TOK_WITH_VAL(TOK_INT, intval, COLOR_OR);         }

 /* data stream structures */
{repeat}       { IS_TOK(TOK_REPEAT); }

 /* one-character operators */
">"|"<"|"&"|"|"|"^"|"("|")"|"+"|"-"|"*"|"/"|"="|"["|"]" { IS_TOK(yytext[0]); }

 /* " two-characters operators */
\<=            { IS_TOK(TOK_LEQ); }
\>=            { IS_TOK(TOK_GEQ); }

 /*{and}          { IS_TOK(TOK_AND); }
  {or}           { IS_TOK(TOK_OR); } */

{hazard}       { IS_TOK(TOK_HAZARD); }
 /* ??? get ou set */
{setposition}  { IS_TOK(TOK_SETPOS); }
{setheading}   { IS_TOK(TOK_SETHEADING); }
{getheading}   { IS_TOK(TOK_GETHEADING); }

{if}           { IS_TOK(TOK_IF); }
 /*{else}         { IS_TOK(TOK_ELSE); } */

{while}        { IS_TOK(TOK_WHILE); }

{for}          { IS_TOK(TOK_BEGPROC); }
{end}          { IS_TOK(TOK_ENDPROC); }
{stop}         { IS_TOK(TOK_STOP); }

{return}       { IS_TOK(TOK_RETURN); }
{write}        { IS_TOK(TOK_WRITE); }

  /* specials instructions :) */
{dance}        { IS_TOK(TOK_DANCE); }
{sleep}        { IS_TOK(TOK_SLEEP); }

{affectation}  { IS_TOK(TOK_AFFECT); }
{locaffectation}  { IS_TOK(TOK_LOCALAFFECT); }
{loop}         { IS_TOK(TOK_LOOPCNT); }

{true}         { IS_TOK_WITH_VAL(TOK_BOOL, boolval, TRUE); }
{false}        { IS_TOK_WITH_VAL(TOK_BOOL, boolval, FALSE); }

  /* variable utilise */
:[[:alpha:]]+ { IS_TOK_WITH_VAL(TOK_VARIABLE, strval, yytext+1); }
  /* nom de procdure */
[[:alnum:]]+  { IS_TOK_WITH_VAL(TOK_PROCNAME, strval, yytext);  }
  /* dclaration de variable ou chane de caractre */
\"[[:alpha:]]+ { IS_TOK_WITH_VAL(TOK_STRING, strval, yytext+1);  }

"\n"   { linecnt++; gtk_progress_bar_pulse(my_turtle.progressbar);
       } //{ IS_TOK(yytext[0]); }

[ \t]* //{ IS_TOK(TOK_SPACE); }


.     { printf("invalid: '%s'\n", yytext); /*IS_TOK(TOK_INVALID); */}

 
<<EOF>> { 
          #ifdef DEBUG_LEXER
            return(0);
          #else
            IS_TOK(0); 
          #endif
        }

%%

#ifdef DEBUG_LEXER_HOHO
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>

//on passe en argument le fichier  lire
int main(int argc, char **argv)
{
  struct stat fstat;
  FILE *fd;
  char *fbuf;

  if(argc != 2)
    { printf("Usage: logolex file\n"); exit(1); }

  if(stat(argv[1], &fstat) < 0)
    { printf("Stat du fichier '%s' impossible\n", argv[1]); exit(1); }

  if((fd = fopen(argv[1], "r")) == NULL)
    { printf("Impossible d'ouvrir le fichier '%s'\n", argv[1]); exit(1); }

  fbuf =(char *) malloc(sizeof(char) * fstat.st_size);

  fread(fbuf, 1, fstat.st_size, fd);
  input_str = fbuf;

  yylex();
}
#endif
