/**
 *  @file    list.c
 *  @author  Guillaume Bour. 2002
 
 *  @version 0.1
 *    @date  10/02/2002

 *  lists management.
 */
/*      Copyright (C) 2002 Guillaume Bour
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */
#include <stdio.h>
#include <gtk/gtk.h>
#include "list.h"
#include "mem.h"


/**
   lists allocation.<br>

   <b>visibility :: <i>public</i></b>

   @param   free                         the element freeing function
   @return  the allocated list
 */

struct s_list *list_alloc(free_t free)
{
  struct s_list *mylist = _XNEW0(struct s_list, 1);

  CLASS(mylist)->classtype = CLASS_LIST;
  CLASS(mylist)->refcnt = 0;

  mylist->GTKList = NULL;
  mylist->free = free;
  return(mylist);
}


/**
   list freeing.<br>

   <b>visibility :: <i>public</i></b>

   @param   mylist                       the list to free
   @return  <none>
 */
void list_free(struct s_list *mylist)
{
  if(--(CLASS(mylist)->refcnt) == 0)
    {
      g_slist_foreach(mylist->GTKList, mylist->free, NULL);
      g_slist_free(mylist->GTKList);

      _XFREE(mylist);
    }
}


#ifdef DEBUG
gchar *list_subdebug(struct s_list *mylist)
{
  //  gchar *slist = _XNEW(gchar, 15);
  //  strcpy(slist, "<list>");
  register GSList *elt = mylist->GTKList;
  register gchar *slist = _XNEW(gchar, 100);
  register gchar *selt;

  strcpy(slist, "<list::");

  if(elt != NULL)
    { 
      selt = class_subdebug(elt->data);
      strncat(slist, selt, 99-strlen(slist));
      _XFREE(selt);
      elt = elt->next;
    }

  while(elt != NULL)
    {
      gchar *selt = class_subdebug(elt->data);

      strncat(slist, ", ", 99-strlen(slist));
      strncat(slist, selt, 99-strlen(slist));
      _XFREE(selt);

      elt = elt->next;
    }

  strncat(slist, ">", 99-strlen(slist));

  return(slist);
}
#endif
