/**
 *  @file    main.c
 *  @author  Guillaume Bour. 2000/2001                                  
 
 *  @version 0.1
 *    @date  2002/08/05
        + rewrite code with comments

 *  All the interface definitions

 *
 */

/*      Lafontaine - Graphical logo interpreter
 *      Copyright (C) 2002 Guillaume Bour <gbour@nomade.fr>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *  
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *  
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 59 Temple Place - Suite 330, Boston, 
 *      MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "turtle.h"
#include "interface.h"
#include "mem.h"

struct s_turtle my_turtle;

#ifdef MEMPROOF
  guint _alloc_cnt, _free_cnt, _null_free_cnt;
#endif


/*gboolean test(gpointer nil)
{
  printf("idle...\n");
  //sleep(1);
}
*/

/**
   Main lafontaine fonction - called at startup

   @param   argc                  arguments number
   @param   argv                  arguments list

   @return  program status 
 */
int main (int argc, char **argv)
{
  GtkWidget *window;

#ifdef MEMPROOF
  _alloc_cnt = 0;
  _free_cnt = 0;
  _null_free_cnt = 0;
#endif

  //setlocale(LC_ALL, "");
  gtk_set_locale();
  //  textdomain("lafontaine");
  //  bindtextdomain("lafontaine", "/usr/local/share/locale");
  textdomain(PACKAGE);
  bindtextdomain(PACKAGE, LOCALEDIR);

  g_thread_init(NULL);
  gdk_threads_init();

  gtk_init(&argc, &argv);
  gdk_rgb_init ();

  turtle_init(&my_turtle);
  rc_doit();
  //gtk_idle_add(test, NULL);

  window = create_main_window();
  gtk_widget_show_all(window);

  gdk_threads_enter();
  gtk_main ();
  gdk_threads_leave();

  mc_free();

#ifdef MEMPROOF
  printf("mem proof: <%d>alloc, <%d>free, <%d>null-free\n", 
	 _alloc_cnt, _free_cnt, _null_free_cnt);
#endif

  return 0;
}


/**
   turtle initialisation function

   @param   a_turtle              the turtle to initialize
   @return  nil
 */
void turtle_init(struct s_turtle *a_turtle)
{
  /*  a_turtle->x = ((a_turtle->drawing_field)->allocation).width/2;
  a_turtle->y = ((a_turtle->drawing_field)->allocation).height/2;
  */
  a_turtle->angle = BASE_CAP; //0;
  a_turtle->virtual_heading = 0;

  a_turtle->delay = 0; //50000000
  a_turtle->trace = TRUE;

  //default pen color: black
  a_turtle->pencolor.red = 0;
  a_turtle->pencolor.green = 0;
  a_turtle->pencolor.blue = 0;

  //current default logo locale is french
  //should be taken with environment variable LANG
  a_turtle->locale = LOCALE_FRENCH;

  a_turtle->procedures = NULL;
  a_turtle->main_proc = NULL;
  a_turtle->cur_proc = NULL;


  /* fond loading => should had a font chooser **/
  a_turtle->font = gdk_font_load("-xxl-*-*-*-*-*-*-*-*-*-*-*-*");

  a_turtle->compile = TRUE;
  a_turtle->draw = FALSE;

  a_turtle->status = 0;
}

