#include <stdio.h>
#include <stdlib.h>

enum pointType { pBegin, pEnd, nBegin, nEnd, intersection };
enum fragmentType { positive, negative };
enum intersectionType { ppp, ppn, pnp, pnn, npp, npn, nnp, nnn, none };


// 1st let between, 2nd let 1st frag, 3rd let 2nd frag

typedef struct HitLocationList {
  int seq1start;
  int seq2start;
  int seq1end;
  int seq2end;
  float score;
  char strand;
  struct HitLocationList *next;
  struct HitLocationList *bkptr;
  float scoreSoFar;
} hll;



struct fragment {
  int x1;
  int y1;
  int x2;
  int y2;
  
  float score;
  float totalScore;
  fragmentType type;
  fragmentType momentum;
  struct fragment * backfrag;
  char dirty;
};

typedef struct fragment fragment;

struct point {
  int x;
  int y;
  int hash;
  struct point * left;
  struct point * right;
  struct point * parent;
  struct fragment * frag;
  pointType type;
  int itype;
};

typedef struct point point;

point * createPoint ( int x, int y, fragment * frag, pointType type,
		      int itype );
int comparePoints ( point * p1, point * p2 );
void insertPoint ( point * root, point * newPoint );
void deletePoint ( point * node );
point * successorPoint ( point * node );
point * minimumPoint ( point * node );
void printTree ( point * root );

struct owner {
  struct fragment * frag;
  struct owner * next;
  struct owner * prev;
};

typedef struct owner owner;

owner * createOwner ( fragment * frag );
void insertOwnerAfter ( owner * node, owner * newnode, int caseNumber );
void insertOwnerBefore ( owner * node, owner * newnode, int caseNumber );
void deleteOwner ( owner * node, int caseNumber );
void printOwnerList ( owner * node );

struct cBound {
  int column;
  int hash;
  char deleted;
  struct owner * rightr;
  struct point * intpoint;
  struct cBound * left;
  struct cBound * right;
  struct cBound * parent;
};

typedef struct cBound cBound;

struct dBound {
  int diagonal;
  int hash;
  char deleted;
  struct owner * abover;
  struct point * intpoint;
  struct dBound * left;
  struct dBound * right;
  struct dBound * parent;
};

typedef struct dBound dBound;

cBound * createCBound ( int column, owner * rightr );
void insertCBound ( cBound * root, cBound * newnode, int caseNumber );
cBound * lookupCBound ( cBound * root, int column );
void deleteCBound ( cBound * node, int caseNumber );
cBound * successorCBound ( cBound * node );
cBound * minimumCBound ( cBound * node );
void printCBound ( cBound * root );

dBound * createDBound ( int diagonal, owner * abover );
void insertDBound ( dBound * root, dBound * newnode, int caseNumber );
dBound * lookupDBound ( dBound * root, int diagonal );
void deleteDBound ( dBound * node, int caseNumber );
dBound * successorDBound ( dBound * node );
dBound * minimumDBound ( dBound * node );
void printDBound ( dBound * root );

int parseCHAOS ( FILE * fp );
fragment * createFragment ( int x1, int x2, int y1, int y2, 
			    float score, char type );
float calculateScore ( fragment * f1, int x, int y, int caseNumber );

void processLeftInfluence ( point * curpoint, int caseNumber );
void processRightInfluence ( point * curpoint, int caseNumber );
void processIntersection ( point * curpoint, int caseNumber );

fragment * findLeftWinner ( point * curpoint, int caseNumber );
fragment * findRightWinner ( point * curpoint, int caseNumber );

void printOutput ();
void printFragment ( fragment * curfrag );

/*struct colInt {
  int column;
  point * pt;
  struct colInt * left;
  struct colInt * right;
  struct colInt * parent;
}

typedef struct colInt colInt;

colInt * createColInt ( int column, point * pt );
void insertColInt ( colInt * root, colInt * newnode );
colInt * lookupColInt ( colInt * root, int column );
*/

// Change the impl of delete in a tree to move the node to new place
// instead of copying the fields.
