#include <ctype.h>
#include <stdio.h>
#include <limits.h>
#include <assert.h>
#include "glocal.h"
#include <vector>

using namespace std;

#define M_LB 6

point * pointTreeRoot;
vector < fragment * > fragList;
static float gapOpen [8] = { 0, 1000, 2000, 2000, 2000, 2000, 1000, 0 };
static float gapExtend [8] = { 0.2, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.2 };
static float repl [8] = { 0, 0.07, 0.03, 0.03, 0.03, 0.03, 0.7, 0 };

cBound * cBoundTreeRoot[8];
dBound * dBoundTreeRoot[8];
owner * ownerListHead[8];

dBound * rightDBoundTreeRoot[8];
vector < dBound * > deletelist[8];
vector < dBound * > insertlist[8];

int hash(int arg) {
  //  return 1;
  return (arg % 313009); //6073 //another prime: 313009   //another 57773
}

void printTree(point* root, int n, int k = 0)
{
  if (!root)
    return;
  int i;
  for(i=0; i<n; i++)
    printf(" ");
  if (k)
    printf("R:");
  else
    printf("L:");
  
  printf("(%d,%d)\n", root->x, root->y);
  printTree(root->left, n+2, 0);
  printTree(root->right, n+2, 1);
}

int cutoff = 0;

void readParams(int argc, char** argv) {
  int i;
  float reg, inv, invret, tr;
  for (i=2; i < argc; i++) {
    if (!strcmp(     argv[i], "-gapopen")) {
      sscanf(argv[i+1], "%f,%f,%f,%f", &reg, &inv, &invret, &tr);
      gapOpen[0]=gapOpen[7]=reg;
      gapOpen[3]=gapOpen[4]=tr;
      gapOpen[1]=gapOpen[6]=inv;
      gapOpen[2]=gapOpen[5]=invret;
      i++;
    }
    if (!strcmp(argv[i], "-gapcont")) {
      sscanf(argv[i+1], "%f,%f,%f,%f", &reg, &inv, &invret, &tr);
      gapExtend[0]=gapExtend[7]=reg;
      gapExtend[3]=gapExtend[4]=tr;
      gapExtend[1]=gapExtend[6]=inv;
      gapExtend[2]=gapExtend[5]=invret;
      i++;
    }
    if (!strcmp(argv[i], "-dist")) {
      sscanf(argv[i+1], "%f,%f,%f,%f", &reg, &inv, &invret, &tr);
      repl[0]=repl[7]=reg;
      repl[3]=repl[4]=tr;
      repl[1]=repl[6]=inv;
      repl[2]=repl[5]=invret;
      i++;
    }
    if (!strcmp(argv[i], "-cutoff")) {
      cutoff = atoi(argv[i+1]);
      i++;
    }
  }
}

main ( int argc, char** argv)
{

  int cntr = 0;
  //  point* pointTreeRoot=createPoint(0,0, NULL, pEnd, 0);
  //for(i=1; i<10; i++)
  //  insertPoint(pointTreeRoot, createPoint(i, rand()%17, NULL, pEnd, 0));

  //printTree(pointTreeRoot, 0);
  //return 0;

  /* Parse the chaos file. Put the corners of the boxes for each fragment
     in pointTree. */
  int x;

  FILE * fp = fopen ( argv[1], "r" );
  if (!fp) {
    fprintf (stderr, "Error opening file %s\n", argv[1]);
    exit(1);
  }
  readParams(argc, argv);
  parseCHAOS ( fp );

  //printTree ( pointTreeRoot );
  
  /* Create a dummy fragment which owns the entire matrix, and put it in
     ownerList. */

  /* Create different owners and cBounds for different lists. This is so
     that freeing of memory can be done consistently. */

  fragment * dummyfrag = createFragment ( 0,0,0,0,0,positive );

  for ( int i = 0; i < 8; i++ ){
    
    owner * dummyownerLeft = createOwner ( dummyfrag );
    owner * dummyownerRight = createOwner ( dummyfrag );
    ownerListHead[i] = dummyownerLeft;
    
    /* Put -infinity in cBound and dBound and rightCBound */
    
    cBound * c = createCBound ( LONG_MIN / 2, dummyownerLeft );
    dBound * d = createDBound ( LONG_MIN / 2, dummyownerLeft );
    dBound * rightC = createDBound ( LONG_MIN / 2, dummyownerRight );

    insertCBound ( cBoundTreeRoot[i], c, i );
    insertDBound ( dBoundTreeRoot[i], d, i );
    insertDBound ( rightDBoundTreeRoot[i], rightC, i );

  }

  /* Start processing points. */

  point * curpoint = minimumPoint ( pointTreeRoot );
  fragment * temppoint;
  int momtemp;

  while ( curpoint != NULL ){
    cntr++;
    if (cntr %10000 == 1) { 
      fprintf (stderr, "Processing point(%d) : [%d, %d].\n",cntr, curpoint->x, curpoint->y );
    }
    if ( curpoint->type == pBegin ){
      //fprintf(stderr, "here pbegin\n");
      if ( curpoint->frag->type == positive ){

	fragment * leftWinnerPPP = findLeftWinner ( curpoint, ppp );
	fragment * rightWinnerPPP = findRightWinner ( curpoint, ppp );
	fragment * leftWinnerPNP = findLeftWinner ( curpoint, pnp );
	fragment * rightWinnerPNP = findRightWinner ( curpoint, pnp );

	/*
	printf ( "The winners are : \n" );

	printf ( "LeftPPP : \n" );
	printFragment ( leftWinnerPPP );

	printf ( "RightPPP : \n" );
	printFragment ( rightWinnerPPP );

	printf ( "LeftPNP : \n" );
	printFragment ( leftWinnerPNP );

	printf ( "RightPNP : \n" );
	printFragment ( rightWinnerPNP );
	*/

	float curScore = curpoint->frag->score;

	float scoreLeftPPP = ( calculateScore ( leftWinnerPPP, curpoint->x, 
						curpoint->y, ppp ) + curScore );
	float scoreRightPPP = ( calculateScore ( rightWinnerPPP, curpoint->x,
						 curpoint->y, ppp ) + curScore );
	//	fprintf(stderr, "here left\n");
	float scoreLeftPNP = ( calculateScore ( leftWinnerPNP, curpoint->x, 
						curpoint->y, pnp ) + curScore );
	//	fprintf(stderr, "here right\n");
	float scoreRightPNP = ( calculateScore ( rightWinnerPNP, curpoint->x,
						 curpoint->y, pnp ) + curScore );
	
	if ( scoreLeftPPP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftPPP;
	  curpoint->frag->backfrag = leftWinnerPPP;
	}

	if ( scoreRightPPP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightPPP;
	  curpoint->frag->backfrag = rightWinnerPPP;
	}

	if ( scoreLeftPNP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftPNP;
	  curpoint->frag->backfrag = leftWinnerPNP;
	}

	if ( scoreRightPNP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightPNP;
	  curpoint->frag->backfrag = rightWinnerPNP;
	}

	for (x = 0, momtemp = 0, temppoint = curpoint->frag; (x < M_LB) && temppoint; 
	     x++, temppoint = temppoint->backfrag) {
	  if (temppoint->type == positive) momtemp++;
	  //	  printFragment (temppoint);
	}
	//	fprintf(stderr, "%d %d\n",x , momtemp); 

	if ((!momtemp) || (!x) || (x/momtemp == 2)) 
	  curpoint->frag->momentum = curpoint->frag->type;
	else if ((x/momtemp) < 2) 
	  curpoint->frag->momentum = positive;
	else if ((x/momtemp) > 2) 
	  curpoint->frag->momentum = negative;

      }
      
      else {
	
	fragment * leftWinnerPPN = findLeftWinner ( curpoint, ppn );
	fragment * rightWinnerPPN = findRightWinner ( curpoint, ppn );
	fragment * leftWinnerPNN = findLeftWinner ( curpoint, pnn );
	fragment * rightWinnerPNN = findRightWinner ( curpoint, pnn );

	float curScore = curpoint->frag->score;

	float scoreLeftPPN = ( calculateScore ( leftWinnerPPN, curpoint->x, 
						curpoint->y, ppn ) + curScore );
	float scoreRightPPN = ( calculateScore ( rightWinnerPPN, curpoint->x,
						 curpoint->y, ppn ) + curScore );
	float scoreLeftPNN = ( calculateScore ( leftWinnerPNN, curpoint->x, 
						curpoint->y, pnn ) + curScore );
	float scoreRightPNN = ( calculateScore ( rightWinnerPNN, curpoint->x,
						 curpoint->y, pnn ) + curScore );
	
	if ( scoreLeftPPN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftPPN;
	  curpoint->frag->backfrag = leftWinnerPPN;
	}

	if ( scoreRightPPN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightPPN;
	  curpoint->frag->backfrag = rightWinnerPPN;
	}

	if ( scoreLeftPNN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftPNN;
	  curpoint->frag->backfrag = leftWinnerPNN;
	}

	if ( scoreRightPNN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightPNN;
	  curpoint->frag->backfrag = rightWinnerPNN;
	}
	
	for (x = 0, momtemp=0,temppoint = curpoint->frag; (x < M_LB) && temppoint; 
	     x++, temppoint = temppoint->backfrag) {
	  if (temppoint->type == positive) momtemp++;
	  //	  printFragment (temppoint);
	}
	//	fprintf(stderr, "%d %d\n",x , momtemp); 
	
	if ((!momtemp) || (!x) || (x/momtemp == 2)) 
	  curpoint->frag->momentum = curpoint->frag->type;
	else if ((x/momtemp) < 2) 
	  curpoint->frag->momentum = positive;
	else if ((x/momtemp) > 2) 
	    curpoint->frag->momentum = negative;
	


      }
      
    }
    
    else if ( curpoint->type == nBegin ){

      if ( curpoint->frag->type == positive ){

	fragment * leftWinnerNPP = findLeftWinner ( curpoint, npp );
	fragment * rightWinnerNPP = findRightWinner ( curpoint, npp );
	fragment * leftWinnerNNP = findLeftWinner ( curpoint, nnp );
	fragment * rightWinnerNNP = findRightWinner ( curpoint, nnp );

	float curScore = curpoint->frag->score;

	float scoreLeftNPP = ( calculateScore ( leftWinnerNPP, curpoint->x, 
						curpoint->y, npp ) + curScore );
	float scoreRightNPP = ( calculateScore ( rightWinnerNPP, curpoint->x,
						 curpoint->y, npp ) + curScore );
	float scoreLeftNNP = ( calculateScore ( leftWinnerNNP, curpoint->x, 
						curpoint->y, nnp ) + curScore );
	float scoreRightNNP = ( calculateScore ( rightWinnerNNP, curpoint->x,
						 curpoint->y, nnp ) + curScore );
	
	if ( scoreLeftNPP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftNPP;
	  curpoint->frag->backfrag = leftWinnerNPP;
	}

	if ( scoreRightNPP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightNPP;
	  curpoint->frag->backfrag = rightWinnerNPP;
	}

	if ( scoreLeftNNP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftNNP;
	  curpoint->frag->backfrag = leftWinnerNNP;
	}

	if ( scoreRightNNP > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightNNP;
	  curpoint->frag->backfrag = rightWinnerNNP;
	}
	
      }
      
      else {
	
	fragment * leftWinnerNPN = findLeftWinner ( curpoint, npn );
	fragment * rightWinnerNPN = findRightWinner ( curpoint, npn );
	fragment * leftWinnerNNN = findLeftWinner ( curpoint, nnn );
	fragment * rightWinnerNNN = findRightWinner ( curpoint, nnn );

	float curScore = curpoint->frag->score;

	float scoreLeftNPN = ( calculateScore ( leftWinnerNPN, curpoint->x, 
						curpoint->y, npn ) + curScore );
	float scoreRightNPN = ( calculateScore ( rightWinnerNPN, curpoint->x,
						 curpoint->y, npn ) + curScore );
	float scoreLeftNNN = ( calculateScore ( leftWinnerNNN, curpoint->x, 
						curpoint->y, nnn ) + curScore );
	float scoreRightNNN = ( calculateScore ( rightWinnerNNN, curpoint->x,
						 curpoint->y, nnn ) + curScore );
	
	if ( scoreLeftNPN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftNPN;
	  curpoint->frag->backfrag = leftWinnerNPN;
	}

	if ( scoreRightNPN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightNPN;
	  curpoint->frag->backfrag = rightWinnerNPN;
	}

	if ( scoreLeftNNN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreLeftNNN;
	  curpoint->frag->backfrag = leftWinnerNNN;
	}

	if ( scoreRightNNN > curpoint->frag->totalScore ){
	  curpoint->frag->totalScore = scoreRightNNN;
	  curpoint->frag->backfrag = rightWinnerNNN;
	}
	
      }

    }

    else if ( curpoint->type == pEnd ){
      //fprintf(stderr, "here pend\n");
      if ( curpoint->frag->type == positive ){

	processRightInfluence ( curpoint, ppp );      
	processLeftInfluence ( curpoint, ppp );
	processRightInfluence ( curpoint, ppn );
	processLeftInfluence ( curpoint, ppn );

      }
      
      else {
	
	processRightInfluence ( curpoint, pnp );      
	processLeftInfluence ( curpoint, pnp );
	processRightInfluence ( curpoint, pnn );
	processLeftInfluence ( curpoint, pnn );

      }

    }
 
    else if ( curpoint->type == nEnd ){

      if ( curpoint->frag->type == positive ){

	processRightInfluence ( curpoint, npp );      
	processLeftInfluence ( curpoint, npp );
	processRightInfluence ( curpoint, npn );
	processLeftInfluence ( curpoint, npn );

      }
      
      else {
	
	processRightInfluence ( curpoint, nnp );      
	processLeftInfluence ( curpoint, nnp );
	processRightInfluence ( curpoint, nnn );
	processLeftInfluence ( curpoint, nnn );

      }

    }
   
    else if ( curpoint->type == intersection ){
      
      processIntersection ( curpoint, curpoint->itype );

    }

    //printf ( "Processed  point : [%d, %d]\n", curpoint->x, curpoint->y );
    
    int curRow = curpoint->x;

    curpoint = successorPoint ( curpoint );

    if ( curpoint == NULL || curpoint->x > curRow ){

      int i, j;
      
      for ( j = 0; j < 8; j++ ){
	
	for ( i = 0; i < deletelist[j].size(); i++ ){
	  deleteDBound ( (deletelist[j])[i], j );
	}
	deletelist[j].clear();
	assert ( deletelist[j].size() == 0 );
	
	for ( i = 0; i < insertlist[j].size(); i++ ){
	  insertDBound ( rightDBoundTreeRoot[j], (insertlist[j])[i], j );
	}
	insertlist[j].clear();
	assert ( insertlist[j].size() == 0 );
      }     
      
    }

  }
  
  printOutput ();
  return 0;
}

point * createPoint ( int x, int y, fragment * frag, pointType type,
		      int itype )
{  
  point * newPoint = ( point * ) malloc ( sizeof ( point ) );
  newPoint->x = x;
  newPoint->y = y;
  newPoint->left = NULL;
  newPoint->right = NULL;
  newPoint->parent = NULL;
  newPoint->frag = frag;
  newPoint->type = type;
  newPoint->hash = hash(x+y);
  newPoint->itype = itype;
  //  fprintf(stdout, "Created %x\n", newPoint);
  return newPoint;
}

int comparePoints ( point * p1, point * p2 )
{

  //  assert ( p1 );
  //  assert ( p2 );

  if ( p1->x < p2->x ) return -1;
  if ( p1->x > p2->x ) return 1;
  if ( p1->y < p2->y ) return -1;
  if ( p1->y > p2->y ) return 1;
  return 0;
}

void insertPoint ( point * root, point * newPoint )
{
  int balance = 0;
  if ( newPoint == NULL ) return;

  if ( root == NULL && root == pointTreeRoot ){
    pointTreeRoot = newPoint;
    return;
  }

  if ( root == NULL ){
    assert ( false );
  }

  if ( comparePoints ( root, newPoint ) > 0 ){
    balance = 1;
    if ( root->left != NULL ){
      insertPoint ( root->left, newPoint );
    }
    else{
      root->left = newPoint;
      newPoint->parent = root;
      //      fprintf(stderr,"bottomL\n");
    }

  }

  else {  // What about duplicate points ?
    balance = 2;
    if ( comparePoints ( root, newPoint ) == 0 ){

      //printf ( "Duplicate points found.\n" );
      //printf ( "OldPoint : %d, %d, %d\n", root->x, root->y, root->type );
      //printf ( "NewPoint : %d, %d, %d\n", newPoint->x, newPoint->y, newPoint->type );

    }

    if ( root->right != NULL ){
      insertPoint ( root->right, newPoint );
      
    }
    else {
      root->right = newPoint;
      newPoint->parent = root;
      //      fprintf(stderr,"bottomR\n");
    }
  
  }

  
  if (balance == 1 && (root->left->hash < root->hash)) {
    //    if (root != pointTreeRoot)
    //  fprintf(stderr, "blah %x %x %x\n", root->parent->right,root->parent->left,root);
    point* newroot = root->left;
    point* temp = root->left->right;    
    newroot->right = root;
    root->left = temp;
    if (temp) temp->parent = root;
    newroot->parent = root->parent;
    root->parent = newroot;
    if (root == pointTreeRoot)
      pointTreeRoot = newroot;
    else if (newroot->parent->right == root) newroot->parent->right = newroot;
    else if (newroot->parent->left == root) newroot->parent->left = newroot;
    else {fprintf(stderr, "blah\n"); exit(2);}
  }

  else if (balance == 2 && (root->right->hash < root->hash)) {
    //    if (root != pointTreeRoot)
    //  fprintf(stderr, "blah %x %x %x\n", root->parent->right,root->parent->left,root);
    point* newroot = root->right;
    root->right = root->right->left;    
    newroot->left = root;
    if (root->right) root->right->parent = root;
    newroot->parent = root->parent;
    root->parent = newroot;
    if (root == pointTreeRoot)
      pointTreeRoot = newroot;
    else if (newroot->parent->right == root) newroot->parent->right = newroot;
    else if (newroot->parent->left == root) newroot->parent->left = newroot;
    else {fprintf(stderr, "blah %x %x %x\n", newroot->parent->right,newroot->parent->left,root); exit(2);}

    }
  
}

void freeSuccessor ( point* node) {
  point* succ = 0;
  
  if (node->right != NULL ){
    succ = node->right;
  }
  if ( node->parent == NULL ){
    pointTreeRoot = succ;
  }
  else if ( node == node->parent->left ){
    node->parent->left = succ;
  }
  else {
    node->parent->right = succ;
  }
  if (succ)
    succ->parent = node->parent;

}

void deletePoint ( point * node )
{
  point * y;
  point * x;

  if ( node == NULL ) return;
  
  if ( node->left == NULL || node->right == NULL ){
    y = node;
  }
  else{
    y = successorPoint ( node );
  }

  assert ( y );

  if ( y->left != NULL ){
    x = y->left;
  }
  else{
    x = y->right;
  }

  if ( x != NULL ){
    x->parent = y->parent;
  }


  if ( y->parent == NULL ){
    pointTreeRoot = x;
  }
  else if ( y == y->parent->left ){
    y->parent->left = x;
  }
  else {
    y->parent->right = x;
  }


  if ( y != node ){
    
    y->parent = node->parent;
    y->left = node->left;
    y->right = node->right;
    
    if ( node->parent != NULL ){
      
      if ( node == node->parent->left ){
	node->parent->left = y;
      }
      else if ( node == node->parent->right ) {
	node->parent->right = y;
      }      
      else {
	assert ( false );
      }
    
    }
    else
      pointTreeRoot = y;

    if ( node->left != NULL ){
      node->left->parent = y;
    }
    
    if ( node->right != NULL ){
      node->right->parent = y;
    }
    
    //node->x = y->x;
    //node->y = y->y;
    //node->frag = y->frag;
    //node->type = y->type;
  }
  
  //  fprintf(stdout, "Would have freed %x\n", node); 
  free ( node );
}

point * successorPoint ( point * node )
{
  
  point * y;

  if ( node == NULL ) return NULL;
  
  if ( node->right != NULL ){
    return minimumPoint ( node->right );
  }

  y = node->parent;
  
  while ( y != NULL && node == y->right ){
    //    if (y == pointTreeRoot) {fprintf(stderr, "mudak\n"); }
    node = y;
    y = y->parent;
  }
  
  return y;
  
}

point * minimumPoint ( point * node )
{
  
  if ( node == NULL ){
    return NULL;
  }
  
  while ( node->left != NULL ){
    node = node->left;
  }

  return node;
  
}

void printTree ( point * root )
{
  if ( root == NULL ) return;
  printTree ( root->left );
  printf ( "[%d, %d] - %d.\n", root->x, root->y, root->type );
  printTree ( root->right );
}

owner * createOwner ( fragment * frag )
{
  owner * newOwner = ( owner * ) malloc ( sizeof ( owner ) );
  newOwner->frag = frag;
  newOwner->next = NULL;
  newOwner->prev = NULL;
  return newOwner;
}

void insertOwnerAfter ( owner * node, owner * newnode, int caseNumber )
{

  if ( caseNumber == 10){
    printf ( "\nBefore Inserting (After):\n" );
    printf ( "Insert : ");
    printFragment ( newnode->frag );
    printf ( "After : ");
    printFragment ( node->frag );
    printOwnerList ( ownerListHead[caseNumber] );
  }

  if ( newnode == NULL ) return;
  
  if ( node == NULL ) {
    ownerListHead[caseNumber] = newnode;
    return;
  }

  newnode->next = node->next;
  newnode->prev = node;
  if ( node->next != NULL ){
    node->next->prev = newnode;
  }
  node->next = newnode;

  if ( caseNumber == 10){
    printf ( "After Inserting (After):\n" );
    printOwnerList ( ownerListHead[caseNumber] );
  }

}

void insertOwnerBefore ( owner * node, owner * newnode, int caseNumber )
{

  if ( caseNumber == 10){
    printf ( "\nBefore Inserting (before):\n" );
    printf ( "Insert : ");
    printFragment ( newnode->frag );
    printf ( "Before : ");
    printFragment ( node->frag );
    printOwnerList ( ownerListHead[caseNumber] );
  }

  if ( newnode == NULL ) return;
  
  if ( node == NULL ) {
    ownerListHead [caseNumber] = newnode;
    return;
  }

  if ( node == ownerListHead [caseNumber] ){
    ownerListHead [caseNumber] = newnode;
    newnode->next = node;
    node->prev = newnode;
    newnode->prev = NULL;
    return;
  }

  newnode->next = node;
  newnode->prev = node->prev;
  if ( node->prev != NULL ){
    node->prev->next = newnode;
  }
  node->prev = newnode;

  if ( caseNumber == 10){
    printf ( "After Inserting (before):\n" );
    printOwnerList ( ownerListHead[caseNumber] );
  }

}

void deleteOwner ( owner * node, int caseNumber )
{
  
  if ( caseNumber == 10){
    printf ( "\nBefore Deleting: \n" );
    printf ( "Delete : ");
    printFragment ( node->frag );
    printf ( "From : ");
    printOwnerList ( ownerListHead[caseNumber] );
  }

  if ( node == NULL ) return;
  
  if ( node->prev != NULL ){
    node->prev->next = node->next;
  }

  if ( node->next != NULL ){
    node->next->prev = node->prev;
  }

  if ( node == ownerListHead [caseNumber] ){
    ownerListHead [caseNumber] = node->next;
  }
  //  printf("Freeing %x\n", node);
  free ( node );

  if ( caseNumber == 10){
    printf ( "After Deleting :\n" );
    printOwnerList ( ownerListHead[caseNumber] );
  }  

}

void printOwnerList ( owner * node )
{
  if ( node == NULL ) return;
  printFragment ( node->frag );
  printOwnerList ( node->next );
}

cBound * createCBound ( int column, owner * rightr )
{
  cBound * newnode = ( cBound * ) malloc ( sizeof ( cBound ) );
  newnode->column = column;
  newnode->hash = hash(column);
  newnode->deleted = 0;
  newnode->rightr = rightr;
  newnode->intpoint = NULL;
  newnode->left = NULL;
  newnode->right = NULL;
  newnode->parent = NULL;
  return newnode;
}

void insertCBound ( cBound * root, cBound * newnode, int caseNumber )
{
  int balance = 0;
  if ( caseNumber == 10){
    printf ( "\nInserting column in cBound : %d\n", newnode->column );
    printf ( "The fragment is : " );
    printFragment ( newnode->rightr->frag );
  }

  if ( newnode == NULL ) return;

  if ( root == NULL && root == cBoundTreeRoot [caseNumber] ){
    cBoundTreeRoot [caseNumber] = newnode;
    return;
  }

  if ( root == NULL ){
    printf ( "ERROR : insertCBound.\n" );
    return;
  }

  if ( root->column > newnode->column ){
    balance = 1;
    if ( root->left != NULL ){
      insertCBound ( root->left, newnode, caseNumber );
    }
    else{
      root->left = newnode;
      newnode->parent = root;
    }

  }

  else if ( root->column < newnode->column ) {
    balance = 2;
    if ( root->right != NULL ){
      insertCBound ( root->right, newnode, caseNumber );
    }
    else {
      root->right = newnode;
      newnode->parent = root;
    }
  
  }

  else {

    // What if they are equal ?
    printf ( "%d, %d\n", root->column, newnode->column );
    assert ( false );
    
  }

  if ( caseNumber == 10 ){
    printf ( "The new cTree is :\n" );
    printCBound ( cBoundTreeRoot [caseNumber] );
  }
  
  if (balance == 1 && (root->left->hash < root->hash)) {
    cBound* newroot = root->left;
    cBound* temp = root->left->right;
    newroot->right = root;
    root->left = temp;
    if (temp) temp->parent = root;
    newroot->parent = root->parent;
    root->parent = newroot;
    if (root == cBoundTreeRoot[caseNumber])
      cBoundTreeRoot[caseNumber] = newroot;
    else if (newroot->parent->right == root) newroot->parent->right = newroot;
    else if (newroot->parent->left == root) newroot->parent->left = newroot;
    else {fprintf(stderr, "blah\n"); exit(2);}
  }
  
  else if (balance == 2 && (root->right->hash < root->hash)) {
    
    cBound* newroot = root->right;
    root->right = root->right->left;
    newroot->left = root;
    if (root->right) root->right->parent = root;
    newroot->parent = root->parent;
    root->parent = newroot;
    if (root == cBoundTreeRoot[caseNumber])
      cBoundTreeRoot[caseNumber] = newroot;
    else if (newroot->parent->right == root) newroot->parent->right = newroot;
    else if (newroot->parent->left == root) newroot->parent->left = newroot;
    else {
      fprintf(stderr, "blah %x %x %x\n",   newroot->parent->right,newroot->parent->left,root); 
      exit(2);
    }
  }
  
}

cBound * lookupCBound ( cBound * root, int column )
{
  
  if ( root == NULL ) return NULL;
  
  if ( root->column < column ){
    
    cBound * cbnode = lookupCBound ( root->right, column );
    if ( cbnode == NULL ) return root;
    else return cbnode;

  }
  
  else {
    
    return lookupCBound ( root->left, column );

  }

}

void deleteCBound ( cBound * node, int caseNumber )
{

  if ( caseNumber == 10){
    printf ( "\nDeleting column in cBound : %d\n", node->column );
    printf ( "The fragment is : " );
    printFragment ( node->rightr->frag );
  }
  
  cBound * y;
  cBound * x;

  if ( node == NULL ) return;
  
  if ( node->left == NULL || node->right == NULL ){
    y = node;
  }
  else{
    y = successorCBound ( node );
  }
  
  if ( y->left != NULL ){
    x = y->left;
  }
  else{
    x = y->right;
  }

  if ( x != NULL ){
    x->parent = y->parent;
  }

  if ( y->parent == NULL ){
    cBoundTreeRoot [caseNumber] = x;
  }
  else if ( y == y->parent->left ){
    y->parent->left = x;
  }
  else {
    y->parent->right = x;
  }

  if ( y != node ){
    
    y->parent = node->parent;
    y->left = node->left;
    y->right = node->right;
    
    if ( node->parent != NULL ){
      
      if ( node == node->parent->left ){
	node->parent->left = y;
      }
      else if ( node == node->parent->right ) {
	node->parent->right = y;
      }      
      else {
	assert ( false );
      }
    
    }
    else {
      cBoundTreeRoot[caseNumber] = y;
    }
    if ( node->left != NULL ){
      node->left->parent = y;
    }
    
    if ( node->right != NULL ){
      node->right->parent = y;
    }    
    
    //node->column = y->column;
    //node->rightr = y->rightr;
    //node->intpoint = y->intpoint;
  }
  //  printf("Freeing22 %x\n", node);
  free ( node );

  if ( caseNumber == 10 ){
    printf ( "The new cTree is :\n" );
    printCBound ( cBoundTreeRoot [ caseNumber ] );
  }

}

cBound * successorCBound ( cBound * node )
{
  
  cBound * y;

  if ( node == NULL ) return NULL;
  
  if ( node->right != NULL ){
    return minimumCBound ( node->right );
  }

  y = node->parent;
  
  while ( y != NULL && node == y->right ){
    node = y;
    y = y->parent;
  }
  
  return y;
  
}

cBound * minimumCBound ( cBound * node )
{
  
  if ( node == NULL ){
    return NULL;
  }
  
  while ( node->left != NULL ){
    node = node->left;
  }

  return node;

}

void printCBound ( cBound * root )
{
  if ( root == NULL ) return;
  printCBound ( root->left );
  printf ( "%d\n", root->column );
  printFragment ( root->rightr->frag );
  printCBound ( root->right );
}

dBound * createDBound ( int diagonal, owner * abover )
{
  dBound * newnode = ( dBound * ) malloc ( sizeof ( dBound ) );
  newnode->deleted = 0;
  newnode->diagonal = diagonal;
  newnode->hash = hash((diagonal>0)? diagonal: -diagonal);
  newnode->abover = abover;
  newnode->intpoint = NULL;
  newnode->left = NULL;
  newnode->right = NULL;
  newnode->parent = NULL;
  return newnode;
}

void insertDBound ( dBound * root, dBound * newnode, int caseNumber )
{
  int balance = 0;
  if ( caseNumber == 10){
    printf ( "\nInserting diagonal in dBound : %d\n", newnode->diagonal );
    printf ( "The fragment is : " );
    printFragment ( newnode->abover->frag );
  }

  if ( newnode == NULL ) return;

  if ( root == NULL && root == dBoundTreeRoot [caseNumber] ){
    
    dBoundTreeRoot [caseNumber] = newnode;
    return;
  }

  if ( root == NULL && root == rightDBoundTreeRoot [caseNumber] ){
    rightDBoundTreeRoot [caseNumber] = newnode;
    return;
  }

  if ( root == NULL ){
    printf ( "ERROR : insertDBound.\n" );
    return;
  }

  if ( root->diagonal > newnode->diagonal ){
    balance = 1;
    if ( root->left != NULL ){
      insertDBound ( root->left, newnode, caseNumber );
    }
    else{
      root->left = newnode;
      newnode->parent = root;
    }

  }

  else if ( root->diagonal < newnode->diagonal ) {
    balance = 2;
    if ( root->right != NULL ){
      insertDBound ( root->right, newnode, caseNumber );
    }
    else {
      root->right = newnode;
      newnode->parent = root;
    }
  
  }

  else {
    balance = 0;
    // Replace root by newnode.

    root->deleted = newnode->deleted;
    root->abover = newnode->abover;
    root->intpoint = newnode->intpoint;

  }
  
  if (balance == 1 && (root->left->hash < root->hash)) {
    dBound* newroot = root->left;
    dBound* temp = root->left->right;
    newroot->right = root;
    root->left = temp;
    if (temp) temp->parent = root;
    newroot->parent = root->parent;
    root->parent = newroot;
    if (root == dBoundTreeRoot [caseNumber])
      dBoundTreeRoot [caseNumber] = newroot;
    else if (root == rightDBoundTreeRoot [caseNumber])
      rightDBoundTreeRoot [caseNumber] = newroot;
    else if (newroot->parent->right == root) newroot->parent->right = newroot;
    else if (newroot->parent->left == root) newroot->parent->left = newroot;
    else {fprintf(stderr, "blah\n"); exit(2);}
  }
  
  else if (balance == 2 && (root->right->hash < root->hash)) {
    dBound* newroot = root->right;
    root->right = root->right->left;
    newroot->left = root;
    if (root->right) root->right->parent = root;
    newroot->parent = root->parent;
    root->parent = newroot;
    if (root == dBoundTreeRoot [caseNumber])
      dBoundTreeRoot [caseNumber] = newroot;
    else if (root == rightDBoundTreeRoot [caseNumber])
      rightDBoundTreeRoot [caseNumber] = newroot;
    else if (newroot->parent->right == root) newroot->parent->right =
					       newroot;
    else if (newroot->parent->left == root) newroot->parent->left = newroot;
    else {
      fprintf(stderr, "blah %x %x %x\n", newroot->parent->right,newroot->parent->left,root);
      exit(2);
    }
  }



  if ( caseNumber == 10 ){
    printf ( "The new dTree is :\n" );
    printDBound ( dBoundTreeRoot [ caseNumber ] );
  }

}

dBound * lookupDBound ( dBound * root, int diagonal )
{
  
  if ( root == NULL ) return NULL;

  if ( root->diagonal <= diagonal ){
    
    dBound * dbnode = lookupDBound ( root->right, diagonal );
    if ( dbnode == NULL ) return root;
    else return dbnode;

  }
  
  else {
    
    return lookupDBound ( root->left, diagonal );

  }

}

void deleteDBound ( dBound * node, int caseNumber )
{

  dBound * y;
  dBound * x;

  if ( caseNumber == 10){
    printf ( "\nDeleting diagonal in dBound : %d\n", node->diagonal );
    printf ( "The fragment is : " );
    printFragment ( node->abover->frag );
  }

  if ( node == NULL ) return;
  
  if ( node->left == NULL || node->right == NULL ){
    y = node;
  }
  else{
    y = successorDBound ( node );
  }
  
  if ( y->left != NULL ){
    x = y->left;
  }
  else{
    x = y->right;
  }

  if ( x != NULL ){
    x->parent = y->parent;
  }

  if ( y->parent == NULL ){
    if ( y == dBoundTreeRoot [caseNumber] ){
      dBoundTreeRoot [caseNumber] = x;
    }
    else if ( y == rightDBoundTreeRoot [caseNumber] ){
      rightDBoundTreeRoot [caseNumber] = x;
    }
    else{
      assert ( false );
    }
  }
  else if ( y == y->parent->left ){
    y->parent->left = x;
  }
  else {
    y->parent->right = x;
  }

  if ( y != node ){
    
    y->parent = node->parent;
    y->left = node->left;
    y->right = node->right;
    
    if ( node->parent != NULL ){
      
      if ( node == node->parent->left ){
	node->parent->left = y;
      }
      else if ( node == node->parent->right ) {
	node->parent->right = y;
      }      
      else {
	assert ( false );
      }
    
    }
    else {
      if (node == dBoundTreeRoot[caseNumber])
	dBoundTreeRoot[caseNumber] = y;
      else if (node == rightDBoundTreeRoot[caseNumber]){
	rightDBoundTreeRoot[caseNumber] = y;
      }
      else {
	fprintf (stderr,"no clue\n");
      }
    }


    if ( node->left != NULL ){
      node->left->parent = y;
    }
    
    if ( node->right != NULL ){
      node->right->parent = y;
    }

    //node->diagonal = y->diagonal;
    //node->abover = y->abover;
    //node->intpoint = y->intpoint;
  }
  //  printf("Freeing %x\n", node);
  free ( node );

  if ( caseNumber == 10 ){
    printf ( "The new dTree is :\n" );
    printDBound ( dBoundTreeRoot [ caseNumber ] );
  }

}

dBound * successorDBound ( dBound * node )
{
  
  dBound * y;

  if ( node == NULL ) return NULL;
  
  if ( node->right != NULL ){
    return minimumDBound ( node->right );
  }

  y = node->parent;
  
  while ( y != NULL && node == y->right ){
    node = y;
    y = y->parent;
  }
  
  return y;
  
}

dBound * minimumDBound ( dBound * node )
{
  
  if ( node == NULL ){
    return NULL;
  }
  
  while ( node->left != NULL ){
    node = node->left;
  }

  return node;

}

void printDBound ( dBound * root )
{
  if ( root == NULL ) return;
  printDBound ( root->left );
  printf ( "%d\n", root->diagonal );
  printFragment ( root->abover->frag );
  printDBound ( root->right );
}


char* rolltonum(char* str) {
  char *got1=0, *got2=0;
  int in=0, i=0;
  while (1) {
    if (str[i] == 0) {
      break;
    }
    if (str[i] == ';' && got1 && got2){
      return got1;
    }
    if (isdigit(str[i])) {
      if (!in && (!i || isspace(str[i-1]))) { 
        if (got1) 
          got2 = &str[i];
        else 
          got1 = &str[i];
        in = 1;
      }
    }
    else if (in && (isspace(str[i]))) {
      if (got2) {
        got1 = got2; got2=0; in = 0;
      }
      in = 0;
    }
 
    else {
      got1=got2=(char*)(in=0);
    }
    i++;
  }
  return &str[i];
}

int getline(FILE * infile, hll * tt) {
  char temp[1024];
  char* help;
  int z, h;
  fgets(temp, 1024, infile);
  help = rolltonum(temp);
  z = sscanf(help, "%d %d;%n", &tt->seq1start, &tt->seq1end, &h);
  if (z<2)
    return 0;
  help = rolltonum(help+h);
  if (sscanf(help,"%d %d; score = %f (%c)\n", &tt->seq2start,
             &tt->seq2end,&tt->score,&tt->strand)<3)
    return 0;
  return 1;
}


int parseCHAOS ( FILE * fp )
{

  int x1, y1, x2, y2, i=0;
  float score;
  char s1 [1024];
  char s2 [1024];
  char type;
  
  hll tt;
  while(!feof(fp)) {
    while (!feof(fp) && !getline(fp, &tt))
      ;

    if (feof(fp)) break;
    if (tt.score < cutoff)
      continue;

    //while ( ( fscanf ( fp, "%s %d %d; %s %d %d; score = %f (%c)", &s1, &x1,
    //		     &x2, &s2, &y1, &y2, &score, &type ) ) == 8 ){
    
    //     printf ( "%d %d - %d %d %f %c\n", tt.seq1start, tt.seq1end, tt.seq2start, tt.seq2end, tt.score,
    //	     tt.strand );
    
    fragment * frag = createFragment ( tt.seq1start, tt.seq1end, tt.seq2start,tt.seq2end, tt.score, tt.strand );

    point * a = createPoint ( frag->x1, frag->y1, frag, pBegin, none );
    point * b = createPoint ( frag->x2, frag->y2, frag, pEnd, none );
    point * c = createPoint ( frag->x1, (0 - frag->y1), frag, nBegin, none );
    point * d = createPoint ( frag->x2, (0 - frag->y2), frag, nEnd, none );

    insertPoint ( pointTreeRoot, a );
    insertPoint ( pointTreeRoot, b );
    insertPoint ( pointTreeRoot, c );
    insertPoint ( pointTreeRoot, d );
    i++;
    if (i % 10000 == 1)
      fprintf (stderr, "read %d\n",i);
    fragList.push_back ( frag );
    
  }
  
  return 1;

}

fragment * createFragment ( int x1, int x2, int y1, int y2, 
			    float score, char type )
{
    fragment * frag = ( fragment * ) malloc ( sizeof ( fragment ) );
    frag->x1 = x1; //( x1 < x2 ) ? x1 : x2;
    frag->x2 = x2; //( x1 > x2 ) ? x1 : x2;
    frag->y1 = y1; //( y1 < y2 ) ? y1 : y2;
    frag->y2 = y2; //( y1 > y2 ) ? y1 : y2;
    frag->dirty = 0;
    frag->score = score;
    frag->totalScore = 0;
    frag->backfrag = NULL;
    frag->momentum = positive;
    frag->type = ( type == '+' ) ? positive : negative;
    return frag;
}

float calculateScore ( fragment * f, int x, int y, int caseNumber )
{

  //printf ( "The fragment is : " );
  //printFragment ( f );
  //printf ( "The point is : %d, %d\n", x, y );
  //printf ( "The caseNumber is : %d\n", caseNumber );

  int xdist = 0;
  int ydist = 0;

  if ( f == NULL ) return 0;

  float score = f->totalScore;

  if ( f->x1 == 0 && f->x2 == 0 && f->y1 == 0 && f->y2 == 0 ){
    return score;
  }


    //  if (oldn != caseNumber)
    //    fprintf(stderr, "cn was %d, now %d\n", oldn, caseNumber);

  if ( caseNumber < 4 ){
   
    xdist = x - f->x2;
    ydist = y - f->y2;

  }
  
  else {
   
    xdist = x - f->x2;
    ydist = y + f->y2;

  }


  if ( xdist < 0 || ydist < 0 ){
    printf ( "The fragment is : " );
    printFragment ( f );
    printf ( "The point is : %d, %d\n", x, y );
    printf ( "The caseNumber is : %d\n", caseNumber );   
    printf ( "Xdist = %d, Ydist = %d\n", xdist, ydist );
  }
  
  assert ( xdist >= 0 );
  assert ( ydist >= 0 );

  int oldn = caseNumber;
  
  if (((caseNumber & 3) == 1) || ((caseNumber & 3) == 2)) {
    caseNumber = caseNumber & 5;
    caseNumber = caseNumber | (f->momentum << 1);
  }
  


  if ( xdist > ydist ){ 
    score -= ydist * repl [caseNumber];  
    score -= ( xdist - ydist ) * gapExtend [caseNumber];
    score -= gapOpen [caseNumber];
  }
  else if ( xdist < ydist ){
    score -= xdist * repl [caseNumber];  
    score -= ( ydist - xdist ) * gapExtend [caseNumber];
    score -= gapOpen [caseNumber];
  }
  else{
    score -= xdist * repl [caseNumber];
  }

  return score;
  
}

void processLeftInfluence ( point * curpoint, int caseNumber )
{

  if ( caseNumber == 10 ){
    printf ( "\n\nProcessing left influence for point : %d, %d, %d\n",
	     curpoint->x, curpoint->y, caseNumber );
  }

  if ( curpoint == NULL ) return;

  cBound * c = lookupCBound ( cBoundTreeRoot [caseNumber], curpoint->y );
  dBound * d = lookupDBound ( dBoundTreeRoot [caseNumber], curpoint->y - curpoint->x );

  //printf ( "Lookup returned column = %d, diagonal = %d\n", c->column,
  //	   d->diagonal );
  //printf ("intersectionRow = %d\n", intersectionRow );

  owner * winner;
  
  if ( c == NULL && d == NULL ){
    assert ( false );
  }
  
  else if ( c == NULL ){
    winner = d->abover;
  }
  
  else if ( d == NULL ){
    winner = c->rightr;
  }
  
  else{
    int intersectionRow = c->column - d->diagonal;
    
    if ( intersectionRow > curpoint->x ){
      winner = c->rightr;
    }
    else if ( intersectionRow < curpoint->x ){
      winner = d->abover;
    }
    else {
      winner = d->abover;
    }
  }

  if ( 
      ( calculateScore ( winner->frag, curpoint->x + 1, curpoint->y + 1,
			 caseNumber )) 
      >=
      ( calculateScore ( curpoint->frag, curpoint->x + 1, curpoint->y + 1,
			 caseNumber )) 
      ) {
	
    // Do nothing.
	
  }
      
  else {
	
    // Got a new region. Follow the algo in the paper.
	
    cBound * cSucc = successorCBound ( c );
    cBound * cSucc2 = successorCBound ( cSucc );
    dBound * dPred; 
    
    if ( d ) {
      dPred = lookupDBound ( dBoundTreeRoot [caseNumber], 
			     d->diagonal - 1 );
    }
    else{
      dPred = NULL;
    }
	
    assert ( dPred == NULL || successorDBound ( dPred ) == d );

    // Case (a) :
	
    if ( winner == c->rightr ){
	  
      // Case (a.1)
	  
      if ( !cSucc || cSucc->column > curpoint->y ){
	
	if ( caseNumber == 10 ){
	  printf ( "Case A1\n" );
	}
    
	// Generate two new entries for OWNER.
	    
	owner * newowner1 = createOwner ( curpoint->frag );
	owner * newowner2 = createOwner ( winner->frag );
	    
	insertOwnerAfter ( winner, newowner1, caseNumber );
	insertOwnerAfter ( newowner1, newowner2, caseNumber );
	    
	// Insert into cBound.
	    
	cBound * newC = createCBound ( curpoint->y, newowner1 );
	insertCBound ( cBoundTreeRoot [caseNumber], newC, caseNumber );
	    
	// Insert into dBound.
	    
	dBound * newD = createDBound ( curpoint->y - curpoint->x,
				       newowner2 );
	insertDBound ( dBoundTreeRoot [caseNumber], newD, caseNumber );

	// Insert into intersection list.
	    
	if ( ( cSucc != NULL ) && 
	     ( cSucc->intpoint == NULL ) &&
	     ( cSucc->column != LONG_MIN / 2 ) ){

	  point * intpt = createPoint ( ( cSucc->column - ( curpoint->y - curpoint->x ) ),
					( cSucc->column ),
					( NULL ),
					( intersection ),
					( caseNumber ) );
	      
	  cSucc->intpoint = intpt;
	  newD->intpoint = intpt;

	  if ( caseNumber == 10 )
	    printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
	      
	  insertPoint ( pointTreeRoot, intpt );

	}
	    
      }
	  
      // Case (a.2).
	  
      else if ( cSucc->column == curpoint-> y ){

	// If cSucc->rightr->frag is better than curpoint->frag at the
	// point curpoint->x + 1, curpoint->y + 1, then do nothing.

	if ( caseNumber == 10 ){
	  printf ( "Case A2\n" );
	}
	    
	if ( 
	    ( calculateScore ( cSucc->rightr->frag, curpoint->x + 1,
			       curpoint->y + 1, caseNumber )) 
	    >=
	    ( calculateScore ( curpoint->frag, curpoint->x + 1,
			       curpoint->y + 1, caseNumber )) 
	    ) {
	      
	  // Do nothing.
	}
	    
	else {
	     
	  // Insert into owner.

	  owner * newowner = createOwner ( curpoint->frag );
	  insertOwnerBefore ( cSucc->rightr, newowner, caseNumber );
	      
	  // Insert into dBound.
	      
	  dBound * newD = createDBound ( curpoint->y - curpoint->x,
					 cSucc->rightr );
	  insertDBound ( dBoundTreeRoot [caseNumber], newD, caseNumber );

	  // Insert into cBound.
	      
	  cSucc->rightr = newowner;

	  // Insert into intersection list.
	      
	  if ( cSucc2 != NULL && cSucc2->intpoint == NULL ){
		
	    point * intpt = createPoint ( ( cSucc2->column - ( curpoint->y - curpoint->x ) ),
					  ( cSucc2->column ),
					  ( NULL ),
					  ( intersection ),
					  ( caseNumber ) );
		
	    cSucc2->intpoint = intpt;
	    newD->intpoint = intpt;
	    if ( caseNumber == 10 )
	      printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
	    insertPoint ( pointTreeRoot, intpt );
		
	  }
	        
	}
	    
      }
	  
      // Case (a.3).

      else {
	    
	// Should never come here.
	printf ( "Error : No case (a.3).\n" );
	  
      }
	  
    }
	
    // Case b.
	
    else if ( winner == d->abover ){
	 	  
      // Case (b.1).
	  
      if ( ( d->diagonal < ( curpoint->y - curpoint->x ) ) && 
	   ( !cSucc || cSucc->column > curpoint->y ) ){

	if ( caseNumber == 10 ){
	  printf ( "Case B1\n" );
	}

	// Generate two new entries for OWNER.
	    
	owner * newowner1 = createOwner ( curpoint->frag );
	owner * newowner2 = createOwner ( winner->frag );
	    
	insertOwnerAfter ( winner, newowner1, caseNumber );
	insertOwnerAfter ( newowner1, newowner2, caseNumber );
	    
	// Insert into cBound.
	    
	cBound * newC = createCBound ( curpoint->y, newowner1 );
	insertCBound ( cBoundTreeRoot [caseNumber], newC, caseNumber );

	// Insert into dBound.
	    
	dBound * newD = createDBound ( curpoint->y - curpoint->x,
				       newowner2 );
	insertDBound ( dBoundTreeRoot [caseNumber], newD, caseNumber );
	    
	// Update Intersection lists.
	    
	// Delete intersection of d->diagonal and cSucc->column.
	    
	if ( ( cSucc != NULL ) &&
	     ( cSucc->intpoint != NULL ) &&
	     ( cSucc->intpoint->x == cSucc->column - d->diagonal ) ){
	      
	  if ( cSucc->intpoint != d->intpoint ){
	    printf ( "Error, intersection of column and diagonal not the same\n" );
	  }

	  if ( caseNumber == 10 ){
	    printf ( "Deleting intpoint : %d, %d\n", cSucc->intpoint->x,
		     cSucc->intpoint->y );
	  }
	  deletePoint ( cSucc->intpoint );
	  cSucc->intpoint = NULL;
	  d->intpoint = NULL;
	      
	}

	assert ( d->intpoint == NULL );

	// Add intersection of curpoint->y-x and cSucc->column.
	    
	if ( cSucc != NULL && cSucc->intpoint == NULL ){

	  point * intpt = createPoint ( ( cSucc->column - ( curpoint->y - curpoint->x ) ),
					( cSucc->column ),
					( NULL ),
					( intersection ),
					( caseNumber ) );
	      
	  cSucc->intpoint = intpt;
	  newD->intpoint = intpt;
	  if ( caseNumber == 10 )
	    printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
	  insertPoint ( pointTreeRoot, intpt );

	}
	    
	// Add intersection of d->diagonal and curpoint->column.
	
	if ( d->diagonal != LONG_MIN / 2 ){
	  
	  point * intpt = createPoint ( ( curpoint->y - d->diagonal ),
					( curpoint->y ),
					( NULL ),
					( intersection ),
					( caseNumber ) );	    
	  
	  newC->intpoint = intpt;
	  d->intpoint = intpt;
	  if ( caseNumber == 10 )
	    printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
	  insertPoint ( pointTreeRoot, intpt );
	  
	}
      
      }
	  
      // Case (b.2).
	  
      else if ( ( d->diagonal == ( curpoint->y - curpoint->x ) ) && 
		( !cSucc || cSucc->column > curpoint->y ) ){
	
	if ( caseNumber == 10 ){
	  printf ( "Case B2\n" );
	}
	
	// If d->abover->prev->frag is better than curpoint->frag at the
	// point curpoint->x + 1, curpoint->y + 1, then do nothing.
	    
	if ( 
	    ( calculateScore ( d->abover->prev->frag, curpoint->x + 1,
			       curpoint->y + 1, caseNumber )) 
	    >=
	    ( calculateScore ( curpoint->frag, curpoint->x + 1,
			       curpoint->y + 1, caseNumber )) 
	    ) {
	      
	  // Do nothing.
	}
	    
	else {
	  
	  // Insert into owner.
	      
	  owner * newowner = createOwner ( curpoint->frag );
	  insertOwnerBefore ( d->abover, newowner, caseNumber );
	      
	  // Insert into cBound.
	      
	  cBound * newC = createCBound ( curpoint->y, newowner );
	  insertCBound ( cBoundTreeRoot [caseNumber], newC, caseNumber );
	      
	  // Insert new intersection point.
	      
	  if ( ( dPred != NULL ) && 
	       ( dPred->intpoint == NULL ) &&
	       ( dPred->diagonal != LONG_MIN / 2 ) ){
	    
	    point * intpt = createPoint ( ( curpoint->y - dPred->diagonal ),
					  ( curpoint->y ),
					  ( NULL ),
					  ( intersection ),
					  ( caseNumber ) );		

	    newC->intpoint = intpt;
	    dPred->intpoint = intpt;
	    if ( caseNumber == 10 )
	      printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
	    insertPoint ( pointTreeRoot, intpt );
	    
	  }
	  
	}
	
      }
	  
      // Case (b.3).
	  
      else if ( cSucc && cSucc->column == curpoint-> y ){
	    
	if ( caseNumber == 10 ){
	  printf ( "Case B3\n" );
	}
	
	// If cSucc->rightr->frag is better than curpoint->frag at the
	// point curpoint->x + 1, curpoint->y + 1, then do nothing.
	    
	if ( 
	    ( calculateScore ( cSucc->rightr->frag, curpoint->x + 1,
			       curpoint->y + 1, caseNumber )) 
	    >=
	    ( calculateScore ( curpoint->frag, curpoint->x + 1,
			       curpoint->y + 1, caseNumber )) 
	    ) {
	      
	  // Do nothing.
	}
	    
	else {
	  
	  if ( cSucc->column == curpoint->x + d->diagonal ){
	    
	    cSucc->rightr->frag = curpoint->frag;

	  }

	  else {
	    
	    // Insert into owner.
	    
	    owner * newowner = createOwner ( curpoint->frag );
	    insertOwnerBefore ( cSucc->rightr, newowner, caseNumber );
	    
	    // Insert into dBound.
	    
	    dBound * newD = createDBound ( curpoint->y - curpoint->x,
					   cSucc->rightr );
	    insertDBound ( dBoundTreeRoot [caseNumber], newD, caseNumber );
	    
	    // Insert into cBound.
	    
	    cSucc->rightr = newowner;
	    
	    // Insert into intersection list.
	    
	    if ( cSucc2 != NULL && cSucc2->intpoint == NULL ){
	      
	      point * intpt = createPoint ( ( cSucc2->column - ( curpoint->y - curpoint->x ) ),
					    ( cSucc2->column ),
					    ( NULL ),
					    ( intersection ),
					    ( caseNumber ) );
	      
	      cSucc2->intpoint = intpt;
	      newD->intpoint = intpt;
	      if ( caseNumber == 10 )
		printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
	      insertPoint ( pointTreeRoot, intpt );
	      
	    }
	    
	  }	    
	  
	}
      
      }
	  
      // Case (b.4).
	  
      else {
	    
	// Should never come here.
	printf ( "Error : No case (b.4).\n" );
	  
      }

    }
	
    // Case c.
	
    else {
	  
      // Should never come here.
      printf ( "Error : No case (c).\n" );

    }
	
  }

}

void processRightInfluence ( point * curpoint, int caseNumber )
{
  
  if ( curpoint == NULL ) return;

  if ( caseNumber == 10 ){
    printf ( "\n\nProcessing right influence for point : %d, %d, %d\n",
	     curpoint->x, curpoint->y, caseNumber );
  }
  
  dBound * c = lookupDBound ( rightDBoundTreeRoot [caseNumber], curpoint->y - curpoint->x );

  owner * winner;
  
  if ( !c ){
    winner = createOwner ( NULL );
  }
  else{
    winner = c->abover;
  }

  if ( 
      ( calculateScore ( winner->frag, curpoint->x + 1, curpoint->y + 1, 
			 caseNumber )) 
      >=
      ( calculateScore ( curpoint->frag, curpoint->x + 1, curpoint->y + 1,
			 caseNumber )) 
      ) {
	
    // Do nothing.
    return;
    
  }

  // Got a new region. Follow the algo in the paper.  

  dBound * dSucc = successorDBound ( c );
  
  if ( dSucc && ( dSucc->diagonal == curpoint->y - curpoint->x ) ){
    
    if ( 
	( calculateScore ( dSucc->abover->frag, curpoint->x + 1,
			   curpoint->y + 1, caseNumber )) 
	>=
	( calculateScore ( curpoint->frag, curpoint->x + 1, 
			   curpoint->y + 1, caseNumber )) 
	) {
  
      // Do nothing.
      return;
      
    }
  
  }

  // Insert curpoint as a new column boundary.
  
  owner * newowner = createOwner ( curpoint->frag );
  dBound * newD = createDBound ( curpoint->y - curpoint->x, newowner );
    
  // Check if this line is already in the insertlist. If yes, then compare
  // thatC->frag score with this C->frag score, and retain whichever one
  // is better.
  
  bool toInsert = true;

  for ( int i = 0; i < insertlist[caseNumber].size(); i++ ){
    
    if ( insertlist[caseNumber][i]->diagonal == newD->diagonal ){
      
      if ( 
	  ( calculateScore ( insertlist[caseNumber][i]->abover->frag, curpoint->x + 1,
			     curpoint->y + 1, caseNumber )) 
	  >=
	  ( calculateScore ( curpoint->frag, curpoint->x + 1, 
			     curpoint->y + 1, caseNumber )) 
	  ){
	
	toInsert = false;
	
      }
      
      else {
	
	insertlist[caseNumber][i] = newD;
	
	toInsert = false;
      }
      
    }

  }

  if ( toInsert ){
    insertlist[caseNumber].push_back ( newD );
  }

  // Find all boundaries to be deleted.

  dBound * curDBound = dSucc;
  
  while ( ( curDBound != NULL ) && 
	  ( 
	   ( calculateScore ( curDBound->abover->frag, curpoint->x + 1,
			      curDBound->diagonal + curpoint->x + 1,
			      caseNumber )) 
	   <
	   ( calculateScore ( curpoint->frag, curpoint->x + 1,
			      curDBound->diagonal + curpoint->x + 1,
			      caseNumber )) 
	   ) 
	  ) {
    
    // Insert curCBound in the list of column boundaries to be deleted.
    
    if ( !curDBound->deleted ){
      deletelist[caseNumber].push_back ( curDBound );
      curDBound->deleted = 1;
    }

    curDBound = successorDBound ( curDBound );

  }


}

fragment * findLeftWinner ( point * curpoint, int caseNumber )
{

  if ( curpoint == NULL ) return NULL;

  cBound * c = lookupCBound ( cBoundTreeRoot [caseNumber], curpoint->y );
  dBound * d = lookupDBound ( dBoundTreeRoot [caseNumber], curpoint->y -
			      curpoint->x );
      
  if ( c == NULL && d == NULL ){
    return NULL;
  }

  if ( c == NULL ){
    return d->abover->frag;
  }

  if ( d == NULL ){
    return c->rightr->frag;
  }

  assert ( c );
  assert ( d );

  int intersectionRow = c->column - d->diagonal;
  owner * winner;
  //  fprintf(stderr, "here winner %d %d %d\n", c->column, d->diagonal, intersectionRow);
  if ( intersectionRow > curpoint->x ){
    //    fprintf(stderr, "here right\n");
    winner = c->rightr;
  }
  else if ( intersectionRow < curpoint->x ){
    //      fprintf(stderr, "here above\n");
      winner = d->abover;
  }
  else {
    //      fprintf(stderr, "here split\n");
    winner = d->abover;
  }
  
  return winner->frag;
  
}

fragment * findRightWinner ( point * curpoint, int caseNumber )
{

  if ( curpoint == NULL ) return NULL;

  dBound * rightD = lookupDBound ( rightDBoundTreeRoot [caseNumber], curpoint->y -
				   curpoint->x );
  
  if ( rightD == NULL ) return NULL;

  return rightD->abover->frag;

}


void processIntersection ( point * curpoint, int caseNumber )
{

  //  if ( caseNumber == 10 ){
  //  printf ( "\n\nProcessing intersection point : %d, %d, %d\n", curpoint->x,
  //	     curpoint->y, caseNumber );
    //  }

  cBound * c = lookupCBound ( cBoundTreeRoot [caseNumber], curpoint->y );
  dBound * d = lookupDBound ( dBoundTreeRoot [caseNumber], curpoint->y - curpoint->x );
  dBound * dPred = lookupDBound ( dBoundTreeRoot [caseNumber], d->diagonal - 1 );
  
  assert ( dPred == NULL || successorDBound ( dPred ) == d );
  
  owner * r = d->abover->next;
  owner * r1 = d->abover;
  owner * r2 = d->abover->prev;
  
  cBound * cSucc = successorCBound ( c );
  assert ( cSucc );
  assert ( cSucc->column == curpoint->y );
  assert ( d->intpoint == curpoint );
  assert ( cSucc->intpoint == curpoint );
  
  if ( cSucc->rightr != r ){
    
    printf ( "Case : %d\n", caseNumber );
    printf ( "Row : %d\n", curpoint->x );
    printf ( "Column : %d\n", cSucc->column );
    
    printf ( "c->column = %d\n", c->column );
    printf ( "d->diagonal = %d\n", d->diagonal );
    
    printFragment ( cSucc->rightr->frag );
    printFragment ( r->frag );
    printFragment ( r1->frag );
    printFragment ( r2->frag );
    
    printCBound ( cBoundTreeRoot [caseNumber] );
    printDBound ( dBoundTreeRoot [caseNumber] );
    printOwnerList ( ownerListHead [caseNumber] );
  
  }
   
  assert ( cSucc->rightr == r );      
  cBound * cSucc2 = successorCBound ( cSucc );      
  
  // Remove r1 from owner.
  
  deleteOwner ( r1, caseNumber );
  
  // See who is better among r2 and r.
  
  if ( 
      ( calculateScore ( r->frag, curpoint->x + 1, curpoint->y + 1, caseNumber )) 
      >=
      ( calculateScore ( r2->frag, curpoint->x + 1, curpoint->y + 1, caseNumber )) 
      ) {
    
    // r is better.
    
    // Delete from dBound.
    
    deleteDBound ( d, caseNumber );
    
    // cSucc does not intersect anyone now.
    
    cSucc->intpoint = NULL;
    
    // Update intersection points.
    
    if ( ( dPred != NULL ) && 
	 ( dPred->intpoint == NULL ) &&
	 ( dPred->diagonal !=  LONG_MIN / 2 ) ){
      
      point * intpt = createPoint ( ( curpoint->y - dPred->diagonal ),
				    ( curpoint->y ),
				    ( NULL ),
				    ( intersection ),
				    ( caseNumber ) );      

      cSucc->intpoint = intpt;
      dPred->intpoint = intpt;
      if ( caseNumber == 10 )
	printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
      insertPoint ( pointTreeRoot, intpt );
      
    }
    
  }
  
  else {
    
    // r2 is better.
    
    // Set abover.
    
    d->abover = r;
    
    // Delete from cBound.
    
    deleteCBound ( cSucc, caseNumber );
    
    // d does not intersect anyone now.
    
    d->intpoint = NULL;
    
    // See if d intersects cSucc2.
    
    if ( cSucc2 != NULL && cSucc2->intpoint == NULL ){
      
      point * intpt = createPoint ( ( cSucc2->column - ( d->diagonal ) ),
				    ( cSucc2->column ),
				    ( NULL ),
				    ( intersection ),
				    ( caseNumber ) );      

      cSucc2->intpoint = intpt;
      d->intpoint = intpt;
      if ( caseNumber == 10 )
	printf ( "Inserting intpoint : %d, %d\n", intpt->x, intpt->y ); 
      insertPoint ( pointTreeRoot, intpt );
      
    }
    
  }
  
}

void printOutput ()
{
  float max=-1;
  int argmax=-1;
  fragment * curfrag, *oldfrag=0;
  for ( int i = 0; i < fragList.size(); i++ ){
    if (fragList[i]->totalScore > max) {
      argmax = i;
      max = fragList[i]->totalScore;
    }
  }
  if (argmax < 0)
    return;
  curfrag = fragList[argmax];
  
  while ( curfrag ){  
    printFragment ( curfrag );
    oldfrag = curfrag;
    curfrag = curfrag->backfrag;
  }

}

void printFragment ( fragment * curfrag )
{

  if ( curfrag == NULL ) {
    printf ( "Fragment was null.\n");
    return;
  }

  printf ( "(%d %d)=(%d %d) %f %c [%f]\n",
	   curfrag->x1,
	   curfrag->x2,
	   curfrag->y1,
	   curfrag->y2,
	   curfrag->score,
	   (curfrag->type==positive)?'+':'-',
	   curfrag->totalScore );
}

