# -*- ruby -*-

require 'lens/message'

class Message
  def sobigf?
    self['Content-Type'] =~ /multipart/ &&
      subject =~ /(Your application|Details|Thank you!|That movie|Wicked screensaver|Your details|Approved|My details)/
  end

  def spam_contents?
    # $BFbMF$+$i$N(BSPAM$BH=Dj%k!<%A%s$,$"$l$P$3$3$K5-=R$9$k!#(B.lensrc$BFb$G(B spam_contents? $B$rDj5A$7$F$b$h$$!#(B
    # system "/home/masui/bin/bsfilter -m rf --homedir /home/masui/SpamFilter/.bsfilter < #{path}"
    false
  end

  def have_spam_pat?(config)
    config[:spam_patterns].find { |entry,patterns|
      patterns.find { |pattern|
	self[entry] =~ pattern
      }
    }
  end

  def spam?(config)
    sobigf? || spam_contents? || have_spam_pat?(config)
  end

  def not_important?(config)
    config[:non_important_mls][ml_name]
  end

  def forward_to_mobile_phone?(config)
    !spam?(config) && !not_important?(config)
  end

  def refile_folders(config)
    config[:subject_patterns].find_all { |pat,folder|
      Regexp.new(pat,true).match(subject)
    }.collect { |key,val| val } |
    config[:from_patterns].find_all { |pat,folder|
      Regexp.new(pat,true).match(self['From']) ||
	Regexp.new(pat,true).match(self['To']) ||
	Regexp.new(pat,true).match(self['Cc'])
    }.collect { |key,val| val }.flatten |
      (ml_name ? [ml_name] : [])
  end

  def commandmail?
    subject =~ /^\S+[\+\?!]$/
  end
end
