#!/usr/bin/env ruby
# -*- ruby -*-

require 'rbconfig'

home = ENV['HOME']
bindir = ARGV.shift
sitelibdir = Config::CONFIG['sitelibdir']
lenslibdir = "#{sitelibdir}/lens"

LIBFILES = [
  'lens.rb',
  'maildir.rb',
  'message.rb',
  'parsedate.rb',
  'classify.rb',
]

Dir.mkdir(lenslibdir) if ! File.exist?(lenslibdir)
LIBFILES.each { |libfile|
  puts "cp -f #{libfile} #{lenslibdir}"
  system "cp -f #{libfile} #{lenslibdir}"
}

puts "cp -f lens #{bindir}"
system "cp -f lens #{bindir}"

lensrc = "#{home}/.lensrc"
if !File.exist?(lensrc) then
  puts "cp lensrc.sample #{lensrc}"
  system "cp lensrc.sample #{lensrc}"
end

commandmailrc = "#{home}/.commandmailrc"
if !File.exist?(commandmailrc) then
  puts "cp commandmailrc.sample #{commandmailrc}"
  system "cp commandmailrc.sample #{commandmailrc}"
end
