# -*- ruby -*-

require 'net/smtp'
require 'parsedate'

require 'lens/maildir'
require 'lens/message'
require 'lens/classify'
require 'lens/parsedate'

class Lens
  def initialize(config,arg)
    @config = config
    @arg = arg
    @maildir = @config[:maildir]
  end

  def process
    if @arg.nil?
      message = Message.new # $BI8=`F~NO(B
      messages = [message]
      message.refile(@maildir) unless message.spam?(@config) # inbox$B$K%3%T!<(B
    else
      starttime = ParseDate.time(@arg)
      md = Maildir.new(@maildir)
      messages = md.find_all { |message|
	message.time >= starttime
      }
    end

    messages.each { |message|
      printf("%s Subject: %s \n",message.path,message.subject)

      # SPAM$BG'Dj%a!<%k$O(Bspam$B%U%)%k%@Aw$j(B
      if message.spam?(@config) then
	message.refile(@maildir,'00Spam')
	puts "   ==> spam"
	message.delete
	next
      end

      # SPAM$B0J30$O$9$Y$F(B2003/3$B$N$h$&$J%U%)%k%@$KJ]B8(B
      message.refile(@maildir,"#{message.time.year}/#{message.time.mon}")
      
      # $B7HBS$KE>Aw$9$k$+(B
      if @arg.nil? &&  @config[:mobile_address] && message.forward_to_mobile_phone?(@config) then
	Net::SMTP.start(@config[:smtp_host], 25) { |smtp|
	  smtp.send_mail(message.text,@config[:local_address],
			 @config[:mobile_address])
	}
      end

      # $B%3%^%s%I%a!<%k=hM}(B
      if defined?(CommandMailHandler) && message.commandmail? then
	CommandMailHandler.new(message).process
      end

      # $B<+F/?6$jJ,$1(B
      if folders = message.refile_folders(@config) then
	folders.each { |folder|
	  message.refile(@maildir,folder)
	  puts "   +=> #{folder}"
	}
	if message.not_important?(@config) then
	  message.delete
	end
      end

      message.delete if message.stdin
    }
  end
end
