# -*- ruby -*-
#
# Maildir$B7A<0$N%U%!%$%k$rA`:n(B
#

require 'lens/message'

class Maildir
  def initialize(maildir, folder = nil)
    @folderdir = (folder ? "#{maildir}/.#{folder.gsub('/','.')}" : maildir)
    if !test(?d,@folderdir) then
      Dir.mkdir(@folderdir)
      Dir.mkdir("#{@folderdir}/cur")
      Dir.mkdir("#{@folderdir}/new")
      Dir.mkdir("#{@folderdir}/tmp")
    end
    @curdir = Dir.new("#{@folderdir}/cur")
  end

  def messagepath(path)
    "#{@folderdir}/cur/#{File.basename(path)}"
  end

  def each
    @curdir.each { |file|
      path = messagepath(file)
      if test(?f,path) then
	message = Message.new(path)
	yield message
      end
    }
  end
end

