# -*- ruby -*-

require 'mailread'
require 'kconv'
require 'socket' # for hostname

require 'lens/parsedate'
require 'lens/maildir'

class Message
  def initialize(path = nil)
    if path.nil? then # $BI8=`F~NO$+$i%a%C%;!<%8FI$_9~$_(B
      hostname = Socket.gethostname
      @stdin = true
      @text = STDIN.readlines
      date = @text.grep(/^Date:/)[0]
      time = date ? ParseDate.time(date) : Time.now
      @path = "/tmp/#{time.to_i}.#{$$}.#{hostname}"
      File.open(@path,"w"){ |f|
	f.print @text
      }
    else
      @path = path
      @stdin = false
      File.open(@path,"r"){ |f|
	@text = f.readlines
      }
    end
    @mail = Mail.new(@path)
  end

  attr :path, true
  attr :text, true
  attr :stdin, true

  def refile(maildir, folder = nil)
    md = Maildir.new(maildir, folder)
    refilepath = md.messagepath(@path)
    if !test(?f,refilepath) then
      # File.link(@path,refilepath)
      system "cp #{@path} #{refilepath}"
    end
  end

  def delete
    File.delete(@path)
  end

  def [](entry)
    @mail[entry].to_s
  end

  def subject
    self['Subject'].toeuc.gsub(/[\r\n]+/,'')
  end

  def body
    @mail.body
  end

  def header
    @mail.header
  end

  def time
    self['Date'] ? ParseDate.time(self['Date']) : File.stat(@path).mtime
  end

  def ml_name
    subject =~ /\[([\d\w\-_]+):\d*\]/
    $1
  end
end
