
# If you don't like the prefix '/usr' you can override it like this:
# rpm -ba|--rebuild --define 'prefix /usr/local'
%{?!prefix:%define prefix %{prefixdef}}

Name:		lft
Version:	2.3
Release:	0
Vendor:		VOSTROM
Packager:	Victor Oppleman <lft@oppleman.com>
URL:		http://www.oppleman.com/lft/
Source:		%{name}-%{version}.tar.gz
Group:		Applications/Internet
License:	VOSTROM Public License
Provides:	lft
Requires:	libpcap
BuildRoot:	%{_tmppath}/root-%{name}-%{version}
Prefix:		%{_prefix}
Summary:	Alternative traceroute tool for network (reverse) engineers

BuildRequires: libpcap
Obsoletes: fft

%description
LFT, short for Layer Four Traceroute, is a sort of 'traceroute' that
often works much faster (than the commonly-used Van Jacobson method) and
goes through many configurations of packet-filter based firewalls. More
importantly, LFT implements numerous other features including AS number
lookups, loose source routing, netblock name lookups, et al.

%prep
%setup

%build
%configure
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%makeinstall DESTDIR="%{buildroot}%{_bindir}" MANDIR="%{buildroot}%{_mandir}/man8"

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-, root, root, 0755)
%{_mandir}/man8/*
%doc CHANGELOG COPYING README TODO lft-manpage.html

%attr(4755, root, root) %{_bindir}/lft

%changelog
* Fri Nov 26 2004 Victor Oppleman <lft@oppleman.com>
- Cleaned up various files, updated to support LFT 2.3

* Sun Apr 20 2003 Nils McCarthy <nils@shkoo.com>
- Incorporated changes from Dag Wieers <dag@wieers.com> cleaning up
- a lot of the build process.

* Thu Mar 06 2003 Nils McCarthy <nils@shkoo.com>
- revised to work with autoconf

* Mon Oct 28 2002 Florin Andrei <florin@sgi.com>
- first version
- v2.0-1
