Summary: The C++ Debugging Support Library, for ostream debug output and memory allocation debugging.
Name: libcwd
%define __prefix /usr
%define version 0.99.45
Version: %{version}
Release: 1
Group: Development/Libraries
Source: http://download.sourceforge.net/libcwd/libcwd-%{version}.tar.gz
License: QPL
%ifos linux
Requires: gcc-c++ >= 3.0, binutils >= 2.9
%endif
Buildroot: %{_tmppath}/%{name}-root
BuildPrereq: make, m4, which >= 2.5, autoconf >= 2.13, automake >= 1.6, libtool >= 1.4.2
URL: http://libcwd.sourceforge.net/

%description
Libcwd is a full-featured, professional, well documented library to support
C++ developers with debugging their applications.  It includes support for
ostream-based debug output, custom debug channels and devices, threading,
powerful memory allocation debugging, run-time sourcefile:linenumber
information and demangled type-names of variables.

%prep
%setup

%build
./configure --prefix=%{__prefix}
make

%install
rm -rf "$RPM_BUILD_ROOT"
make DESTDIR="$RPM_BUILD_ROOT" install
tar --exclude .svn -czf example-project.tar.gz example-project

%clean
rm -rf "$RPM_BUILD_ROOT"

%post
PATH="$PATH:/sbin" ldconfig -n %{__prefix}/lib
echo
echo "Please look at %{__prefix}/doc/libcwd-%{version}/example-project.tar.gz"
echo "for an example of how to write an application that uses libcwd."
echo "Detailed documentation can be found in"
echo "file://%{__prefix}/doc/libcwd-%{version}/index.html"
echo

%files
%defattr(-,root,root)
%doc example-project.tar.gz
%doc documentation/0README
%doc documentation/tutorial
%doc documentation/reference-manual
%doc documentation/scripts
%doc documentation/styles
%doc documentation/images
%doc documentation/external
%doc documentation/doxygen-examples
%doc documentation/www
%doc documentation/index.html
%dir %{__prefix}/include/libcwd
%{__prefix}/lib/*
%{__prefix}/lib/pkgconfig/*.pc
%{__prefix}/include/libcwd/*
%{__prefix}/share/libcwd/libcwdrc

%changelog
* Fri Mar 12 2004 Carlo Wood <libcwd@alinoe.com>
- Added pkgconfig support.

* Sat May  3 2003 Carlo Wood <libcwd@alinoe.com>
- 0.99.29 needs g++ 3.0 or higher.
- Headers were moved to include/libcwd.

* Mon Apr 14 2003 Carlo Wood <libcwd@alinoe.com>
- Renamed include/libcw to include/libcwd.

* Tue Mar 19 2002 Carlo Wood <libcwd@alinoe.com>
- Corrected URL and source url.
- Reference manual sits in documentation/reference-manual as of 0.99.19.
- Require libtool 1.4.2 or higher.
- Improved summary.

* Mon Mar 18 2002 Carlo Wood <libcwd@alinoe.com>
- Require automake 1.5 or higher.

* Wed Mar 14 2002 Carlo Wood <libcwd@alinoe.com>
- Added documentation/www and documentation/index.html as main page.

* Wed Feb 13 2002 Carlo Wood <libcwd@alinoe.com>
- Allow also version of autoconf larger than 2.13.

* Sun Dec 09 2001 Carlo Wood <libcwd@alinoe.com>
- Added a URL: and BuildPrereq: entry.
- Added doxygen documentation to the rpm.

* Wed Sep 13 2000 Carlo Wood <libcwd@alinoe.com>
- Added example-project to doc/ and added a %post instruction echo.

* Sat Sep 02 2000 Carlo Wood <libcwd@alinoe.com>
- Still generate libcwd.lsm and libcwd.spec in config.status, but only
  when initiated from maintMakefile according to Makefile rules.
  Put them in $(srcdir) because they need to be put in the distribution.
- Add file list to %files.  Added a 'Requires:' and started to use macros for prefix and version.
- Use '@@' instead of '!!' because now the spec file is generated from spec.in by config.status.

* Thu Aug 31 2000 Carlo Wood <libcwd@alinoe.com>
- Remove build root in %clean.
- Initial version.

