require 5.004;
use strict;

my $NAME    = 'DBIWrapper';
my $VERSION = "0.19";
my $DISTNAME= "libdbiwrapper-perl";

# Check for non-standard modules that are used by this library.
$| = 1;
my $missing_modules = 0;

print "Checking for DBI...........";
eval {
    require DBI;
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The DBI module must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

if ($missing_modules)
{
  print <<EOT;
The missing modules can be obtained from CPAN.  Visit
<URL:http://www.perl.com/CPAN/> to find a CPAN site near you.

EOT
  exit(1);
}

use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

WriteMakefile(
    'NAME'      => $NAME,
    'VERSION'   => $VERSION,
    'DISTNAME'  => $DISTNAME,
    'PREREQ_PM' => { DBI => 0 },
    'AUTHOR'    => 'James A. Pattie <james@pcxperience.com>',
    'ABSTRACT'  => 'DBI Wrapper Module.',
);
