/*

    Class/template system for threading using pthreads
    Copyright (C) 2002 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <unistd.h>
#include <sys/types.h>
#include <pthread.h>
#include <map>

#include <Mutex.hh>


#ifndef DYNTHREADS_HH
#define DYNTHREADS_HH


    typedef std::map<int, pthread_t> ThreadMap_t;


    class clDynThreadsBase
    {
            int iThreadCount;
            ThreadMap_t mapThreads;
            clMutex MtxBase;
        public:
            typedef struct _stParams
            {
                clDynThreadsBase *Klass;
                void *vpParam;
            } stParams, *stpParams;
            clDynThreadsBase ();
            virtual ~clDynThreadsBase ();
            int Create (void *, bool);
            void *Wait (int);
            pthread_t Self ()
                { return pthread_self(); }
            bool SetSched (pthread_t, int, int);
            virtual void *InternalCaller (void *) = 0;
    };
    
    
    template <class TThreads> class clDynThreads :
        public clDynThreadsBase
    {
        public:
            typedef void *(TThreads::*Method_t)(void *);
            typedef struct _stParams2
            {
                Method_t Method;
                void *vpParam;
            } stParams2, *stpParams2;
            TThreads *Klass;
            clDynThreads (TThreads &KlassInst)
                { Klass = &KlassInst; }
            int Create (Method_t Method, void *vpParam, bool bDetached = false)
                {
                    stpParams2 spParams;
                    
                    spParams = new stParams2;
                    spParams->Method = Method;
                    spParams->vpParam = vpParam;
                    
                    return clDynThreadsBase::Create((void *) spParams, 
                        bDetached);
                }
            virtual void *InternalCaller (void *vpParam)
                {
                    stpParams2 spParams = (stpParams2) vpParam;
                    Method_t Method = spParams->Method;
                    void *vpThreadParam = spParams->vpParam;
                    
                    delete spParams;
                    try
                    {
                        return (Klass->*Method)(vpThreadParam);
                    }
                    catch (...)
                    {
                        pthread_exit(NULL);
                    }
                    return NULL;  // dummy for Intel C++
                }
    };

#endif
