/*

    Decimation filter for rate 8
    Copyright (C) 2000 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Low pass FIR filter derived using FFT method with Kaiser window (715 terms).
    Generated by SYSTOLIX Filter Synthesis at 0:08:59 on 5.9.2000.
    Specification:
    F1 = 0.05625
    F2 = 0.0625
    Passband Ripple = 0.5dB
    Stopband Ripple = 72dB

*/


#ifdef _MSC_VER
#pragma warning(disable:4305)
#endif


static const long lDec8FilterLen = 715l;

static const float fDec8FilterGain = 1.0f;
static const float fpDec8FilterCoeffs[] = {
5.11007631269058E-06,
4.40977516126714E-06,
2.92447571220828E-06,
7.78419775752953E-07,
-1.78163334120875E-06,
-4.41107148777256E-06,
-6.71088358672802E-06,
-8.28486910255114E-06,
-8.80281661458557E-06,
-8.06011472840016E-06,
-6.02388471496826E-06,
-2.85691036057063E-06,
1.086665580714E-06,
5.29600551865796E-06,
9.16613249541993E-06,
1.2081288051041E-05,
1.35080893310192E-05,
1.30849504817894E-05,
1.06935981776736E-05,
6.50003030964996E-06,
9.55881530979813E-07,
-5.24352124433557E-06,
-1.12417930667653E-05,
-1.61357381047252E-05,
-1.91065438560683E-05,
-1.9549463311611E-05,
-1.71822510213959E-05,
-1.21142522895573E-05,
-4.86255935698405E-06,
3.6914252979467E-06,
1.24032129742481E-05,
2.00136005065911E-05,
2.53256588639171E-05,
2.73861211586086E-05,
2.56444887001235E-05,
2.00645345448009E-05,
1.11681364233192E-05,
-3.5319469731581E-18,
-1.19872192071837E-05,
-2.31160998598231E-05,
-3.17137270159562E-05,
-3.63564659794252E-05,
-3.60952551872196E-05,
-3.06269314824131E-05,
-2.03827387024668E-05,
-6.51544970945648E-06,
9.21976983934031E-06,
2.46803190710461E-05,
3.76217467188432E-05,
4.60167789805457E-05,
4.8363327050366E-05,
4.39358098111073E-05,
3.29395568356585E-05,
1.65397250423175E-05,
-3.24726672445468E-06,
-2.37924452298114E-05,
-4.21963639841112E-05,
-5.569111115427E-05,
-6.2047474930714E-05,
-5.99285012522365E-05,
-4.91350199192509E-05,
-3.07012396582399E-05,
-6.81786032144021E-06,
1.94161141435325E-05,
4.43867682203568E-05,
6.44552580005777E-05,
7.64790499869327E-05,
7.82909144379751E-05,
6.90642167333466E-05,
4.95055644401321E-05,
2.18376006149165E-05,
-1.04369734063661E-05,
-4.29679634160319E-05,
-7.11351073597517E-05,
-9.06949999778749E-05,
-9.84081712896871E-05,
-9.25551579472124E-05,
-7.32616525492422E-05,
-4.25761675011832E-05,
-4.27635002246548E-06,
3.65821151860161E-05,
7.43223783597081E-05,
1.03425276963034E-04,
1.19324669704923E-04,
1.19106150305943E-04,
1.02004321634738E-04,
6.96175621019232E-05,
2.57957676667815E-05,
-2.37987371107575E-05,
-7.24100954654402E-05,
-1.13098279241855E-04,
-1.39718056353472E-04,
-1.4783103208243E-04,
-1.35417387863975E-04,
-1.03276352381299E-04,
-5.50437814716729E-05,
3.1933674141078E-06,
6.36492212600666E-05,
1.17867364450305E-04,
1.57891385592954E-04,
1.77417241680811E-04,
1.72762476206625E-04,
1.43506084275265E-04,
9.2693288495645E-05,
2.65568429442928E-05,
-4.62267411982861E-05,
-1.15660588585853E-04,
-1.71787224835238E-04,
-2.06101614037666E-04,
-2.12818908333164E-04,
-1.89810529434319E-04,
-1.39061458290148E-04,
-6.65634849043368E-05,
1.83642083602005E-05,
1.04254697840109E-04,
1.79026645025985E-04,
2.31668394867289E-04,
2.53840139829003E-04,
2.41163516117248E-04,
1.94002951759912E-04,
1.17607279986277E-04,
2.15656117181478E-05,
-8.13730778568352E-05,
-1.76974930962404E-04,
-2.51473223461644E-04,
-2.93531944257087E-04,
-2.95943322001588E-04,
-2.56808464758698E-04,
-1.80013703858927E-04,
-7.4907721083407E-05,
4.48059189235795E-05,
1.62834505957522E-04,
2.62495775819491E-04,
3.29056904819955E-04,
3.51887480716507E-04,
3.26114985012053E-04,
2.5352993690135E-04,
1.42584486440094E-04,
7.45062755800353E-06,
-1.33764056121147E-04,
-2.61422419999934E-04,
-3.57068779583035E-04,
-4.0607333724229E-04,
-3.99834185058333E-04,
-3.37209820870782E-04,
-2.24951915929093E-04,
-7.70409471672218E-05,
8.70212473860079E-05,
2.44758676473575E-04,
3.73778982247847E-04,
4.54928772654997E-04,
4.75104991919175E-04,
4.2931370757631E-04,
3.21659454584507E-04,
1.65088013808285E-04,
-2.01248546793022E-05,
-2.08969580638708E-04,
-3.75055820274168E-04,
-4.94276221761938E-04,
-5.48275552065005E-04,
-5.27229850793684E-04,
-4.3152052885919E-04,
-2.72029869028777E-04,
-6.8969320753154E-05,
1.50644313031941E-04,
3.56555331104747E-04,
5.19411467801817E-04,
6.1491854642264E-04,
6.27423273392398E-04,
5.52400997661569E-04,
3.97461997810631E-04,
1.81685565437725E-04,
-6.6679808766564E-05,
-3.13880649695086E-04,
-5.25216778517018E-04,
-6.69882125404327E-04,
-7.25416814018607E-04,
-6.81132064606672E-04,
-5.39993182352118E-04,
-3.18646048269203E-04,
-4.5523396846382E-05,
2.42764934914238E-04,
5.06305827381731E-04,
7.07376668087887E-04,
8.15807315704632E-04,
8.13453022368273E-04,
6.97121958035175E-04,
4.79497292808301E-04,
1.87860959921469E-04,
-1.39271094974664E-04,
-4.57195613618408E-04,
-7.21095175202906E-04,
-8.92317668591313E-04,
-9.4398739395698E-04,
-8.65139685672427E-04,
-6.62753079744486E-04,
-3.61328712824451E-04,
5.59846047464961E-17,
3.72498347533531E-04,
7.04362436393851E-04,
9.47882667319901E-04,
1.06625356603348E-03,
1.03906440833276E-03,
8.6566058344627E-04,
5.65839512057467E-04,
1.77702336441268E-04,
-2.47124084868245E-04,
-6.50305206091581E-04,
-9.74763377733084E-04,
-1.17270781406782E-03,
-1.21260697881321E-03,
-1.08409477228995E-03,
-8.00061043652871E-04,
-3.95548889343828E-04,
7.64828268590489E-05,
5.52032473142959E-04,
9.64680860536062E-04,
1.25481357915796E-03,
1.3781672729596E-03,
1.31248334486752E-03,
1.0612812843461E-03,
6.54137597719031E-04,
1.43327152971923E-04,
-4.02811422525139E-04,
-9.08955492219526E-04,
-1.30312573013314E-03,
-1.52685337856858E-03,
-1.54376049087077E-03,
-1.34530593218871E-03,
-9.52809395996536E-04,
-4.15359940500072E-04,
1.96220604379898E-04,
7.98632361223091E-04,
1.30737185076807E-03,
1.64850997457329E-03,
1.76934213606894E-03,
1.64638849112164E-03,
1.28954761535022E-03,
7.41708962269882E-04,
7.37434111457396E-05,
-6.24565502140761E-04,
-1.25650339060125E-03,
-1.73173274917677E-03,
-1.97910727762026E-03,
-1.95718837186296E-03,
-1.66092660711633E-03,
-1.12346073731216E-03,
-4.12637115191104E-04,
3.77422502219123E-04,
1.13867598801061E-03,
1.76383183591011E-03,
2.16135804994036E-03,
2.26874450672835E-03,
2.06211546785384E-03,
1.56074078337845E-03,
8.25662030342439E-04,
-4.75532290246456E-05,
-9.41096860269775E-04,
-1.73068532524285E-03,
-2.30271235650441E-03,
-2.57043988642794E-03,
-2.48694034757958E-03,
-2.05288612882479E-03,
-1.31794136025265E-03,
-3.7536395630419E-04,
6.49640758769128E-04,
1.61638681020172E-03,
2.38785133901766E-03,
2.84991266495946E-03,
2.92800611374705E-03,
2.5987964185872E-03,
1.89508316057526E-03,
9.03040521107917E-04,
-2.48069931043484E-04,
-1.40252380256192E-03,
-2.39898719497264E-03,
-3.0928347087259E-03,
-3.37687526123683E-03,
-3.19755078968172E-03,
-2.56420588087862E-03,
-1.54990967745021E-03,
-2.83433988590752E-04,
1.06679427863957E-03,
2.31480748184832E-03,
3.28241232687174E-03,
3.82429905619735E-03,
3.8494509842216E-03,
3.33575390939662E-03,
2.33554032042541E-03,
9.70980287347591E-04,
-5.80401384761846E-04,
-2.10842588711257E-03,
-3.39832768243562E-03,
-4.26049313903086E-03,
-4.5578114320367E-03,
-4.22676138180854E-03,
-3.28908130995446E-03,
-1.85205268155853E-03,
-9.69260431551716E-05,
1.74336474969636E-03,
3.41453428113533E-03,
4.67544734649579E-03,
5.33219109239423E-03,
5.26699760136024E-03,
4.45781899266792E-03,
2.98547412888714E-03,
1.02686813248091E-03,
-1.1653647731412E-03,
-3.29456955917589E-03,
-5.05925748986435E-03,
-6.19471366909442E-03,
-6.51142043052731E-03,
-5.92488488302496E-03,
-4.47239453044281E-03,
-2.31380685655338E-03,
2.84479829041667E-04,
2.98098200886886E-03,
5.40246536908285E-03,
7.19383727671873E-03,
8.06813925100415E-03,
7.8498586051297E-03,
6.5053481618408E-03,
4.15556795919664E-03,
1.06849146908629E-03,
-2.36889949187402E-03,
-5.69639250641138E-03,
-8.43895965553601E-03,
-1.01707322885837E-02,
-1.05763476008097E-02,
-0.009501382406037,
-6.98456369413089E-03,
-3.26641259415541E-03,
1.22827042213419E-03,
5.9334530059929E-03,
1.02065286986407E-02,
1.34077022899271E-02,
1.49849829704066E-02,
1.45544625372677E-02,
1.19655799715868E-02,
7.34237158895045E-03,
1.09416803644867E-03,
-6.10743160737485E-03,
-1.33845798948831E-02,
-1.97374929484199E-02,
-2.41487810268221E-02,
-2.56967990608734E-02,
-2.36654919291117E-02,
-1.76380999373613E-02,
-7.56345188122577E-03,
6.21371437875127E-03,
0.022963184864223,
4.16208081159964E-02,
0.060876914527277,
7.92931937656223E-02,
9.54362812101476E-02,
0.10801424544424,
0.116001630677908,
0.118739769000088,
0.116001630677908,
0.10801424544424,
9.54362812101476E-02,
7.92931937656223E-02,
0.060876914527277,
4.16208081159964E-02,
0.022963184864223,
6.21371437875127E-03,
-7.56345188122577E-03,
-1.76380999373613E-02,
-2.36654919291117E-02,
-2.56967990608734E-02,
-2.41487810268221E-02,
-1.97374929484199E-02,
-1.33845798948831E-02,
-6.10743160737485E-03,
1.09416803644867E-03,
7.34237158895045E-03,
1.19655799715868E-02,
1.45544625372677E-02,
1.49849829704066E-02,
1.34077022899271E-02,
1.02065286986407E-02,
5.9334530059929E-03,
1.22827042213419E-03,
-3.26641259415541E-03,
-6.98456369413089E-03,
-0.009501382406037,
-1.05763476008097E-02,
-1.01707322885837E-02,
-8.43895965553601E-03,
-5.69639250641138E-03,
-2.36889949187402E-03,
1.06849146908629E-03,
4.15556795919664E-03,
6.5053481618408E-03,
7.8498586051297E-03,
8.06813925100415E-03,
7.19383727671873E-03,
5.40246536908285E-03,
2.98098200886886E-03,
2.84479829041667E-04,
-2.31380685655338E-03,
-4.47239453044281E-03,
-5.92488488302496E-03,
-6.51142043052731E-03,
-6.19471366909442E-03,
-5.05925748986435E-03,
-3.29456955917589E-03,
-1.1653647731412E-03,
1.02686813248091E-03,
2.98547412888714E-03,
4.45781899266792E-03,
5.26699760136024E-03,
5.33219109239423E-03,
4.67544734649579E-03,
3.41453428113533E-03,
1.74336474969636E-03,
-9.69260431551716E-05,
-1.85205268155853E-03,
-3.28908130995446E-03,
-4.22676138180854E-03,
-4.5578114320367E-03,
-4.26049313903086E-03,
-3.39832768243562E-03,
-2.10842588711257E-03,
-5.80401384761846E-04,
9.70980287347591E-04,
2.33554032042541E-03,
3.33575390939662E-03,
3.8494509842216E-03,
3.82429905619735E-03,
3.28241232687174E-03,
2.31480748184832E-03,
1.06679427863957E-03,
-2.83433988590752E-04,
-1.54990967745021E-03,
-2.56420588087862E-03,
-3.19755078968172E-03,
-3.37687526123683E-03,
-3.0928347087259E-03,
-2.39898719497264E-03,
-1.40252380256192E-03,
-2.48069931043484E-04,
9.03040521107917E-04,
1.89508316057526E-03,
2.5987964185872E-03,
2.92800611374705E-03,
2.84991266495946E-03,
2.38785133901766E-03,
1.61638681020172E-03,
6.49640758769128E-04,
-3.7536395630419E-04,
-1.31794136025265E-03,
-2.05288612882479E-03,
-2.48694034757958E-03,
-2.57043988642794E-03,
-2.30271235650441E-03,
-1.73068532524285E-03,
-9.41096860269775E-04,
-4.75532290246456E-05,
8.25662030342439E-04,
1.56074078337845E-03,
2.06211546785384E-03,
2.26874450672835E-03,
2.16135804994036E-03,
1.76383183591011E-03,
1.13867598801061E-03,
3.77422502219123E-04,
-4.12637115191104E-04,
-1.12346073731216E-03,
-1.66092660711633E-03,
-1.95718837186296E-03,
-1.97910727762026E-03,
-1.73173274917677E-03,
-1.25650339060125E-03,
-6.24565502140761E-04,
7.37434111457396E-05,
7.41708962269882E-04,
1.28954761535022E-03,
1.64638849112164E-03,
1.76934213606894E-03,
1.64850997457329E-03,
1.30737185076807E-03,
7.98632361223091E-04,
1.96220604379898E-04,
-4.15359940500072E-04,
-9.52809395996536E-04,
-1.34530593218871E-03,
-1.54376049087077E-03,
-1.52685337856858E-03,
-1.30312573013314E-03,
-9.08955492219526E-04,
-4.02811422525139E-04,
1.43327152971923E-04,
6.54137597719031E-04,
1.0612812843461E-03,
1.31248334486752E-03,
1.3781672729596E-03,
1.25481357915796E-03,
9.64680860536062E-04,
5.52032473142959E-04,
7.64828268590489E-05,
-3.95548889343828E-04,
-8.00061043652871E-04,
-1.08409477228995E-03,
-1.21260697881321E-03,
-1.17270781406782E-03,
-9.74763377733084E-04,
-6.50305206091581E-04,
-2.47124084868245E-04,
1.77702336441268E-04,
5.65839512057467E-04,
8.6566058344627E-04,
1.03906440833276E-03,
1.06625356603348E-03,
9.47882667319901E-04,
7.04362436393851E-04,
3.72498347533531E-04,
5.59846047464961E-17,
-3.61328712824451E-04,
-6.62753079744486E-04,
-8.65139685672427E-04,
-9.4398739395698E-04,
-8.92317668591313E-04,
-7.21095175202906E-04,
-4.57195613618408E-04,
-1.39271094974664E-04,
1.87860959921469E-04,
4.79497292808301E-04,
6.97121958035175E-04,
8.13453022368273E-04,
8.15807315704632E-04,
7.07376668087887E-04,
5.06305827381731E-04,
2.42764934914238E-04,
-4.5523396846382E-05,
-3.18646048269203E-04,
-5.39993182352118E-04,
-6.81132064606672E-04,
-7.25416814018607E-04,
-6.69882125404327E-04,
-5.25216778517018E-04,
-3.13880649695086E-04,
-6.6679808766564E-05,
1.81685565437725E-04,
3.97461997810631E-04,
5.52400997661569E-04,
6.27423273392398E-04,
6.1491854642264E-04,
5.19411467801817E-04,
3.56555331104747E-04,
1.50644313031941E-04,
-6.8969320753154E-05,
-2.72029869028777E-04,
-4.3152052885919E-04,
-5.27229850793684E-04,
-5.48275552065005E-04,
-4.94276221761938E-04,
-3.75055820274168E-04,
-2.08969580638708E-04,
-2.01248546793022E-05,
1.65088013808285E-04,
3.21659454584507E-04,
4.2931370757631E-04,
4.75104991919175E-04,
4.54928772654997E-04,
3.73778982247847E-04,
2.44758676473575E-04,
8.70212473860079E-05,
-7.70409471672218E-05,
-2.24951915929093E-04,
-3.37209820870782E-04,
-3.99834185058333E-04,
-4.0607333724229E-04,
-3.57068779583035E-04,
-2.61422419999934E-04,
-1.33764056121147E-04,
7.45062755800353E-06,
1.42584486440094E-04,
2.5352993690135E-04,
3.26114985012053E-04,
3.51887480716507E-04,
3.29056904819955E-04,
2.62495775819491E-04,
1.62834505957522E-04,
4.48059189235795E-05,
-7.4907721083407E-05,
-1.80013703858927E-04,
-2.56808464758698E-04,
-2.95943322001588E-04,
-2.93531944257087E-04,
-2.51473223461644E-04,
-1.76974930962404E-04,
-8.13730778568352E-05,
2.15656117181478E-05,
1.17607279986277E-04,
1.94002951759912E-04,
2.41163516117248E-04,
2.53840139829003E-04,
2.31668394867289E-04,
1.79026645025985E-04,
1.04254697840109E-04,
1.83642083602005E-05,
-6.65634849043368E-05,
-1.39061458290148E-04,
-1.89810529434319E-04,
-2.12818908333164E-04,
-2.06101614037666E-04,
-1.71787224835238E-04,
-1.15660588585853E-04,
-4.62267411982861E-05,
2.65568429442928E-05,
9.2693288495645E-05,
1.43506084275265E-04,
1.72762476206625E-04,
1.77417241680811E-04,
1.57891385592954E-04,
1.17867364450305E-04,
6.36492212600666E-05,
3.1933674141078E-06,
-5.50437814716729E-05,
-1.03276352381299E-04,
-1.35417387863975E-04,
-1.4783103208243E-04,
-1.39718056353472E-04,
-1.13098279241855E-04,
-7.24100954654402E-05,
-2.37987371107575E-05,
2.57957676667815E-05,
6.96175621019232E-05,
1.02004321634738E-04,
1.19106150305943E-04,
1.19324669704923E-04,
1.03425276963034E-04,
7.43223783597081E-05,
3.65821151860161E-05,
-4.27635002246548E-06,
-4.25761675011832E-05,
-7.32616525492422E-05,
-9.25551579472124E-05,
-9.84081712896871E-05,
-9.06949999778749E-05,
-7.11351073597517E-05,
-4.29679634160319E-05,
-1.04369734063661E-05,
2.18376006149165E-05,
4.95055644401321E-05,
6.90642167333466E-05,
7.82909144379751E-05,
7.64790499869327E-05,
6.44552580005777E-05,
4.43867682203568E-05,
1.94161141435325E-05,
-6.81786032144021E-06,
-3.07012396582399E-05,
-4.91350199192509E-05,
-5.99285012522365E-05,
-6.2047474930714E-05,
-5.569111115427E-05,
-4.21963639841112E-05,
-2.37924452298114E-05,
-3.24726672445468E-06,
1.65397250423175E-05,
3.29395568356585E-05,
4.39358098111073E-05,
4.8363327050366E-05,
4.60167789805457E-05,
3.76217467188432E-05,
2.46803190710461E-05,
9.21976983934031E-06,
-6.51544970945648E-06,
-2.03827387024668E-05,
-3.06269314824131E-05,
-3.60952551872196E-05,
-3.63564659794252E-05,
-3.17137270159562E-05,
-2.31160998598231E-05,
-1.19872192071837E-05,
-3.5319469731581E-18,
1.11681364233192E-05,
2.00645345448009E-05,
2.56444887001235E-05,
2.73861211586086E-05,
2.53256588639171E-05,
2.00136005065911E-05,
1.24032129742481E-05,
3.6914252979467E-06,
-4.86255935698405E-06,
-1.21142522895573E-05,
-1.71822510213959E-05,
-1.9549463311611E-05,
-1.91065438560683E-05,
-1.61357381047252E-05,
-1.12417930667653E-05,
-5.24352124433557E-06,
9.55881530979813E-07,
6.50003030964996E-06,
1.06935981776736E-05,
1.30849504817894E-05,
1.35080893310192E-05,
1.2081288051041E-05,
9.16613249541993E-06,
5.29600551865796E-06,
1.086665580714E-06,
-2.85691036057063E-06,
-6.02388471496826E-06,
-8.06011472840016E-06,
-8.80281661458557E-06,
-8.28486910255114E-06,
-6.71088358672802E-06,
-4.41107148777256E-06,
-1.78163334120875E-06,
7.78419775752953E-07,
2.92447571220828E-06,
4.40977516126714E-06,
5.11007631269058E-06
};

static const double dDec8FilterGain = 1.0;
static const double dpDec8FilterCoeffs[] = {
5.11007631269058E-06,
4.40977516126714E-06,
2.92447571220828E-06,
7.78419775752953E-07,
-1.78163334120875E-06,
-4.41107148777256E-06,
-6.71088358672802E-06,
-8.28486910255114E-06,
-8.80281661458557E-06,
-8.06011472840016E-06,
-6.02388471496826E-06,
-2.85691036057063E-06,
1.086665580714E-06,
5.29600551865796E-06,
9.16613249541993E-06,
1.2081288051041E-05,
1.35080893310192E-05,
1.30849504817894E-05,
1.06935981776736E-05,
6.50003030964996E-06,
9.55881530979813E-07,
-5.24352124433557E-06,
-1.12417930667653E-05,
-1.61357381047252E-05,
-1.91065438560683E-05,
-1.9549463311611E-05,
-1.71822510213959E-05,
-1.21142522895573E-05,
-4.86255935698405E-06,
3.6914252979467E-06,
1.24032129742481E-05,
2.00136005065911E-05,
2.53256588639171E-05,
2.73861211586086E-05,
2.56444887001235E-05,
2.00645345448009E-05,
1.11681364233192E-05,
-3.5319469731581E-18,
-1.19872192071837E-05,
-2.31160998598231E-05,
-3.17137270159562E-05,
-3.63564659794252E-05,
-3.60952551872196E-05,
-3.06269314824131E-05,
-2.03827387024668E-05,
-6.51544970945648E-06,
9.21976983934031E-06,
2.46803190710461E-05,
3.76217467188432E-05,
4.60167789805457E-05,
4.8363327050366E-05,
4.39358098111073E-05,
3.29395568356585E-05,
1.65397250423175E-05,
-3.24726672445468E-06,
-2.37924452298114E-05,
-4.21963639841112E-05,
-5.569111115427E-05,
-6.2047474930714E-05,
-5.99285012522365E-05,
-4.91350199192509E-05,
-3.07012396582399E-05,
-6.81786032144021E-06,
1.94161141435325E-05,
4.43867682203568E-05,
6.44552580005777E-05,
7.64790499869327E-05,
7.82909144379751E-05,
6.90642167333466E-05,
4.95055644401321E-05,
2.18376006149165E-05,
-1.04369734063661E-05,
-4.29679634160319E-05,
-7.11351073597517E-05,
-9.06949999778749E-05,
-9.84081712896871E-05,
-9.25551579472124E-05,
-7.32616525492422E-05,
-4.25761675011832E-05,
-4.27635002246548E-06,
3.65821151860161E-05,
7.43223783597081E-05,
1.03425276963034E-04,
1.19324669704923E-04,
1.19106150305943E-04,
1.02004321634738E-04,
6.96175621019232E-05,
2.57957676667815E-05,
-2.37987371107575E-05,
-7.24100954654402E-05,
-1.13098279241855E-04,
-1.39718056353472E-04,
-1.4783103208243E-04,
-1.35417387863975E-04,
-1.03276352381299E-04,
-5.50437814716729E-05,
3.1933674141078E-06,
6.36492212600666E-05,
1.17867364450305E-04,
1.57891385592954E-04,
1.77417241680811E-04,
1.72762476206625E-04,
1.43506084275265E-04,
9.2693288495645E-05,
2.65568429442928E-05,
-4.62267411982861E-05,
-1.15660588585853E-04,
-1.71787224835238E-04,
-2.06101614037666E-04,
-2.12818908333164E-04,
-1.89810529434319E-04,
-1.39061458290148E-04,
-6.65634849043368E-05,
1.83642083602005E-05,
1.04254697840109E-04,
1.79026645025985E-04,
2.31668394867289E-04,
2.53840139829003E-04,
2.41163516117248E-04,
1.94002951759912E-04,
1.17607279986277E-04,
2.15656117181478E-05,
-8.13730778568352E-05,
-1.76974930962404E-04,
-2.51473223461644E-04,
-2.93531944257087E-04,
-2.95943322001588E-04,
-2.56808464758698E-04,
-1.80013703858927E-04,
-7.4907721083407E-05,
4.48059189235795E-05,
1.62834505957522E-04,
2.62495775819491E-04,
3.29056904819955E-04,
3.51887480716507E-04,
3.26114985012053E-04,
2.5352993690135E-04,
1.42584486440094E-04,
7.45062755800353E-06,
-1.33764056121147E-04,
-2.61422419999934E-04,
-3.57068779583035E-04,
-4.0607333724229E-04,
-3.99834185058333E-04,
-3.37209820870782E-04,
-2.24951915929093E-04,
-7.70409471672218E-05,
8.70212473860079E-05,
2.44758676473575E-04,
3.73778982247847E-04,
4.54928772654997E-04,
4.75104991919175E-04,
4.2931370757631E-04,
3.21659454584507E-04,
1.65088013808285E-04,
-2.01248546793022E-05,
-2.08969580638708E-04,
-3.75055820274168E-04,
-4.94276221761938E-04,
-5.48275552065005E-04,
-5.27229850793684E-04,
-4.3152052885919E-04,
-2.72029869028777E-04,
-6.8969320753154E-05,
1.50644313031941E-04,
3.56555331104747E-04,
5.19411467801817E-04,
6.1491854642264E-04,
6.27423273392398E-04,
5.52400997661569E-04,
3.97461997810631E-04,
1.81685565437725E-04,
-6.6679808766564E-05,
-3.13880649695086E-04,
-5.25216778517018E-04,
-6.69882125404327E-04,
-7.25416814018607E-04,
-6.81132064606672E-04,
-5.39993182352118E-04,
-3.18646048269203E-04,
-4.5523396846382E-05,
2.42764934914238E-04,
5.06305827381731E-04,
7.07376668087887E-04,
8.15807315704632E-04,
8.13453022368273E-04,
6.97121958035175E-04,
4.79497292808301E-04,
1.87860959921469E-04,
-1.39271094974664E-04,
-4.57195613618408E-04,
-7.21095175202906E-04,
-8.92317668591313E-04,
-9.4398739395698E-04,
-8.65139685672427E-04,
-6.62753079744486E-04,
-3.61328712824451E-04,
5.59846047464961E-17,
3.72498347533531E-04,
7.04362436393851E-04,
9.47882667319901E-04,
1.06625356603348E-03,
1.03906440833276E-03,
8.6566058344627E-04,
5.65839512057467E-04,
1.77702336441268E-04,
-2.47124084868245E-04,
-6.50305206091581E-04,
-9.74763377733084E-04,
-1.17270781406782E-03,
-1.21260697881321E-03,
-1.08409477228995E-03,
-8.00061043652871E-04,
-3.95548889343828E-04,
7.64828268590489E-05,
5.52032473142959E-04,
9.64680860536062E-04,
1.25481357915796E-03,
1.3781672729596E-03,
1.31248334486752E-03,
1.0612812843461E-03,
6.54137597719031E-04,
1.43327152971923E-04,
-4.02811422525139E-04,
-9.08955492219526E-04,
-1.30312573013314E-03,
-1.52685337856858E-03,
-1.54376049087077E-03,
-1.34530593218871E-03,
-9.52809395996536E-04,
-4.15359940500072E-04,
1.96220604379898E-04,
7.98632361223091E-04,
1.30737185076807E-03,
1.64850997457329E-03,
1.76934213606894E-03,
1.64638849112164E-03,
1.28954761535022E-03,
7.41708962269882E-04,
7.37434111457396E-05,
-6.24565502140761E-04,
-1.25650339060125E-03,
-1.73173274917677E-03,
-1.97910727762026E-03,
-1.95718837186296E-03,
-1.66092660711633E-03,
-1.12346073731216E-03,
-4.12637115191104E-04,
3.77422502219123E-04,
1.13867598801061E-03,
1.76383183591011E-03,
2.16135804994036E-03,
2.26874450672835E-03,
2.06211546785384E-03,
1.56074078337845E-03,
8.25662030342439E-04,
-4.75532290246456E-05,
-9.41096860269775E-04,
-1.73068532524285E-03,
-2.30271235650441E-03,
-2.57043988642794E-03,
-2.48694034757958E-03,
-2.05288612882479E-03,
-1.31794136025265E-03,
-3.7536395630419E-04,
6.49640758769128E-04,
1.61638681020172E-03,
2.38785133901766E-03,
2.84991266495946E-03,
2.92800611374705E-03,
2.5987964185872E-03,
1.89508316057526E-03,
9.03040521107917E-04,
-2.48069931043484E-04,
-1.40252380256192E-03,
-2.39898719497264E-03,
-3.0928347087259E-03,
-3.37687526123683E-03,
-3.19755078968172E-03,
-2.56420588087862E-03,
-1.54990967745021E-03,
-2.83433988590752E-04,
1.06679427863957E-03,
2.31480748184832E-03,
3.28241232687174E-03,
3.82429905619735E-03,
3.8494509842216E-03,
3.33575390939662E-03,
2.33554032042541E-03,
9.70980287347591E-04,
-5.80401384761846E-04,
-2.10842588711257E-03,
-3.39832768243562E-03,
-4.26049313903086E-03,
-4.5578114320367E-03,
-4.22676138180854E-03,
-3.28908130995446E-03,
-1.85205268155853E-03,
-9.69260431551716E-05,
1.74336474969636E-03,
3.41453428113533E-03,
4.67544734649579E-03,
5.33219109239423E-03,
5.26699760136024E-03,
4.45781899266792E-03,
2.98547412888714E-03,
1.02686813248091E-03,
-1.1653647731412E-03,
-3.29456955917589E-03,
-5.05925748986435E-03,
-6.19471366909442E-03,
-6.51142043052731E-03,
-5.92488488302496E-03,
-4.47239453044281E-03,
-2.31380685655338E-03,
2.84479829041667E-04,
2.98098200886886E-03,
5.40246536908285E-03,
7.19383727671873E-03,
8.06813925100415E-03,
7.8498586051297E-03,
6.5053481618408E-03,
4.15556795919664E-03,
1.06849146908629E-03,
-2.36889949187402E-03,
-5.69639250641138E-03,
-8.43895965553601E-03,
-1.01707322885837E-02,
-1.05763476008097E-02,
-0.009501382406037,
-6.98456369413089E-03,
-3.26641259415541E-03,
1.22827042213419E-03,
5.9334530059929E-03,
1.02065286986407E-02,
1.34077022899271E-02,
1.49849829704066E-02,
1.45544625372677E-02,
1.19655799715868E-02,
7.34237158895045E-03,
1.09416803644867E-03,
-6.10743160737485E-03,
-1.33845798948831E-02,
-1.97374929484199E-02,
-2.41487810268221E-02,
-2.56967990608734E-02,
-2.36654919291117E-02,
-1.76380999373613E-02,
-7.56345188122577E-03,
6.21371437875127E-03,
0.022963184864223,
4.16208081159964E-02,
0.060876914527277,
7.92931937656223E-02,
9.54362812101476E-02,
0.10801424544424,
0.116001630677908,
0.118739769000088,
0.116001630677908,
0.10801424544424,
9.54362812101476E-02,
7.92931937656223E-02,
0.060876914527277,
4.16208081159964E-02,
0.022963184864223,
6.21371437875127E-03,
-7.56345188122577E-03,
-1.76380999373613E-02,
-2.36654919291117E-02,
-2.56967990608734E-02,
-2.41487810268221E-02,
-1.97374929484199E-02,
-1.33845798948831E-02,
-6.10743160737485E-03,
1.09416803644867E-03,
7.34237158895045E-03,
1.19655799715868E-02,
1.45544625372677E-02,
1.49849829704066E-02,
1.34077022899271E-02,
1.02065286986407E-02,
5.9334530059929E-03,
1.22827042213419E-03,
-3.26641259415541E-03,
-6.98456369413089E-03,
-0.009501382406037,
-1.05763476008097E-02,
-1.01707322885837E-02,
-8.43895965553601E-03,
-5.69639250641138E-03,
-2.36889949187402E-03,
1.06849146908629E-03,
4.15556795919664E-03,
6.5053481618408E-03,
7.8498586051297E-03,
8.06813925100415E-03,
7.19383727671873E-03,
5.40246536908285E-03,
2.98098200886886E-03,
2.84479829041667E-04,
-2.31380685655338E-03,
-4.47239453044281E-03,
-5.92488488302496E-03,
-6.51142043052731E-03,
-6.19471366909442E-03,
-5.05925748986435E-03,
-3.29456955917589E-03,
-1.1653647731412E-03,
1.02686813248091E-03,
2.98547412888714E-03,
4.45781899266792E-03,
5.26699760136024E-03,
5.33219109239423E-03,
4.67544734649579E-03,
3.41453428113533E-03,
1.74336474969636E-03,
-9.69260431551716E-05,
-1.85205268155853E-03,
-3.28908130995446E-03,
-4.22676138180854E-03,
-4.5578114320367E-03,
-4.26049313903086E-03,
-3.39832768243562E-03,
-2.10842588711257E-03,
-5.80401384761846E-04,
9.70980287347591E-04,
2.33554032042541E-03,
3.33575390939662E-03,
3.8494509842216E-03,
3.82429905619735E-03,
3.28241232687174E-03,
2.31480748184832E-03,
1.06679427863957E-03,
-2.83433988590752E-04,
-1.54990967745021E-03,
-2.56420588087862E-03,
-3.19755078968172E-03,
-3.37687526123683E-03,
-3.0928347087259E-03,
-2.39898719497264E-03,
-1.40252380256192E-03,
-2.48069931043484E-04,
9.03040521107917E-04,
1.89508316057526E-03,
2.5987964185872E-03,
2.92800611374705E-03,
2.84991266495946E-03,
2.38785133901766E-03,
1.61638681020172E-03,
6.49640758769128E-04,
-3.7536395630419E-04,
-1.31794136025265E-03,
-2.05288612882479E-03,
-2.48694034757958E-03,
-2.57043988642794E-03,
-2.30271235650441E-03,
-1.73068532524285E-03,
-9.41096860269775E-04,
-4.75532290246456E-05,
8.25662030342439E-04,
1.56074078337845E-03,
2.06211546785384E-03,
2.26874450672835E-03,
2.16135804994036E-03,
1.76383183591011E-03,
1.13867598801061E-03,
3.77422502219123E-04,
-4.12637115191104E-04,
-1.12346073731216E-03,
-1.66092660711633E-03,
-1.95718837186296E-03,
-1.97910727762026E-03,
-1.73173274917677E-03,
-1.25650339060125E-03,
-6.24565502140761E-04,
7.37434111457396E-05,
7.41708962269882E-04,
1.28954761535022E-03,
1.64638849112164E-03,
1.76934213606894E-03,
1.64850997457329E-03,
1.30737185076807E-03,
7.98632361223091E-04,
1.96220604379898E-04,
-4.15359940500072E-04,
-9.52809395996536E-04,
-1.34530593218871E-03,
-1.54376049087077E-03,
-1.52685337856858E-03,
-1.30312573013314E-03,
-9.08955492219526E-04,
-4.02811422525139E-04,
1.43327152971923E-04,
6.54137597719031E-04,
1.0612812843461E-03,
1.31248334486752E-03,
1.3781672729596E-03,
1.25481357915796E-03,
9.64680860536062E-04,
5.52032473142959E-04,
7.64828268590489E-05,
-3.95548889343828E-04,
-8.00061043652871E-04,
-1.08409477228995E-03,
-1.21260697881321E-03,
-1.17270781406782E-03,
-9.74763377733084E-04,
-6.50305206091581E-04,
-2.47124084868245E-04,
1.77702336441268E-04,
5.65839512057467E-04,
8.6566058344627E-04,
1.03906440833276E-03,
1.06625356603348E-03,
9.47882667319901E-04,
7.04362436393851E-04,
3.72498347533531E-04,
5.59846047464961E-17,
-3.61328712824451E-04,
-6.62753079744486E-04,
-8.65139685672427E-04,
-9.4398739395698E-04,
-8.92317668591313E-04,
-7.21095175202906E-04,
-4.57195613618408E-04,
-1.39271094974664E-04,
1.87860959921469E-04,
4.79497292808301E-04,
6.97121958035175E-04,
8.13453022368273E-04,
8.15807315704632E-04,
7.07376668087887E-04,
5.06305827381731E-04,
2.42764934914238E-04,
-4.5523396846382E-05,
-3.18646048269203E-04,
-5.39993182352118E-04,
-6.81132064606672E-04,
-7.25416814018607E-04,
-6.69882125404327E-04,
-5.25216778517018E-04,
-3.13880649695086E-04,
-6.6679808766564E-05,
1.81685565437725E-04,
3.97461997810631E-04,
5.52400997661569E-04,
6.27423273392398E-04,
6.1491854642264E-04,
5.19411467801817E-04,
3.56555331104747E-04,
1.50644313031941E-04,
-6.8969320753154E-05,
-2.72029869028777E-04,
-4.3152052885919E-04,
-5.27229850793684E-04,
-5.48275552065005E-04,
-4.94276221761938E-04,
-3.75055820274168E-04,
-2.08969580638708E-04,
-2.01248546793022E-05,
1.65088013808285E-04,
3.21659454584507E-04,
4.2931370757631E-04,
4.75104991919175E-04,
4.54928772654997E-04,
3.73778982247847E-04,
2.44758676473575E-04,
8.70212473860079E-05,
-7.70409471672218E-05,
-2.24951915929093E-04,
-3.37209820870782E-04,
-3.99834185058333E-04,
-4.0607333724229E-04,
-3.57068779583035E-04,
-2.61422419999934E-04,
-1.33764056121147E-04,
7.45062755800353E-06,
1.42584486440094E-04,
2.5352993690135E-04,
3.26114985012053E-04,
3.51887480716507E-04,
3.29056904819955E-04,
2.62495775819491E-04,
1.62834505957522E-04,
4.48059189235795E-05,
-7.4907721083407E-05,
-1.80013703858927E-04,
-2.56808464758698E-04,
-2.95943322001588E-04,
-2.93531944257087E-04,
-2.51473223461644E-04,
-1.76974930962404E-04,
-8.13730778568352E-05,
2.15656117181478E-05,
1.17607279986277E-04,
1.94002951759912E-04,
2.41163516117248E-04,
2.53840139829003E-04,
2.31668394867289E-04,
1.79026645025985E-04,
1.04254697840109E-04,
1.83642083602005E-05,
-6.65634849043368E-05,
-1.39061458290148E-04,
-1.89810529434319E-04,
-2.12818908333164E-04,
-2.06101614037666E-04,
-1.71787224835238E-04,
-1.15660588585853E-04,
-4.62267411982861E-05,
2.65568429442928E-05,
9.2693288495645E-05,
1.43506084275265E-04,
1.72762476206625E-04,
1.77417241680811E-04,
1.57891385592954E-04,
1.17867364450305E-04,
6.36492212600666E-05,
3.1933674141078E-06,
-5.50437814716729E-05,
-1.03276352381299E-04,
-1.35417387863975E-04,
-1.4783103208243E-04,
-1.39718056353472E-04,
-1.13098279241855E-04,
-7.24100954654402E-05,
-2.37987371107575E-05,
2.57957676667815E-05,
6.96175621019232E-05,
1.02004321634738E-04,
1.19106150305943E-04,
1.19324669704923E-04,
1.03425276963034E-04,
7.43223783597081E-05,
3.65821151860161E-05,
-4.27635002246548E-06,
-4.25761675011832E-05,
-7.32616525492422E-05,
-9.25551579472124E-05,
-9.84081712896871E-05,
-9.06949999778749E-05,
-7.11351073597517E-05,
-4.29679634160319E-05,
-1.04369734063661E-05,
2.18376006149165E-05,
4.95055644401321E-05,
6.90642167333466E-05,
7.82909144379751E-05,
7.64790499869327E-05,
6.44552580005777E-05,
4.43867682203568E-05,
1.94161141435325E-05,
-6.81786032144021E-06,
-3.07012396582399E-05,
-4.91350199192509E-05,
-5.99285012522365E-05,
-6.2047474930714E-05,
-5.569111115427E-05,
-4.21963639841112E-05,
-2.37924452298114E-05,
-3.24726672445468E-06,
1.65397250423175E-05,
3.29395568356585E-05,
4.39358098111073E-05,
4.8363327050366E-05,
4.60167789805457E-05,
3.76217467188432E-05,
2.46803190710461E-05,
9.21976983934031E-06,
-6.51544970945648E-06,
-2.03827387024668E-05,
-3.06269314824131E-05,
-3.60952551872196E-05,
-3.63564659794252E-05,
-3.17137270159562E-05,
-2.31160998598231E-05,
-1.19872192071837E-05,
-3.5319469731581E-18,
1.11681364233192E-05,
2.00645345448009E-05,
2.56444887001235E-05,
2.73861211586086E-05,
2.53256588639171E-05,
2.00136005065911E-05,
1.24032129742481E-05,
3.6914252979467E-06,
-4.86255935698405E-06,
-1.21142522895573E-05,
-1.71822510213959E-05,
-1.9549463311611E-05,
-1.91065438560683E-05,
-1.61357381047252E-05,
-1.12417930667653E-05,
-5.24352124433557E-06,
9.55881530979813E-07,
6.50003030964996E-06,
1.06935981776736E-05,
1.30849504817894E-05,
1.35080893310192E-05,
1.2081288051041E-05,
9.16613249541993E-06,
5.29600551865796E-06,
1.086665580714E-06,
-2.85691036057063E-06,
-6.02388471496826E-06,
-8.06011472840016E-06,
-8.80281661458557E-06,
-8.28486910255114E-06,
-6.71088358672802E-06,
-4.41107148777256E-06,
-1.78163334120875E-06,
7.78419775752953E-07,
2.92447571220828E-06,
4.40977516126714E-06,
5.11007631269058E-06
};

